#Set working directory to where "dynamicSLD.R" is located
setwd("/Users/macw/Desktop/dynamic/")

#See what files are in the current working directory
list.files()

#Load the functions
source("dynamicSLD.R")

#Confirm the environment now holds the dynamicSLD functions
ls()

#################################################################
#See the general trend of an individual
#Expects a text file consisting of a single column headed with subject ID
smooth("jorge.txt")
#Optional parameter to indicate you want to plot on top of existing graph (instead of overwriting it)
smooth("alberto.txt", TRUE)

#See the general trend of an individual
#Expects a vector
smoothLocal(jorge)

#See the "sliding window" of min-max differences between two individuals
#Expects a tab-delimited text file consisting of two columns headed with subject IDs
#Default window size is 5 
minMax("jorge.txt")
#Optional parameter to set window size:
minMax("jorge.txt", 2) 

#Run Monte Carlo resampling to determine if one individual is more variable than another.
#Returns a p-value (probability an individual is more variaible than another by chance)
#Expects a tab-delimited text file consisting of two columns headed with subject IDs
#Default number of resamplings is 5000
isMoreVariable("sampleData.txt")
#Optional parameter to set number of resamplings:
isMoreVariable("sampleData.txt", 10000)

#Run Monte Carlo resampling to determine if an individual contains significant peaks.
#Returns a p-value (how probable "peaks" were just by chance)
#Expects a tab-delimited text file consisting of two columns headed with subject IDs
#Default number of resamplings is 5000
hasSignificantPeaks("alberto.txt")
#Optional parameter to set number of resamplings:
hasSignificantPeaks("alberto.txt", 10000)
