:- module(act2,[]).

count :-
	debug:debug_call(1,count_edges:
	  (  act2_chart:current_predicate(_,X),
	     report_count_edges(act2_chart:X),
	     fail
	  ;  true
	  )
			).

count(X) :-
	count_edges:program_space(X).

clean :-
	(  act2_chart:current_predicate(_,X), 
	   act2_chart:retractall(X), 
	   fail
	;  true
	).


parse(o(Cat,String,_)):-
	P0 = 1,
	length(String,PP), P is PP+1,
	count_edges:reset_program_space,
	process_word_graph,
	user:result_cat(Cat,Syn),
	user:result_tree(Cat,Tree),
	act2_chart:second(P0,P,Syn,Ref),
	second_pass(Ref,Syn,Tree).


process_word_graph :-
	( %lexical_analysis:
	  %    clause(lex_analysis(Begin,Lex_End,LHS,_,LHS_Conf,Id,_,_),_,Ref),
          lex:lex(Begin,Lex_End,LHS,Ids),
	  act2_chart:assertz(leaves(Ids), HRef),
	  process_completed(Begin, Lex_End,  LHS, HRef),
	  fail
	; true
	).

process_completed(Begin, End,  LHS,  Ref) :-
	initiate_entries(Begin, End, LHS,  Ref),
	extend_entries(Begin, End, LHS,  Ref),
	find_top_cat(Begin, End, LHS,  Ref).

initiate_entries(Begin, End, Mem,  Ref) :-
	( bu_in:grammar_rule(Mem, RuleId, LHS, _,  RHS_suf),
	  continue(RHS_suf,RuleId,[Ref],Begin,End,LHS),
	  fail
	; true
	).

extend_entries(Begin, End, Mem, New_Ref) :-
	( Mem =.. [F|Args],
	  ITEM =.. [F,Begin,ItBegin,LHS,RHS_Suf,Old_Refs,RuleId|Args],
	  act2_chart:ITEM,
	  lists:append(Old_Refs, [New_Ref], Refs),
	  continue(RHS_Suf,RuleId,Refs,ItBegin,End,LHS),
	  fail
	; true
	).

continue([],RuleId,Refs,ItBegin,End,LHS) :-
	act2_chart:assertz(tree(RuleId,Refs),Ref),
	process_completed(ItBegin,End,LHS,Ref).
continue([H|T],RuleId,Refs,ItBegin,End,LHS) :-
	store_item(ItBegin,End,RuleId,LHS,[H|T],Refs).

find_top_cat(Begin,End,Cat,Ref) :-
	(  grammar:top_category(Cat),
	   act2_chart:assertz(second(Begin,End,Cat,Ref)),
	   fail
	;  true
	).

store_item(Begin, End, RuleId, LHS, [Hd|Tail], Subtrees) :-
	Hd =.. [F|Args],
	ITEM =.. [F,End,Begin,LHS,Tail,Subtrees,RuleId|Args],
	act2_chart:assert(ITEM).

compile_grammar(File) :-
	user:ensure_grammar_compiled_for_parser(bu,File).

second_pass(Ref, LHS, Id) :-
	act2_chart:clause(leaves(Ids), true, Ref),
	lists:member(Id,Ids),
	lex_in:total_lex(Id,LHS,_,_).
%	LRef = '$ref'(Refa,Refb),
%	lex:total(Refa,Refb,_,_,LHS,Id).
%	lexical_analysis:clause(lex_analysis(_,_,LHS,LHS,_,Id,_,_),_,LRef).

second_pass(Ref, LHS, tree(RuleId,_,Ids)) :-
	act2_chart:clause(tree(RuleId, Refs), true, Ref),
	mj_in:grammar_rule(RuleId, _, LHS, RHS),
	second_pass_list(Refs,RHS,Ids).

second_pass_list([],[],[]).                    
second_pass_list([Ref|Refs],[El|Els],[Id|Ids]) :-
	second_pass(Ref,El,Id),
	second_pass_list(Refs,Els,Ids).


dump_grammar:-
	bu:dump_grammar.


