:- module(hc_general, []).

% heads can be gapped. Grammar specific goal weakening. 

:- flags:initialize_flag(hc_general_robust,off).

% te doen: een versie die meerdere resultaten oplevert...
parse(o(Result,Phon,_)) :-
	P0=1,
	length(Phon,P1), P is P1+1,
	user:result_cat(Result,Cat),
	user:result_tree(Result,Tree),
	count_edges:reset_program_space,
	assertz(table_item:e(P1)),  % last position a lex entry can start
	parse(Cat,P0,P,P0,P,l,Ref),
	reconstruct_tree(Ref,Cat,Tree).

compile_grammar(_File) :-
	hc_compile:compile_grammar.

dump_grammar:-
	hc_compile:dump_grammar.

weaken(Cat0,Cat) :-
	(  user:weaken(Cat0,Cat)
	-> true
	;  format(user_error,"Warning: no weakening for ~w~n",[Cat0]),
	   Cat0=Cat
	).

parse(Cat,P0,P,E0,E,Eq,Ref) :-
	weaken(Cat,Cat0),    
	(  Eq == l -> PP0=E0 
	;  Eq == r -> PP=E 
	;  true %% var(Eq)
	),
	Cat0=..[F|Args],
	MemoCall =.. [F,E0,E,Eq|Args],
	MemoItem =.. [F,PP0,PP|Args],
        (   a_more_general(table_goal:MemoCall)  
	->  true             
	;   ( predict(Cat0,PP0,PP,E0,E,Small,QL,QR,His0), 
	      head_corner(Small,QL,QR,Cat0,PP0,PP,E0,E,His),
	      add_item(MemoItem,His0,His),
	      fail
	    ; assertz(table_goal:MemoCall)
	    )
	),
	Cat=Cat0,
	P=PP,
	P0=PP0,
	table_item:clause(MemoItem,_,Ref),
	between(P0,P,E0,E).

add_item(Item,His0,His) :-
	add_item(table_item:Item,IRef),
	IRef='$ref'(IRefA,IRefB),
	(  table_item:'MEMO_HIS'(IRefA,IRefB,His0,His)
	-> true
	;  table_item:assertz('MEMO_HIS'(IRefA,IRefB,His0,His))
	).

predict(Cat,P0,P,_E0,_E,Small,Q,Q,gap(Name)) :-
	hc_in:head_corner_table_gap(Cat,P0,P,Small,Q,Q),
	hc_in:gap(Small,Name).

predict(Cat,P0,P,E0,E,Small,QL,QR,lex(Ids)) :-
	E0 \== E,
	(  var(E0), var(E)
	-> hc_in:head_corner_table_lex(Cat,P0,P,Small,QL,QR),
	   lex:lex(QL,QR,Small,Ids)
	;  gen_left(QL,E0,E),
	   lex:lex(QL,QR,Small,Ids),
	   hc_in:head_corner_table_lex(Cat,P0,P,Small,QL,QR),
	   QR =< E
	).

gen_left(QL,XE0,XE) :-
	(  var(XE0) -> E0 = 1            ; XE0=E0  ),
	(  var(XE)  -> table_item:e(E)   ;  XE=E   ),
	gen_left0(QL,E0,E).

gen_left0(E0,E0,_).
gen_left0(Left,E0,E) :-
	E1 is E0+1,
	E1 < E,
	gen_left0(Left,E1,E).


head_corner(X,Y,Z,X,Y,Z,_,_,[]).
head_corner(Small,Q0,Q,Goal,P0,P,E0,E,[rule(Name,Lhis,Rhis)|His]) :-
	hc_in:headed_rule(Small,Mid,RevLefties,Righties,Name),
	hc_in:head_corner_table(Goal,P0,P,Mid,QL,QR),
	parse_left_ds(RevLefties,QL,Q0,E0,E,Lhis),
	parse_right_ds(Righties,Q,QR,E0,E,Rhis),
	head_corner(Mid,QL,QR,Goal,P0,P,E0,E,His).

parse_left_ds([],L,L,_,_,[]).
parse_left_ds([H|T],L0,L,E0,E,[Ref|His]):-
	ledge(L0,E0,Left),
	redge(L,E,Right),
	(  L1==Left -> Eq=l 
	;  L==Right-> Eq=r
	;  true 
	),
	parse(H,L1,L,Left,Right,Eq,Ref),
	parse_left_ds(T,L0,L1,E0,E,His).

parse_right_ds([],L,L,_,_,[]).
parse_right_ds([H|T],L0,L,E0,E,[Ref|His]):-
	ledge(L0,E0,Left),
	redge(L,E,Right),
	(  L0==Left -> Eq=l 
	;  L1==Right-> Eq=r
	;  true 
	),
	parse(H,L0,L1,Left,Right,Eq,Ref),
	parse_right_ds(T,L1,L,E0,E,His).

ledge(A,B,Left) :-
	(  var(A),   var(B) -> true
	;  var(B)           -> Left=A
	;  var(A)           -> Left=B
	;  A =< B           -> Left=B
	;  Left=A
	).
redge(A,B,Left) :-
	(  var(A),   var(B) -> true
	;  var(B)           -> Left=A
	;  var(A)           -> Left=B
	;  A =< B           -> Left=A
	;  Left=B
	).

a_more_specific(Module:Item) :-
	a_more_specific(Module:Item,_).

a_more_specific(Module:Item,Ref) :-
	copy_term(Item,Copy),
	Module:clause(Copy,_,Ref),     % quick check for unification
	Module:clause(Specific,_,Ref), % new copy for subsumption check
	terms:subsumes_chk(Item,Specific).

a_more_general(Module:Item) :-
	a_more_general(Module:Item,_).

a_more_general(Module:Item,Ref):-
	copy_term(Item,Copy),
	Module:clause(Copy,_,Ref),
	Module:clause(General,_,Ref),
	terms:subsumes_chk(General,Item).

add_item(Module:Item,Ref) :-
	(  a_more_general(Module:Item,Ref)
	-> true
	;  Module:assertz(Item,Ref)
	).

% between(+L0,+R0,+L,+R)
between(L0,R0,L,R) :-
        connection(L,L0),
        connection(R0,R).

connection(A,B):-
	(  var(A)                       -> true
	;  var(B)                       -> true
	;  A =< B
	).

reconstruct_tree('$ref'(Refa,Refb),Cat,Tree) :-
	(  table_item:reconstructed(Refa,Refb)
	-> true
	;  table_item:assertz(reconstructed(Refa,Refb)),
	   (  reconstruct_tree0(Refa,Refb,Cat0,Tree0),
	      table_item:assertz(reconstructed(Refa,Refb,Cat0,Tree0)),
	      fail
	   ;  true
	   )
	),
	table_item:reconstructed(Refa,Refb,Cat,Tree).

reconstruct_tree0(Refa,Refb,Cat,Tree) :-
	table_item:'MEMO_HIS'(Refa,Refb,Seed,His),
	reconstruct_tree_seed(Seed,Small,SmallTree),
	reconstruct_tree_hc(His,Small,Cat,SmallTree,Tree).

reconstruct_tree_seed(lex(Ids),Small,tree(Id,_,[])):-
        lists:member(Id,Ids),
	lex_in:total_lex(Id,Small,_,_).


reconstruct_tree_seed(gap(Name),Small,tree(Name,_,[])):-
	hc_in:gap_i(Name,Small).

reconstruct_tree_hc([],C,C,T,T).
reconstruct_tree_hc([rule(Name,Lhis,Rhis)|His],Small,Goal,SmallTree,Tree) :-
	hc_in:headed_rule_i(Name,Small,Mid,Lds,Rds),
	reconstruct_tree_lds(Lhis,Lds,[SmallTree|Rtrees],Trees),
	reconstruct_tree_rds(Rhis,Rds,Rtrees),
	reconstruct_tree_hc(His,Mid,Goal,tree(Name,_,Trees),Tree).

% reverses daughter list as well
reconstruct_tree_lds([],[],T,T).
reconstruct_tree_lds([H|T],[Hd|Td],Trees1,Trees) :-
	reconstruct_tree(H,Hd,TreeL),
	reconstruct_tree_lds(T,Td,[TreeL|Trees1],Trees).

reconstruct_tree_rds([],[],[]).
reconstruct_tree_rds([H|T],[Hd|Td],[TreeR|TdTree]) :-
	reconstruct_tree(H,Hd,TreeR),
	reconstruct_tree_rds(T,Td,TdTree).

clean :-
	(  table_goal:current_predicate(_,X), 
	   functor(X,F,A),
	   table_goal:abolish(F/A), 
	   fail
	;  table_item:current_predicate(_,X),
	   functor(X,F,A),
	   table_item:abolish(F/A),
	   fail
	;  table_between:current_predicate(_,X),
	   functor(X,F,A),
	   table_between:abolish(F/A),
	   fail
	;  true
	).

count(Z) :-
	count_edges:program_space(Z).

count :-
	(  flags:flag(debug,1)
	-> count_edges:report_program_space,
	   count_edges:count_edges((table_goal:current_predicate(_,X),table_goal:X),Goals),
	   format(user_error,"~w goals~n",[Goals]),
	   count_edges:count_edges((table_item:current_predicate(_,Y),
				    functor(Y,F,A),
				    F/A \== 'MEMO_HIS'/4,
				    F/A \== reconstructed/2,
				    F/A \== reconstructed/4,
				    table_item:Y),Items),
	   format(user_error,"~w items~n",[Items]),
	   count_edges:report_count_edges(table_item:'MEMO_HIS'(_,_,_,_)),
	   count_edges:report_count_edges(table_item:reconstructed(_,_)),
	   count_edges:report_count_edges(table_item:reconstructed(_,_,_,_))
	;  flags:flag(debug,2)
	-> count_edges:report_program_space,
	   (  format(user_error,"goals: ~n",[]),
	      table_goal:current_predicate(_,Z),
	      count_edges:report_count_edges(table_goal:Z),
	      fail
	   ;  format(user_error,"~nitems: ~n",[]),
	      table_item:current_predicate(_,Z),
              count_edges:report_count_edges(table_item:Z),
	      fail
	   ;  true
	   )
	;  true
	).

dump_grammar:-
	hc_compile:dump_grammar.

