:- module(inact_p,[]).

% inactive chart parser with packing. First phase uses
% restriction of categories. Second phase adds constraints
% for top category spanning the whole wordgraph (if any) 
% or for all top categories with a partial span (otherwise)

% `cheaper' wf (?)

count :-
	debug:debug_call(1,count_edges:
	  (  inact_p_chart:current_predicate(_,X),
	     report_count_edges(inact_p_chart:X),
	     fail
	  ;  true
	  )			
			).

count(X) :-
	count_edges:program_space(X).

clean :-
	(  inact_p_chart:current_predicate(_,X), 
	   inact_p_chart:retractall(X), 
	   fail
	;  true
	).

parse(o(Cat,Phon,_)):-
	P0 = 1,
	length(Phon,P1), P is P1+1,
	count_edges:reset_program_space,
	process_word_graph,
	user:result_cat(Cat,Syn),
	user:result_tree(Cat,Tree),
	inact_p_chart:second(P0,P,Syn,Ref),
	second_phase(Ref,Syn,Tree).

process_word_graph :-
	(  %lexical_analysis:
           %    clause(lex_analysis(P0,P,M,_,_Sc,Id,_,_),_,Ref),
	   %lex:clause(syn(P0,P,M),_,Ref),
	   lex:lex(P0,P,M,Ids),
	   store(M,P0,P,leaves(Ids),[]),
	   fail
	;  true
	).

% store(+Edge,-Edge)
% stores an edge, and depending on form gives different representation
% of the same edge back. If the edge already exists, then failure.
store(M0,P0,P,RuleId,Refs):-
	weaken(M0,M),
	assertz_if_new(inact_p_chart:inactive(P,P0,M),Ref,New),
	inact_p_chart:assertz(his(Ref,RuleId,Refs)),
	continue_inactive(New,M,P0,P,Ref).

continue_inactive(not_new,_,_,_,_).
continue_inactive(new,M,P0,P,Ref) :-
	extend(M,P0,P,Ref),
	add_for_second_phase(P0,P,M,Ref).

extend(Cat,P1,P,Ref) :-
	(  inact_p_in:inv_rule(Cat,X0,_,Body,RuleId),
	   process_body(Body,P0,P1,Refs),
	   store(X0,P0,P,rule(RuleId),[Ref|Refs]),
	   fail
	;  true
	).

process_body([],P,P,[]).
process_body([H|T],P0,P,[Ref|Refs]) :-
	inact_p_chart:clause(inactive(P,P1,H),_,Ref),
	process_body(T,P0,P1,Refs).

add_for_second_phase(P0,P,M,Ref) :-
	(  grammar:top_category(M),
	   inact_p_chart:assertz(second(P0,P,M,Ref)),
	   fail
	;  true
	).

second_phase(Ref,Cat,Tree) :-
	(  inact_p_chart:reconstructed(Ref)
	-> true
	;  inact_p_chart:assertz(reconstructed(Ref)),
	   (  second_phase0(Ref,Cat0,Tree0),
	      inact_p_chart:assertz(
                    reconstructed(Ref,Cat0,Tree0)),
	      fail
	   ;  true
	   )
	),
	inact_p_chart:reconstructed(Ref,Cat,Tree).

second_phase0(Ref,Cat,Tree) :-
	inact_p_chart:his(Ref,Rule,Refs),
	second_phase2(Rule,Cat,Refs,Tree).

second_phase2(rule(Rule),Cat,Refs,tree(Rule,_,Trees)) :-
	inact_p_in:inv_rule(D1,Cat,Cat,Ds,Rule),
	second_phase_list(Refs,[D1|Ds],Trees).

second_phase2(leaves(Ids),Cat,[],tree(Id,_,[])) :-
	lists:member(Id,Ids),
	lex_in:total_lex(Id,Cat,_,_).
	%Ref='$ref'(Refa,Refb),
	%lex:total(Refa,Refb,_,_,Cat,Id).

second_phase_list([],[],[]).
second_phase_list([Ref0|Refs],[D0|Ds],[Tr0|Trs]) :-
	second_phase(Ref0,D0,Tr0),
	second_phase_list(Refs,Ds,Trs).

compile_grammar(File) :-
	user:ensure_grammar_compiled_for_parser(act,File),
	inact_p_in:abolish(inv_rule/5),
	(  mj_in:grammar_rule(A,B,B2,C),
	   lists:reverse(C,[First|Rest]),
	   inact_p_in:assertz(inv_rule(First,B,B2,Rest,A)),
	   fail
	;  true
	).

dump_grammar:-
	user:dump_predicate(inact_p_in:inv_rule(_,_,_,_,_)).

%% :- flags:initialize_flag(restrict_inact_p,2).
weaken(Term0,Term) :-
	flags:flag(restrict_inact_p,Val),
	(  Val == undefined
	-> Term0=Term
	;  restrict:restrict(Term0,Val,Term)
	).


% this declaration is useless if this module is loaded from a .ql file
:- meta_predicate assertz_if_new(:,-,-).

% assertz Pred0 with reference Ref if no more general one exists
% in that case New is instantiated as new.
% otherwise Ref is the reference of a more general item.
assertz_if_new(Module:Pred0,Ref,New) :-
	(  more_general(Module:Pred0,Ref)    % more general exists
	-> New=not_new
	;  New=new,
	   Module:assertz(Pred0,Ref)
	).

:- meta_predicate more_general(:,?).
more_general(Module:Pred,Ref) :-
	copy_term(Pred,PredC),
	Module:clause(PredC,_,Ref),
	Module:clause(General,_,Ref),
	terms:subsumes_chk(General,Pred).
