:- module(mj, [ mj_compile_grammar/1 ]).

:- use_module(library(concat),[concat_all/2, concat/3]).
:- use_module(library(lists), [append/3,
			       member/2]).

:- use_module(library(flags)).
:- use_module(library(system)).

act:compile_grammar(File) :-
	mj_compile_grammar(File).

mj_compile_grammar(File00) :-
	absolute_file_name(File00,File0),
	parse_file(File0,File1,Dir),
	replace_suffix(File1,Root,File,'.g','.pl'),
	concat_all(['(cd ',Dir,'; make ',File,')'],Cmd),
	system(Cmd),
	concat_all([Dir,'/',Root],RootFile),
	ensure_loaded(mj_in:RootFile),
	abolish(mj_in:first_member_index2/2),
	abolish(mj_in:nonfirst_member_index2/2),
	create_nonfirst_member_index2,
	create_first_member_index2.

replace_suffix(F0,Root,F2,S0,S2) :-
	name(F0,Fstr0),
	name(S0,Sstr0),
	name(S2,Sstr2),
	append(RootStr,Sstr0,Fstr0),
	append(RootStr,Sstr2,Fstr2),
	name(Root,RootStr),
	name(F2,Fstr2).

parse_file(File0,File,Dir) :-
	name(File0,FileString),
	append(DirString,[47|Tail],FileString),
	name(File,Tail),
	\+ member(47,Tail),
	name(Dir,DirString).
%	create_nonfirst_member_index2,
%	create_first_member_index2.

create_nonfirst_member_index2 :-
	(  mj_in:nonfirst_member_index(Id,_),
	   \+ Id = _-_,
	   findall(M,nonfirst(Id,M),Ms0),
	   sort(Ms0,List),
	   mj_in:assertz(nonfirst_member_index2(Id,List)),
	   fail
	;  true
	).

create_first_member_index2 :-
	(  mj_in:first_member_index(Id,_),
	   \+ Id = _-_,
	   findall(M,first(Id,M),Ms0),
	   sort(Ms0,List),
	   mj_in:assertz(first_member_index2(Id,List)),
	   fail
	;  true
	).

first(Id,M) :-
	(  mj_in:first_member_index(Id, Members)
	;  mj_in:first_member_index(Id-_,Members)
	),   % quick hack. Something is wrong now...
	lists:member(M,Members).  

nonfirst(Id,M) :-
	(  mj_in:nonfirst_member_index(Id, Members)
	;  mj_in:nonfirst_member_index(Id-_,Members)
	),   % quick hack. Something is wrong now...
	lists:member(M,Members).  

