/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.batik.texteditor;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import nl.rug.batik.texteditor.SVGFlowRootJTextPane;
import nl.rug.batik.texteditor.editorkit.BatikTextReader;
import nl.rug.syntree.mainview.UIUtilities;
import org.apache.batik.dom.svg12.SVGOMFlowRootElement;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.svg.JSVGComponent;

public class ContentFittingJScrollPane
extends JScrollPane
implements DocumentListener,
JGVTComponentListener {
    protected SVGFlowRootJTextPane content = null;
    protected JSVGComponent parentComponent = null;
    protected AffineTransform renderingTransform = null;
    protected Rectangle2D originalBounds = null;
    protected double originalFittingWidth = -1.0;
    protected AffineTransform prevRenderTransform = null;

    public ContentFittingJScrollPane(JSVGComponent theParent, SVGFlowRootJTextPane theContent) {
        super(theContent);
        this.parentComponent = theParent;
        this.content = theContent;
        this.initComponent();
    }

    public ContentFittingJScrollPane(SVGFlowRootJTextPane theContent) {
        super(theContent);
        this.content = theContent;
        this.initComponent();
    }

    protected void initComponent() {
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(21);
    }

    public SVGFlowRootJTextPane getContent() {
        return this.content;
    }

    public void setLocationEqualToSVGFlowRoot() {
        SVGOMFlowRootElement flowRoot = this.content.getSVGOMFlowRootElement();
        GraphicsNode node = this.parentComponent.getUpdateManager().getBridgeContext().getGraphicsNode(flowRoot);
        if (this.originalBounds == null) {
            Rectangle2D nodeBounds = node.getBounds();
            this.originalBounds = nodeBounds != null ? new Rectangle2D.Double(nodeBounds.getX(), nodeBounds.getY(), nodeBounds.getWidth(), nodeBounds.getHeight()) : new Rectangle2D.Double(-5.0, -6.0, 2.0, 4.0);
        }
        if (node == null) {
            System.out.println("node is null!");
        }
        Shape shape = node.getGlobalTransform().createTransformedShape(this.originalBounds);
        shape = this.renderingTransform.createTransformedShape(shape);
        Rectangle2D clientBounds = shape.getBounds2D();
        AttributeSet firstParagraphStyle = this.content.getStyledDocument().getParagraphElement(0).getAttributes();
        float spaceAboveParagraph = 0.0f;
        Object spaceAboveAttribute = firstParagraphStyle.getAttribute(StyleConstants.SpaceAbove);
        if (spaceAboveAttribute != null) {
            spaceAboveParagraph += ((Float)spaceAboveAttribute).floatValue();
        }
        double spaceAboveParInPx = BatikTextReader.convertPointsToPixels(spaceAboveParagraph, BatikTextReader.getScreenDPI(this));
        spaceAboveParInPx *= this.parentComponent.getViewBoxTransform().getScaleY();
        this.setCorrectedBounds(clientBounds.getX() + clientBounds.getWidth() / 2.0, clientBounds.getY() - 10.0, clientBounds.getWidth(), clientBounds.getHeight());
    }

    protected Rectangle fitBoundsToContent(DocumentEvent de) throws BadLocationException {
        String insertedText;
        double scale = this.parentComponent.getViewBoxTransform().getScaleX() * 1.33;
        double widthCorrection = Math.ceil(scale) + 3.0;
        Dimension preferredSize = this.content.getPreferredSize();
        Insets border = this.getBorder().getBorderInsets(this);
        preferredSize.setSize(preferredSize.getWidth() + (double)border.left + (double)border.right, preferredSize.getHeight() + (double)border.top + (double)border.bottom);
        if (de != null && de.getType() == DocumentEvent.EventType.INSERT && (insertedText = de.getDocument().getText(de.getOffset(), de.getLength())) != null && !insertedText.equals("\n")) {
            Dimension currentSize = this.getSize();
            preferredSize.height = currentSize.height;
        }
        Rectangle fittingBounds = this.getBounds();
        fittingBounds.width = (int)((double)preferredSize.width + widthCorrection);
        if (de != null) {
            fittingBounds.height = preferredSize.height;
        }
        return fittingBounds;
    }

    protected void centerAlignOnXAxis(Rectangle oldBounds, Rectangle newBounds) {
        int newWidth = newBounds.width;
        int oldWidth = oldBounds.width;
        if (newWidth > oldWidth) {
            double diff = newWidth - oldWidth;
            newBounds.x = (int)Math.ceil((double)newBounds.x - diff / 2.0);
        } else if (newWidth < oldWidth) {
            double diff = oldWidth - newWidth;
            newBounds.x = (int)Math.ceil((double)newBounds.x + diff / 2.0);
        }
    }

    public void setCorrectedBounds(double x, double y, double width, double height) {
        double scaleX = this.parentComponent.getViewBoxTransform().getScaleX() * 1.33;
        double scaleY = this.parentComponent.getViewBoxTransform().getScaleY();
        double xCorrection = 2.0;
        xCorrection = scaleX <= 2.0 ? 5.0 : (scaleX <= 6.0 ? 8.0 : scaleX);
        double yCorrection = scaleY / 2.0 - 1.0 > 0.0 ? scaleY / 2.0 - 1.0 : scaleY / 2.0;
        this.setBounds((int)Math.round(x - xCorrection), (int)Math.round(y - yCorrection), (int)(width + Math.ceil(scaleX) + 1.0), (int)(height + 5.0));
    }

    public void setParentComponent(JSVGComponent theParentComponent) {
        this.parentComponent = theParentComponent;
    }

    public JSVGComponent getParentComponent() {
        return this.parentComponent;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent ce) {
                    double scale = ContentFittingJScrollPane.this.parentComponent.getViewBoxTransform().getScaleX() * 1.33;
                    double widthCorrection = Math.ceil(scale) + 3.0;
                    Dimension preferredSize = ContentFittingJScrollPane.this.getPreferredSize();
                    ContentFittingJScrollPane.this.setBounds(ContentFittingJScrollPane.this.getX(), ContentFittingJScrollPane.this.getY(), (int)((double)preferredSize.width + widthCorrection), preferredSize.height);
                    ContentFittingJScrollPane.this.revalidate();
                }

                @Override
                public void componentShown(ComponentEvent ce) {
                    double scale = ContentFittingJScrollPane.this.parentComponent.getViewBoxTransform().getScaleX() * 1.33;
                    double widthCorrection = Math.ceil(scale) + 3.0;
                    Dimension preferredSize = ContentFittingJScrollPane.this.getPreferredSize();
                    Rectangle newBounds = new Rectangle(ContentFittingJScrollPane.this.getX(), ContentFittingJScrollPane.this.getY(), preferredSize.width, preferredSize.height);
                    ContentFittingJScrollPane.this.centerAlignOnXAxis(ContentFittingJScrollPane.this.getBounds(), newBounds);
                    ContentFittingJScrollPane.this.setBounds(newBounds.x, newBounds.y, (int)((double)newBounds.width + widthCorrection), ContentFittingJScrollPane.this.getSize().height);
                    ContentFittingJScrollPane.this.revalidate();
                }
            });
            this.content.getDocument().addDocumentListener(this);
        }
        super.setVisible(aFlag);
    }

    @Override
    public void removeUpdate(final DocumentEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Rectangle oldBounds = ContentFittingJScrollPane.this.content.getBounds();
                    Insets border = ContentFittingJScrollPane.this.getBorder().getBorderInsets(ContentFittingJScrollPane.this);
                    oldBounds.setRect(oldBounds.getX(), oldBounds.getY(), oldBounds.getWidth() + (double)border.left + (double)border.right, oldBounds.getHeight() + (double)border.top + (double)border.bottom);
                    Rectangle fittingBounds = ContentFittingJScrollPane.this.fitBoundsToContent(e);
                    ContentFittingJScrollPane.this.centerAlignOnXAxis(oldBounds, fittingBounds);
                    ContentFittingJScrollPane.this.setBounds(fittingBounds);
                }
                catch (BadLocationException e2) {
                    UIUtilities.handleException(e2, ContentFittingJScrollPane.this.parentComponent, null);
                }
                ContentFittingJScrollPane.this.content.requestFocusInWindow();
            }
        });
    }

    @Override
    public void insertUpdate(final DocumentEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Rectangle oldBounds = ContentFittingJScrollPane.this.content.getBounds();
                    Insets border = ContentFittingJScrollPane.this.getBorder().getBorderInsets(ContentFittingJScrollPane.this);
                    oldBounds.setRect(oldBounds.getX(), oldBounds.getY(), oldBounds.getWidth() + (double)border.left + (double)border.right, oldBounds.getHeight() + (double)border.top + (double)border.bottom);
                    Rectangle fittingBounds = ContentFittingJScrollPane.this.fitBoundsToContent(e);
                    ContentFittingJScrollPane.this.centerAlignOnXAxis(oldBounds, fittingBounds);
                    ContentFittingJScrollPane.this.setBounds(fittingBounds);
                }
                catch (BadLocationException e2) {
                    UIUtilities.handleException(e2, ContentFittingJScrollPane.this.parentComponent, null);
                }
                ContentFittingJScrollPane.this.content.requestFocusInWindow();
            }
        });
    }

    @Override
    public void changedUpdate(final DocumentEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Rectangle oldBounds = ContentFittingJScrollPane.this.content.getBounds();
                    Insets border = ContentFittingJScrollPane.this.getBorder().getBorderInsets(ContentFittingJScrollPane.this);
                    oldBounds.setRect(oldBounds.getX(), oldBounds.getY(), oldBounds.getWidth() + (double)border.left + (double)border.right, oldBounds.getHeight() + (double)border.top + (double)border.bottom);
                    Rectangle fittingBounds = ContentFittingJScrollPane.this.fitBoundsToContent(e);
                    ContentFittingJScrollPane.this.centerAlignOnXAxis(oldBounds, fittingBounds);
                    ContentFittingJScrollPane.this.setBounds(fittingBounds);
                }
                catch (BadLocationException ble) {
                    UIUtilities.handleException(ble, ContentFittingJScrollPane.this.parentComponent, null);
                }
                ContentFittingJScrollPane.this.content.requestFocusInWindow();
            }
        });
    }

    @Override
    public void componentTransformChanged(ComponentEvent event) {
        if (event.getID() == 1337) {
            JGVTComponent source = (JGVTComponent)event.getComponent();
            this.prevRenderTransform = this.renderingTransform;
            this.renderingTransform = source.getRenderingTransform();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        double currentUnscaledWidth;
                        ContentFittingJScrollPane.this.setLocationEqualToSVGFlowRoot();
                        Rectangle fittingBounds = ContentFittingJScrollPane.this.fitBoundsToContent(null);
                        if (ContentFittingJScrollPane.this.originalFittingWidth == -1.0) {
                            AffineTransform inverseScale = ContentFittingJScrollPane.this.renderingTransform.createInverse();
                            ContentFittingJScrollPane.this.originalFittingWidth = fittingBounds.getWidth() * inverseScale.getScaleX();
                        }
                        if ((currentUnscaledWidth = fittingBounds.getWidth() * ContentFittingJScrollPane.this.renderingTransform.createInverse().getScaleX()) > ContentFittingJScrollPane.this.originalFittingWidth) {
                            double diff = (currentUnscaledWidth - ContentFittingJScrollPane.this.originalFittingWidth) * ContentFittingJScrollPane.this.renderingTransform.getScaleX();
                            fittingBounds.setFrame(fittingBounds.getX() - 0.5 * diff, fittingBounds.getY(), fittingBounds.getWidth(), fittingBounds.getHeight());
                        } else if (currentUnscaledWidth < ContentFittingJScrollPane.this.originalFittingWidth) {
                            double diff = (ContentFittingJScrollPane.this.originalFittingWidth - currentUnscaledWidth) * ContentFittingJScrollPane.this.renderingTransform.getScaleX();
                            fittingBounds.setFrame(fittingBounds.getX() + 0.5 * diff, fittingBounds.getY(), fittingBounds.getWidth(), fittingBounds.getHeight());
                        }
                        ContentFittingJScrollPane.this.setBounds(fittingBounds);
                    }
                    catch (BadLocationException ble) {
                        UIUtilities.handleException(ble, ContentFittingJScrollPane.this.parentComponent, null);
                    }
                    catch (NoninvertibleTransformException nte) {
                        UIUtilities.handleException(nte, ContentFittingJScrollPane.this.parentComponent, null);
                    }
                }
            });
        }
    }
}

