/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.batik.texteditor;

import java.awt.Container;
import java.awt.Toolkit;
import java.awt.geom.NoninvertibleTransformException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.undo.UndoManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.rug.batik.texteditor.editorkit.BatikTextDocument;
import nl.rug.batik.texteditor.editorkit.BatikTextEditorKit;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg12.SVG12DOMImplementation;
import org.apache.batik.dom.svg12.SVGOMFlowRootElement;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.FlowTextPainter;
import org.apache.batik.swing.svg.JSVGComponent;
import org.apache.batik.swing.svg.SVGUserAgentGUIAdapter;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGPathSeg;

public class SVGFlowRootJTextPane
extends JTextPane {
    private static final String SVGNS = "http://www.w3.org/2000/svg";
    protected SVGOMFlowRootElement flowRoot = null;
    protected JSVGComponent parentComponent = null;
    protected SVGUserAgentGUIAdapter exceptionHandler = null;
    protected UndoManager undoManager = null;

    public SVGFlowRootJTextPane(SVGOMFlowRootElement theFlowRoot, JSVGComponent component, UndoManager theUndoManager) {
        this.initComponent(theFlowRoot, component, theUndoManager);
    }

    public SVGFlowRootJTextPane(SVGOMFlowRootElement theFlowRoot, UndoManager theUndoManager) {
        this.initComponent(theFlowRoot, null, theUndoManager);
    }

    public SVGFlowRootJTextPane(SVGOMFlowRootElement theFlowRoot, JSVGComponent component, BatikTextDocument document, UndoManager theUndoManager) {
        super(document);
        this.initComponent(theFlowRoot, component, theUndoManager);
    }

    public SVGFlowRootJTextPane(SVGOMFlowRootElement theFlowRoot, BatikTextDocument document, UndoManager theUndoManager) {
        super(document);
        this.initComponent(theFlowRoot, null, theUndoManager);
    }

    protected void initComponent(SVGOMFlowRootElement theFlowRoot, JSVGComponent component, UndoManager theUndoManager) {
        this.flowRoot = theFlowRoot;
        this.parentComponent = component;
        this.undoManager = theUndoManager;
        this.exceptionHandler = new SVGUserAgentGUIAdapter(this.parentComponent);
        SVGFlowRootJTextPane.registerEditorKitForContentType("image/svg+xml", BatikTextEditorKit.class.getName());
        ActionMap actionMap = this.getActionMap();
        actionMap.put("paste-from-clipboard", new BatikTextEditorKit.TextEditorPasteAction());
        actionMap.put("delete-selected-text", new BatikTextEditorKit.DeleteSelectedTextAction());
        if (this.parentComponent != null) {
            this.setParentComponent(this.parentComponent);
        }
        if (this.undoManager != null) {
            this.getDocument().addUndoableEditListener(this.undoManager);
        }
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new BatikTextEditorKit(null);
    }

    protected final BatikTextEditorKit getBatikTextEditorKit() {
        return (BatikTextEditorKit)this.getEditorKit();
    }

    public void readFromFlowRootElement() {
        try {
            EditorKit kit = this.getEditorKit();
            SVG12DOMImplementation implementation = (SVG12DOMImplementation)SVG12DOMImplementation.getDOMImplementation();
            org.w3c.dom.Document placeHolder = implementation.createDocument(SVGNS, "svg", null);
            Node importedFlowRoot = placeHolder.importNode(this.flowRoot, true);
            placeHolder.getDocumentElement().appendChild(importedFlowRoot);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(placeHolder), new StreamResult(output));
            Document attachedDoc = this.getDocument();
            this.setDocument(new BatikTextDocument());
            kit.read(new ByteArrayInputStream(output.toByteArray()), attachedDoc, 0);
            this.setDocument(attachedDoc);
            if (this.undoManager != null) {
                this.undoManager.discardAllEdits();
            }
        }
        catch (Exception e) {
            this.exceptionHandler.displayError(e);
            e.printStackTrace();
        }
    }

    public Node getLineFromFlowRoot(int lineNumber) {
        Node line = null;
        NodeList foundTags = this.flowRoot.getElementsByTagNameNS(SVGNS, "flowPara");
        if (foundTags.getLength() > 0) {
            line = foundTags.item(lineNumber - 1);
        }
        return line;
    }

    public void convertToFlowRootElement() {
        org.w3c.dom.Document parsedSVGDoc = null;
        try {
            parsedSVGDoc = SVGFlowRootJTextPane.parseToSVGDocument(this.getText());
        }
        catch (IOException e) {
            this.exceptionHandler.displayError(e);
            e.printStackTrace();
        }
        if (parsedSVGDoc != null) {
            Node parsedFlowRoot = parsedSVGDoc.getDocumentElement().getElementsByTagNameNS(SVGNS, "flowRoot").item(0);
            org.w3c.dom.Document ownerDoc = this.flowRoot.getOwnerDocument();
            SVGOMFlowRootElement importedNode = (SVGOMFlowRootElement)ownerDoc.importNode(parsedFlowRoot, true);
            Node oldNodeSibling = this.flowRoot.getNextSibling();
            Node parentNode = this.flowRoot.getParentNode();
            this.flowRoot.getParentNode().removeChild(this.flowRoot);
            SVGFlowRootJTextPane.copyMissingAttributes(this.flowRoot, importedNode);
            if (importedNode.getEventSupport() != null) {
                if (this.flowRoot.getEventSupport() == null) {
                    this.flowRoot.initializeEventSupport();
                }
                this.flowRoot.getEventSupport().moveEventListeners(importedNode.getEventSupport());
            }
            if (oldNodeSibling != null) {
                oldNodeSibling.getParentNode().insertBefore(importedNode, oldNodeSibling);
            } else {
                parentNode.appendChild(importedNode);
            }
            this.flowRoot = importedNode;
        }
    }

    public static org.w3c.dom.Document parseToSVGDocument(String svgXMLCode) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        SVGDocument dom = null;
        if (svgXMLCode == null) {
            throw new IOException("An unknown error occurred while transforming the edited text to graphics.\nUnfortunately the edited text was lost.\nReinputting the text is the only option to recover, I'm afraid.");
        }
        dom = factory.createSVGDocument(null, new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + svgXMLCode));
        return dom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyMissingAttributes(Node source, Node destination) throws DOMException {
        NamedNodeMap srcAttributes = source.getAttributes();
        if (srcAttributes == null) throw new DOMException(15, "Invalid source node to copy attributes from.\nSource node '" + source.getNodeName() + "' is of type '" + source.getNodeType() + "' must be '" + 1 + "'.");
        NamedNodeMap destAttributes = destination.getAttributes();
        if (destAttributes == null) throw new DOMException(15, "Invalid destination node to copy attributes from.\nDestination node '" + destination.getNodeName() + "' is of type '" + destination.getNodeType() + "' must be '" + 1 + "'.");
        for (int i = 0; i < srcAttributes.getLength(); ++i) {
            Node srcAttr = srcAttributes.item(i);
            if (destAttributes.getNamedItem(srcAttr.getNodeName()) != null && !srcAttr.getNodeName().equals("d")) continue;
            destAttributes.setNamedItem(srcAttr.cloneNode(true));
        }
    }

    public void setParentComponent(JSVGComponent theParentComponent) {
        this.parentComponent = theParentComponent;
        NodeList flowRegionPaths = this.flowRoot.getElementsByTagNameNS(SVGNS, "path");
        if (flowRegionPaths.getLength() > 0 && flowRegionPaths.item(0).getParentNode().getNodeName() == "flowRegion") {
            BatikTextEditorKit kit = this.getBatikTextEditorKit();
            kit.setEditor(this);
            this.getDocument().putProperty("PARENT_COMPONENT", this.parentComponent);
        } else {
            this.exceptionHandler.displayError(new Exception("Cannot parse the label for the properties required for editing.\nCause: no <path> tag was found with a <flowRegion> tag as parent.\nThis specifies the area in which the label wraps and is required."));
        }
    }

    public void determineTextWrapArea() throws IOException, NoninvertibleTransformException {
        SVGOMPathElement pathElement;
        double width;
        double height;
        if (this.parentComponent != null) {
            this.parentComponent.getUpdateManager();
            this.parentComponent.getUpdateManager().getBridgeContext();
            this.parentComponent.getUpdateManager().getBridgeContext().getGraphicsNode(this.flowRoot);
            FlowTextPainter painter = (FlowTextPainter)((TextNode)this.parentComponent.getUpdateManager().getBridgeContext().getGraphicsNode(this.flowRoot)).getTextPainter();
            BlockInfo[] blockInfos = painter.getLatestBlockInfo();
            BigDecimal highPrecisionHeight = BigDecimal.valueOf(0.0);
            for (BlockInfo info : blockInfos) {
                highPrecisionHeight = highPrecisionHeight.add(new BigDecimal(Float.toString(info.getLineHeight())));
            }
            Element defaultRoot = this.getDocument().getDefaultRootElement();
            int eltCountDiff = defaultRoot.getElementCount() - blockInfos.length;
            if (eltCountDiff > 0) {
                for (int i = 0; i < eltCountDiff; ++i) {
                    BlockInfo info;
                    info = blockInfos[blockInfos.length - 1];
                    highPrecisionHeight = highPrecisionHeight.add(new BigDecimal(Float.toString(info.getLineHeight())));
                }
            }
            height = highPrecisionHeight.setScale(4, 0).doubleValue();
            height += 1.0;
            width = this.flowRoot.getBBox().getWidth();
            pathElement = (SVGOMPathElement)this.flowRoot.getElementsByTagNameNS(SVGNS, "path").item(0);
            SVGPathSeg pathSeg = pathElement.getPathSegList().getItem(0);
            if (pathSeg.getPathSegType() != 2) {
                throw new IOException("'d' attribute of <path> tag does not start with required SVG absolute MOVE_TO segment (i.e. 'M').\nCannot validly recalculate text wrap area to reflect the edit.\nAborting conversion of text edits to SVG.");
            }
        } else {
            throw new IOException("Unfortunately, an error occurred while determining the text wrap area of the edited text.\nThe resulting label will probably have too much whitespace.\nTechnical details: Illegal call to method SVGFlowRootJTextPane.determineTextWrapArea(). SVGFlowRootJTextPane.parentComponent is null.");
        }
        String dAttribValue = "M" + -0.5 * width + "," + -0.5 * height + " ";
        dAttribValue = dAttribValue + "l" + width + "," + 0.0f + " ";
        dAttribValue = dAttribValue + "l0.0," + height + " ";
        dAttribValue = dAttribValue + "l" + -width + "," + 0.0f + " ";
        dAttribValue = dAttribValue + "z";
        pathElement.setAttributeNS(null, "d", dAttribValue);
    }

    public SVGOMFlowRootElement getSVGOMFlowRootElement() {
        return this.flowRoot;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        super.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        return parent != null ? this.getUI().getPreferredSize((JComponent)this).width <= parent.getSize().width : true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        return parent != null ? this.getUI().getPreferredSize((JComponent)this).height <= parent.getSize().height : true;
    }

    protected void associateBasicActionsWithStandardKeyStrokes() {
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        KeyStroke key = KeyStroke.getKeyStroke(88, 2);
        inputMap.put(key, actionMap.get("cut-to-clipboard"));
        key = KeyStroke.getKeyStroke(67, 2);
        inputMap.put(key, actionMap.get("copy-to-clipboard"));
        key = KeyStroke.getKeyStroke(86, 2);
        inputMap.put(key, actionMap.get("paste-from-clipboard"));
    }

    public void associateUndoActionsWithStandardKeyStrokes(String undoActionName, String redoActionName) {
        InputMap inputMap = this.getInputMap();
        KeyStroke key = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(key, undoActionName);
        key = KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(key, redoActionName);
    }
}

