/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.batik.texteditor;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import javax.swing.text.BadLocationException;
import javax.swing.text.GlyphView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;

public class ScaledGlyphPainter
extends GlyphView.GlyphPainter {
    static ScaledGlyphPainter instance = new ScaledGlyphPainter();
    static Graphics2D painterGr;
    FontMetrics metrics;
    static char[] SPACE_CHAR;

    public static ScaledGlyphPainter getInstance() {
        return instance;
    }

    @Override
    public float getSpan(GlyphView v, int p0, int p1, TabExpander e, float x) {
        this.sync(v);
        Segment text = ScaledGlyphPainter.getText(v, p0, p1);
        int[] justificationData = this.getJustificationData(v);
        float width = this.getTabbedTextWidth(v, text, this.metrics, x, e, p0, justificationData);
        return width;
    }

    @Override
    public float getHeight(GlyphView v) {
        this.sync(v);
        return this.metrics.getHeight();
    }

    @Override
    public float getAscent(GlyphView v) {
        this.sync(v);
        return this.metrics.getAscent();
    }

    @Override
    public float getDescent(GlyphView v) {
        this.sync(v);
        return this.metrics.getDescent();
    }

    @Override
    public void paint(GlyphView v, Graphics g, Shape a, int p0, int p1) {
        Segment text;
        this.sync(v);
        TabExpander expander = v.getTabExpander();
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int x = alloc.x;
        int p = v.getStartOffset();
        int[] justificationData = this.getJustificationData(v);
        if (p != p0) {
            text = ScaledGlyphPainter.getText(v, p, p0);
            float width = this.getTabbedTextWidth(v, text, this.metrics, x, expander, p, justificationData);
            x = (int)((float)x + width);
        }
        int y = alloc.y + this.metrics.getHeight() - this.metrics.getDescent();
        text = ScaledGlyphPainter.getText(v, p0, p1);
        g.setFont(this.metrics.getFont());
        this.drawTabbedText(v, text, x, y, g, expander, p0, justificationData);
    }

    @Override
    public Shape modelToView(GlyphView v, int pos, Position.Bias bias, Shape a) throws BadLocationException {
        this.sync(v);
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int p0 = v.getStartOffset();
        int p1 = v.getEndOffset();
        TabExpander expander = v.getTabExpander();
        if (pos == p1) {
            return new Rectangle(alloc.x + alloc.width, alloc.y, 0, this.metrics.getHeight());
        }
        if (pos >= p0 && pos <= p1) {
            Segment text = ScaledGlyphPainter.getText(v, p0, pos);
            int[] justificationData = this.getJustificationData(v);
            int width = (int)this.getTabbedTextWidth(v, text, this.metrics, alloc.x, expander, p0, justificationData);
            return new Rectangle(alloc.x + width, alloc.y, 0, this.metrics.getHeight());
        }
        throw new BadLocationException("modelToView - can't convert", p1);
    }

    @Override
    public int viewToModel(GlyphView v, float x, float y, Shape a, Position.Bias[] biasReturn) {
        this.sync(v);
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int p0 = v.getStartOffset();
        int p1 = v.getEndOffset();
        TabExpander expander = v.getTabExpander();
        Segment text = ScaledGlyphPainter.getText(v, p0, p1);
        int[] justificationData = this.getJustificationData(v);
        int offs = this.getTabbedTextOffset(v, text, this.metrics, alloc.x, (int)x, expander, p0, true, justificationData);
        int retValue = p0 + offs;
        if (retValue == p1) {
            --retValue;
        }
        biasReturn[0] = Position.Bias.Forward;
        return retValue;
    }

    @Override
    public int getBoundedPosition(GlyphView v, int p0, float x, float len) {
        this.sync(v);
        TabExpander expander = v.getTabExpander();
        Segment s = ScaledGlyphPainter.getText(v, p0, v.getEndOffset());
        int[] justificationData = this.getJustificationData(v);
        int index = this.getTabbedTextOffset(v, s, this.metrics, (int)x, (int)(x + len), expander, p0, false, justificationData);
        int p1 = p0 + index;
        return p1;
    }

    void sync(GlyphView v) {
        Font f = v.getFont();
        if (this.metrics == null || !f.equals(this.metrics.getFont())) {
            Container c = v.getContainer();
            this.metrics = c != null ? c.getFontMetrics(f) : Toolkit.getDefaultToolkit().getFontMetrics(f);
        }
    }

    private int[] getJustificationData(GlyphView v) {
        Class<?> pClass;
        View parent = v.getParent();
        int[] ret = null;
        if (parent != null && (pClass = parent.getClass()).isAssignableFrom(ParagraphView.class.getDeclaredClasses()[0])) {
            try {
                Field f = pClass.getDeclaredField("justificationData");
                if (f != null) {
                    f.setAccessible(true);
                    ret = (int[])f.get(parent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    static Segment getText(View v, int start, int end) {
        Segment s = new Segment();
        try {
            s.array = v.getDocument().getText(start, end - start).toCharArray();
            s.offset = 0;
            s.count = end - start;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return s;
    }

    float getTabbedTextWidth(View view, Segment s, FontMetrics metrics, float x, TabExpander e, int startOffset, int[] justificationData) {
        float nextX = x;
        char[] txt = s.array;
        String txtStr = new String(txt);
        int txtOffset = s.offset;
        int n = s.offset + s.count;
        int charCount = 0;
        int spaceAddon = 0;
        int spaceAddonLeftoverEnd = -1;
        int startJustifiableContent = 0;
        int endJustifiableContent = 0;
        if (justificationData != null) {
            int offset = -startOffset + txtOffset;
            View parent = null;
            if (view != null && (parent = view.getParent()) != null) {
                offset += parent.getStartOffset();
            }
            spaceAddon = justificationData[0];
            spaceAddonLeftoverEnd = justificationData[1] + offset;
            startJustifiableContent = justificationData[2] + offset;
            endJustifiableContent = justificationData[3] + offset;
        }
        for (int i = txtOffset; i < n; ++i) {
            if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                nextX = (float)((double)nextX + metrics.getStringBounds(txtStr, i - charCount, i, (Graphics)painterGr).getWidth());
                charCount = 0;
                if (txt[i] == '\t') {
                    if (e != null) {
                        nextX = e.nextTabStop(nextX, startOffset + i - txtOffset);
                        continue;
                    }
                    nextX = (float)((double)nextX + metrics.getStringBounds(SPACE_CHAR, 0, 1, (Graphics)painterGr).getWidth());
                    nextX = (int)nextX;
                    continue;
                }
                if (txt[i] != ' ') continue;
                nextX = (float)((double)nextX + (metrics.getStringBounds(SPACE_CHAR, 0, 1, (Graphics)painterGr).getWidth() + (double)spaceAddon));
                nextX = (int)nextX;
                if (i > spaceAddonLeftoverEnd) continue;
                nextX += 1.0f;
                continue;
            }
            if (txt[i] == '\n') {
                nextX += (float)metrics.getStringBounds(txtStr, i - charCount, i, (Graphics)painterGr).getWidth();
                charCount = 0;
                continue;
            }
            ++charCount;
        }
        nextX = (float)((double)nextX + metrics.getStringBounds(txtStr, n - charCount, n, (Graphics)painterGr).getWidth());
        return nextX - x;
    }

    float drawTabbedText(View view, Segment s, float x, float y, Graphics g, TabExpander e, int startOffset, int[] justificationData) {
        float nextX = x;
        char[] txt = s.array;
        String txtStr = new String(txt);
        int txtOffset = s.offset;
        int flushLen = 0;
        int flushIndex = s.offset;
        int spaceAddon = 0;
        int spaceAddonLeftoverEnd = -1;
        int startJustifiableContent = 0;
        int endJustifiableContent = 0;
        if (justificationData != null) {
            int offset = -startOffset + txtOffset;
            View parent = null;
            if (view != null && (parent = view.getParent()) != null) {
                offset += parent.getStartOffset();
            }
            spaceAddon = justificationData[0];
            spaceAddonLeftoverEnd = justificationData[1] + offset;
            startJustifiableContent = justificationData[2] + offset;
            endJustifiableContent = justificationData[3] + offset;
        }
        int n = s.offset + s.count;
        for (int i = txtOffset; i < n; ++i) {
            if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                if (flushLen > 0) {
                    ((Graphics2D)g).drawString(txtStr.substring(flushIndex, flushIndex + flushLen), x, y);
                    nextX = (float)((double)nextX + this.metrics.getStringBounds(txtStr, flushIndex, flushIndex + flushLen, (Graphics)painterGr).getWidth());
                    flushLen = 0;
                }
                flushIndex = i + 1;
                if (txt[i] == '\t') {
                    if (e != null) {
                        nextX = e.nextTabStop(nextX, startOffset + i - txtOffset);
                    } else {
                        nextX += (float)this.metrics.getStringBounds(SPACE_CHAR, 0, 1, (Graphics)painterGr).getWidth();
                        nextX = (int)nextX;
                    }
                } else if (txt[i] == ' ') {
                    nextX += (float)this.metrics.getStringBounds(SPACE_CHAR, 0, 1, (Graphics)painterGr).getWidth() + (float)spaceAddon;
                    if (i <= spaceAddonLeftoverEnd) {
                        nextX += 1.0f;
                    }
                }
                x = nextX;
                continue;
            }
            if (txt[i] == '\n' || txt[i] == '\r') {
                if (flushLen > 0) {
                    ((Graphics2D)g).drawString(txtStr.substring(flushIndex, flushIndex + flushLen), x, y);
                    nextX = (float)((double)nextX + this.metrics.getStringBounds(txtStr, flushIndex, flushIndex + flushLen, (Graphics)painterGr).getWidth());
                    flushLen = 0;
                }
                flushIndex = i + 1;
                x = nextX;
                continue;
            }
            ++flushLen;
        }
        if (flushLen > 0) {
            ((Graphics2D)g).drawString(txtStr.substring(flushIndex, flushIndex + flushLen), x, y);
            nextX = (float)((double)nextX + this.metrics.getStringBounds(txtStr, flushIndex, flushIndex + flushLen, (Graphics)painterGr).getWidth());
        }
        return nextX;
    }

    int getTabbedTextOffset(View view, Segment s, FontMetrics metrics, int x0, int x, TabExpander e, int startOffset, boolean round, int[] justificationData) {
        float currX;
        if (x0 >= x) {
            return 0;
        }
        float nextX = currX = (float)x0;
        char[] txt = s.array;
        int txtOffset = s.offset;
        int txtCount = s.count;
        int spaceAddon = 0;
        int spaceAddonLeftoverEnd = -1;
        int startJustifiableContent = 0;
        int endJustifiableContent = 0;
        if (justificationData != null) {
            int offset = -startOffset + txtOffset;
            View parent = null;
            if (view != null && (parent = view.getParent()) != null) {
                offset += parent.getStartOffset();
            }
            spaceAddon = justificationData[0];
            spaceAddonLeftoverEnd = justificationData[1] + offset;
            startJustifiableContent = justificationData[2] + offset;
            endJustifiableContent = justificationData[3] + offset;
        }
        int n = s.offset + s.count;
        for (int i = s.offset; i < n; ++i) {
            if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                if (txt[i] == '\t') {
                    nextX = e != null ? (float)((int)e.nextTabStop(nextX, startOffset + i - txtOffset)) : (float)((double)nextX + metrics.getStringBounds(SPACE_CHAR, 0, 1, (Graphics)painterGr).getWidth());
                } else if (txt[i] == ' ') {
                    nextX = (float)((double)nextX + (metrics.getStringBounds(SPACE_CHAR, 0, 1, (Graphics)painterGr).getWidth() + (double)spaceAddon));
                    nextX = (int)nextX;
                    if (i <= spaceAddonLeftoverEnd) {
                        nextX += 1.0f;
                    }
                }
            } else {
                nextX = (float)((double)nextX + metrics.getStringBounds(txt, i, i + 1, (Graphics)painterGr).getWidth());
            }
            if ((float)x >= currX && (float)x < nextX) {
                if (!round || (float)x - currX < nextX - (float)x) {
                    return i - txtOffset;
                }
                return i + 1 - txtOffset;
            }
            currX = nextX;
        }
        return txtCount;
    }

    static {
        BufferedImage img = new BufferedImage(1, 1, 2);
        painterGr = (Graphics2D)img.getGraphics();
        painterGr.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        SPACE_CHAR = new char[]{' '};
    }
}

