/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.batik.texteditor.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class DashedBorder
implements Border {
    protected int dashThickness = 0;
    protected Color color = null;
    protected int horizontalDashWidth = 0;
    protected int verticalDashWidth = 0;

    public DashedBorder() {
        this(Color.black, 1, 8, 8);
    }

    public DashedBorder(Color c, int theDashThickness, int horizontalWidth, int verticalWidth) {
        if (theDashThickness < 1) {
            throw new IllegalArgumentException("Invalid dash thickness: " + theDashThickness);
        }
        if (horizontalWidth < 1) {
            throw new IllegalArgumentException("Invalid horizontal width: " + horizontalWidth);
        }
        if (verticalWidth < 1) {
            throw new IllegalArgumentException("Invalid vertical 'width': " + verticalWidth);
        }
        this.color = c;
        this.dashThickness = theDashThickness;
        this.horizontalDashWidth = horizontalWidth;
        this.verticalDashWidth = verticalWidth;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int startPoint;
        int i;
        Insets insets = this.getBorderInsets(c);
        g.setColor(this.color);
        int numWide = width / this.horizontalDashWidth;
        int numHigh = height / this.verticalDashWidth;
        for (i = 0; i <= numWide; i += 2) {
            startPoint = x + this.horizontalDashWidth * i;
            g.fillRect(startPoint, y, this.horizontalDashWidth, this.dashThickness);
            g.fillRect(startPoint, y + height - insets.bottom, this.horizontalDashWidth, this.dashThickness);
        }
        for (i = 0; i <= numHigh; i += 2) {
            startPoint = x + this.verticalDashWidth * i;
            g.fillRect(x, startPoint, this.dashThickness, this.verticalDashWidth);
            g.fillRect(x + width - insets.right, startPoint, this.dashThickness, this.verticalDashWidth);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.dashThickness, this.dashThickness, this.dashThickness, this.dashThickness);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

