/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.batik.texteditor.editorkit;

import java.awt.event.ActionEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import nl.rug.batik.texteditor.SVGFlowRootJTextPane;
import nl.rug.batik.texteditor.editorkit.BatikTextReader;
import nl.rug.batik.texteditor.editorkit.BatikTextWriter;
import nl.rug.batik.texteditor.editorkit.ScaledLabelView;
import nl.rug.batik.texteditor.editorkit.ScaledView;
import nl.rug.syntree.mainview.UIUtilities;

public class BatikTextEditorKit
extends StyledEditorKit {
    public static final String CUSTOM_CONTENT_TYPE = "image/svg+xml";
    public static final String deleteSelectedTextAction = "delete-selected-text";
    public static final String undoTextEditAction = "undo-text-edit";
    public static final String redoTextEditAction = "redo-text-edit";
    public static final String exitTextEditModeAction = "exit-text-edit-mode";
    protected SVGFlowRootJTextPane editor = null;

    public BatikTextEditorKit(SVGFlowRootJTextPane theEditor) {
        this.editor = theEditor;
    }

    @Override
    public void write(Writer out, Document document, int startPosition, int length) throws IOException, BadLocationException {
        try {
            BatikTextWriter.write(document, startPosition, length, out, this.editor);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            throw new IOException(e.getCause());
        }
    }

    @Override
    public void read(InputStream in, Document document, int startPosition) throws IOException, BadLocationException {
        BatikTextReader.read(document, startPosition, in);
    }

    @Override
    public void read(Reader in, Document document, int position) throws IOException, BadLocationException {
        BufferedReader br = new BufferedReader(in);
        String s = br.readLine();
        StringBuffer buff = new StringBuffer();
        while (s != null) {
            buff.append(s);
            s = br.readLine();
        }
        BatikTextReader.read(document, position, new ByteArrayInputStream(buff.toString().getBytes()));
    }

    @Override
    public String getContentType() {
        return CUSTOM_CONTENT_TYPE;
    }

    public void setEditor(SVGFlowRootJTextPane theEditor) {
        this.editor = theEditor;
    }

    @Override
    public ViewFactory getViewFactory() {
        return new StyledViewFactory();
    }

    public static class TextEditorPasteAction
    extends DefaultEditorKit.PasteAction {
        @Override
        public void actionPerformed(ActionEvent ae) {
            SVGFlowRootJTextPane sVGFlowRootJTextPane;
            JTextComponent target = this.getTextComponent(ae);
            if (target != null) {
                sVGFlowRootJTextPane = (SVGFlowRootJTextPane)target;
            }
            super.actionPerformed(ae);
            if (target != null) {
                sVGFlowRootJTextPane = (SVGFlowRootJTextPane)target;
            }
        }
    }

    public static class DeleteSelectedTextAction
    extends StyledEditorKit.StyledTextAction {
        public DeleteSelectedTextAction() {
            super(BatikTextEditorKit.deleteSelectedTextAction);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane selectionSource = this.getEditor(ae);
            int selectionStartIndex = selectionSource.getSelectionStart();
            int selectionEndIndex = selectionSource.getSelectionEnd();
            System.out.println("Deleteeeeed!");
            try {
                selectionSource.getDocument().remove(selectionStartIndex, selectionEndIndex - selectionStartIndex);
            }
            catch (BadLocationException e) {
                UIUtilities.handleException(e, null, null);
            }
        }
    }

    public static class SmallCapsAction
    extends StyledEditorKit.StyledTextAction {
        public static final double SMALL_CAPS_SCALING_FACTOR = 0.7;

        public SmallCapsAction() {
            super("SmallCaps");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int selectionStart;
            JEditorPane editor = this.getEditor(ae);
            if (editor != null && (selectionStart = editor.getSelectionStart()) >= 0) {
                int selectionEnd = editor.getSelectionEnd();
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                String affectedText = editor.getSelectedText();
                boolean smallcaps = attr.isDefined("syntree-smallcaps");
                if (!smallcaps) {
                    affectedText = affectedText.toUpperCase();
                    editor.replaceSelection(affectedText);
                    if (!StyleConstants.isSubscript(attr) && !StyleConstants.isSuperscript(attr)) {
                        int scaledFontSize = (int)Math.round(0.7 * (double)StyleConstants.getFontSize(attr));
                        attr.addAttribute("syntree-smallcaps", 0.7 * (double)StyleConstants.getFontSize(attr));
                        StyleConstants.setFontSize(attr, scaledFontSize);
                    } else {
                        attr.addAttribute("syntree-smallcaps", 0.7 * (double)StyleConstants.getFontSize(attr));
                    }
                } else {
                    affectedText = affectedText.toLowerCase();
                    editor.replaceSelection(affectedText);
                    if (!StyleConstants.isSubscript(attr) && !StyleConstants.isSuperscript(attr)) {
                        attr.addAttribute(StyleConstants.FontSize, (int)Math.round((Double)attr.getAttribute("syntree-smallcaps") / 0.7));
                    }
                    attr.removeAttribute("syntree-smallcaps");
                }
                StyledDocument doc = (StyledDocument)editor.getDocument();
                doc.setCharacterAttributes(selectionStart, selectionEnd - selectionStart, attr, true);
                editor.setSelectionStart(selectionStart);
                editor.setSelectionEnd(selectionEnd);
            }
        }
    }

    public static class SuperscriptAction
    extends StyledEditorKit.StyledTextAction {
        public SuperscriptAction() {
            super(StyleConstants.Superscript.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = (MutableAttributeSet)kit.getInputAttributes().copyAttributes();
                boolean superscript = !StyleConstants.isSuperscript(attr);
                Object subscript = attr.getAttribute(StyleConstants.Subscript);
                if (!superscript && subscript == null || !superscript && !((Boolean)subscript).booleanValue()) {
                    attr.removeAttribute(StyleConstants.Superscript);
                    attr.removeAttribute("syntree-subsuperscript-size");
                    Object smallcapsFontSizeAttrib = attr.getAttribute("syntree-smallcaps");
                    if (smallcapsFontSizeAttrib != null) {
                        double smallcapsFontSize = (double)StyleConstants.getFontSize(attr) * 0.7;
                        StyleConstants.setFontSize(attr, (int)Math.round(smallcapsFontSize));
                        attr.addAttribute("syntree-smallcaps", smallcapsFontSize);
                    }
                } else if (superscript && subscript != null && ((Boolean)subscript).booleanValue()) {
                    attr.removeAttribute(StyleConstants.Subscript);
                    StyleConstants.setSuperscript(attr, true);
                } else {
                    if (attr.isDefined("syntree-smallcaps")) {
                        double smallcapsFontSize = (Double)attr.getAttribute("syntree-smallcaps");
                        StyleConstants.setFontSize(attr, (int)Math.round(smallcapsFontSize / 0.7));
                    }
                    StyleConstants.setSuperscript(attr, true);
                }
                this.setCharacterAttributes(editor, attr, true);
            }
        }
    }

    public static class SubscriptAction
    extends StyledEditorKit.StyledTextAction {
        public SubscriptAction() {
            super(StyleConstants.Subscript.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = (MutableAttributeSet)kit.getInputAttributes().copyAttributes();
                boolean subscript = !StyleConstants.isSubscript(attr);
                Object superscript = attr.getAttribute(StyleConstants.Superscript);
                if (!subscript && superscript == null || !subscript && !((Boolean)superscript).booleanValue()) {
                    attr.removeAttribute(StyleConstants.Subscript);
                    attr.removeAttribute("syntree-subsuperscript-size");
                    Object smallcapsFontSizeAttrib = attr.getAttribute("syntree-smallcaps");
                    if (smallcapsFontSizeAttrib != null) {
                        double smallcapsFontSize = (double)StyleConstants.getFontSize(attr) * 0.7;
                        StyleConstants.setFontSize(attr, (int)Math.round(smallcapsFontSize));
                        attr.addAttribute("syntree-smallcaps", smallcapsFontSize);
                    }
                } else if (subscript && superscript != null && ((Boolean)superscript).booleanValue()) {
                    attr.removeAttribute(StyleConstants.Superscript);
                    StyleConstants.setSubscript(attr, true);
                } else {
                    if (attr.isDefined("syntree-smallcaps")) {
                        double smallcapsFontSize = (Double)attr.getAttribute("syntree-smallcaps");
                        StyleConstants.setFontSize(attr, (int)Math.round(smallcapsFontSize / 0.7));
                    }
                    StyleConstants.setSubscript(attr, true);
                }
                this.setCharacterAttributes(editor, attr, true);
            }
        }
    }

    public static class StrikeThroughAction
    extends StyledEditorKit.StyledTextAction {
        public StrikeThroughAction() {
            super(StyleConstants.StrikeThrough.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean strikeThrough = !StyleConstants.isStrikeThrough(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setStrikeThrough(sas, strikeThrough);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    public class StyledViewFactory
    implements ViewFactory {
        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new ScaledLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new ScaledView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }
}

