/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.batik.texteditor.editorkit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.rug.batik.texteditor.editorkit.BatikTextWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BatikTextReader {
    protected static SimpleAttributeSet lastParagraphStyle = null;
    protected static SimpleAttributeSet lastCharacterStyle = null;
    public static final String tabCharacter = "    ";
    public static final Pattern IGNORE_READABILITY_WHITESPACE = Pattern.compile("[" + BatikTextWriter.documentLineBreak + "(    )|(\t)]+");
    protected static boolean trimLeadingAndTrailingWhitespace = true;
    public static boolean removeWhiteSpaceTextNodes = false;
    public static final float POINTS_PER_INCH = 72.0f;

    public static void read(Document docToUpdate, int startPosition, InputStream in) throws IOException, BadLocationException {
        if (!(docToUpdate instanceof DefaultStyledDocument)) {
            return;
        }
        DefaultStyledDocument doc = (DefaultStyledDocument)docToUpdate;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dbXML = dbf.newDocumentBuilder();
            org.w3c.dom.Document dom = dbXML.parse(in);
            NodeList svgChildren = dom.getDocumentElement().getChildNodes();
            for (int h = 0; h < svgChildren.getLength(); ++h) {
                Node svgChild = svgChildren.item(h);
                if (svgChild.getNodeName().equals("flowRoot")) {
                    NodeList flowRootChildren = svgChild.getChildNodes();
                    int offs = startPosition;
                    for (int i = 0; i < flowRootChildren.getLength(); ++i) {
                        Node rootChild = flowRootChildren.item(i);
                        if (rootChild.getNodeName().equals("flowRegion")) {
                            NodeList rootChildChildren = rootChild.getChildNodes();
                            for (int j = 0; j < rootChildChildren.getLength(); ++j) {
                                Node regionPath = rootChildChildren.item(j);
                                if (regionPath.getNodeName().equals("path")) continue;
                                if (IGNORE_READABILITY_WHITESPACE.matcher(regionPath.getNodeValue()).matches()) {
                                    if (!removeWhiteSpaceTextNodes) continue;
                                    regionPath.getParentNode().removeChild(regionPath);
                                    --j;
                                    continue;
                                }
                                if (regionPath.getNodeType() == 8) continue;
                                throw new SAXException("Document parse error: expected tag 'path', but found '" + regionPath.getNodeName() + "' instead!");
                            }
                            continue;
                        }
                        if (rootChild.getNodeName().equals("flowDiv")) {
                            NodeList paragraphs = rootChild.getChildNodes();
                            int numOfParagraphNodes = BatikTextReader.countChildNodes(rootChild, "flowPara");
                            int numOfParagraphsWritten = 0;
                            for (int j = 0; j < paragraphs.getLength(); ++j) {
                                Node paragraph = paragraphs.item(j);
                                if (paragraph.getNodeName().equals("flowPara")) {
                                    offs += BatikTextReader.writeParagraph(doc, offs, paragraph);
                                    StyledDocument styledDoc = (StyledDocument)docToUpdate;
                                    styledDoc.setCharacterAttributes(offs, 1, lastCharacterStyle, true);
                                    if (++numOfParagraphsWritten >= numOfParagraphNodes) continue;
                                    docToUpdate.insertString(offs, "\n", lastCharacterStyle);
                                    offs += "\n".length();
                                    continue;
                                }
                                if (IGNORE_READABILITY_WHITESPACE.matcher(paragraph.getNodeValue()).matches()) {
                                    if (!removeWhiteSpaceTextNodes) continue;
                                    paragraph.getParentNode().removeChild(paragraph);
                                    --j;
                                    continue;
                                }
                                if (paragraph.getNodeType() == 8) continue;
                                throw new SAXException("Document parse error: expected tag 'flowPara', but found '" + paragraph.getNodeName() + "' instead!");
                            }
                            continue;
                        }
                        if (!IGNORE_READABILITY_WHITESPACE.matcher(rootChild.getNodeValue()).matches() || !removeWhiteSpaceTextNodes) continue;
                        rootChild.getParentNode().removeChild(rootChild);
                        --i;
                    }
                    continue;
                }
                if (svgChild.getNodeValue() != null && IGNORE_READABILITY_WHITESPACE.matcher(svgChild.getNodeValue()).matches()) {
                    if (!removeWhiteSpaceTextNodes) continue;
                    svgChild.getParentNode().removeChild(svgChild);
                    --h;
                    continue;
                }
                if (svgChild.getNodeType() == 8) continue;
                throw new SAXException("Document parse error: expected tag 'flowRoot', but found '" + svgChild.getNodeName() + "' instead!");
            }
        }
        catch (SAXException pce) {
            pce.printStackTrace();
            throw new IOException(pce.getMessage());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new IOException(pce.getMessage());
        }
    }

    public static int writeParagraph(DefaultStyledDocument docToUpdate, int startPosition, Node paragraph) throws BadLocationException, IOException {
        int length = 0;
        NodeList children = paragraph.getChildNodes();
        try {
            lastCharacterStyle = lastParagraphStyle = BatikTextReader.getCharacterAttributes(paragraph);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("flowSpan")) {
                length += BatikTextReader.writeText(docToUpdate, startPosition + length, child);
                continue;
            }
            if (!child.getNodeName().equals("#text")) continue;
            String text = child.getNodeValue();
            if (trimLeadingAndTrailingWhitespace) {
                text = text.replaceAll("\n", "");
                if (!"\n".equals(BatikTextWriter.documentLineBreak)) {
                    text = text.replaceAll(BatikTextWriter.documentLineBreak, "");
                }
                text = text.replaceAll(tabCharacter, "");
                text = text.replaceAll("\t", "");
            }
            docToUpdate.insertString(startPosition + length, text, lastParagraphStyle);
            length += text.length();
        }
        boolean replaceAttrSet = BatikTextReader.shouldReplaceParagraphAttributes(docToUpdate, startPosition + length - 1);
        try {
            docToUpdate.setParagraphAttributes(startPosition + length - 1, 1, BatikTextReader.getParagraphAttributes(paragraph), replaceAttrSet);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage(), e.getCause());
        }
        return length;
    }

    public static boolean shouldReplaceParagraphAttributes(DefaultStyledDocument docContainingParagraph, int paragraphContainingPos) throws BadLocationException {
        boolean replaceAttrSet = true;
        Element curDocParagraph = docContainingParagraph.getParagraphElement(paragraphContainingPos);
        for (int i = 0; i < curDocParagraph.getElementCount() && replaceAttrSet; ++i) {
            String childElementText;
            Element child = curDocParagraph.getElement(i);
            if (!child.isLeaf() || IGNORE_READABILITY_WHITESPACE.matcher(childElementText = docContainingParagraph.getText(child.getStartOffset(), child.getEndOffset() - child.getStartOffset())).matches()) continue;
            AttributeSet curDocParAttrs = curDocParagraph.getAttributes();
            if (child.getAttributes().getAttributeCount() < curDocParAttrs.getAttributeCount()) {
                replaceAttrSet = false;
                continue;
            }
            Enumeration<?> attrNames = curDocParAttrs.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                if (child.getAttributes().isDefined(attrNames.nextElement())) continue;
                replaceAttrSet = false;
            }
        }
        return replaceAttrSet;
    }

    public static SimpleAttributeSet getParagraphAttributes(Node paragraph) throws ParseException {
        SimpleAttributeSet res = null;
        Node styleAttr = paragraph.getAttributes().getNamedItem("style");
        res = styleAttr != null ? BatikTextReader.getParagraphAttributes(styleAttr.getNodeValue()) : new SimpleAttributeSet();
        return res;
    }

    public static SimpleAttributeSet getParagraphAttributes(String styleAttrValue) throws ParseException {
        SimpleAttributeSet res = new SimpleAttributeSet();
        Map<String, String> styleValues = BatikTextReader.parseSVGStyleAttribute(styleAttrValue);
        String lineSpacing = null;
        for (String key : styleValues.keySet()) {
            if (key.equals("text-align")) {
                String svgAlignment = styleValues.get(key);
                int swingAlignment = -1;
                if (svgAlignment.equals("start")) {
                    swingAlignment = 0;
                } else if (svgAlignment.equals("middle")) {
                    swingAlignment = 1;
                } else if (svgAlignment.equals("end")) {
                    swingAlignment = 2;
                }
                StyleConstants.setAlignment(res, swingAlignment);
                continue;
            }
            if (!key.equals("line-height")) continue;
            lineSpacing = styleValues.get(key);
        }
        return res;
    }

    public static SimpleAttributeSet getCharacterAttributes(Node text) throws ParseException {
        SimpleAttributeSet res = new SimpleAttributeSet();
        Node styleAttr = text.getAttributes().getNamedItem("style");
        res = styleAttr != null ? BatikTextReader.getCharacterAttributes(styleAttr.getNodeValue(), text.getAttributes()) : new SimpleAttributeSet();
        return res;
    }

    public static SimpleAttributeSet getCharacterAttributes(String styleAttrValue, NamedNodeMap otherAttrs) throws ParseException {
        String fontVariantValue;
        SimpleAttributeSet res = new SimpleAttributeSet();
        Map<String, String> styleValues = BatikTextReader.parseSVGStyleAttribute(styleAttrValue);
        if (styleValues.containsKey("baseline-shift")) {
            Node subSuperScriptAttribute = null;
            if (otherAttrs != null) {
                subSuperScriptAttribute = otherAttrs.getNamedItem("syntree-subsuperscript-size");
            }
            if (subSuperScriptAttribute != null) {
                String subSuperScriptVal = subSuperScriptAttribute.getNodeValue();
                Double subSuperScriptScaledSize = new Double(subSuperScriptVal.substring(0, subSuperScriptVal.length() - 3));
                res.addAttribute("syntree-subsuperscript-size", subSuperScriptScaledSize);
                StyleConstants.setFontSize(res, (int)((double)Math.round(subSuperScriptScaledSize) / 0.58));
                styleValues.remove("font-size");
            } else {
                throw new ParseException("Invalid definition of sub / superscript text style!\nCompulsory property 'syntree-subsuperscript-size' not defined with property 'baseline-shift'\nThis property is necessary in SynTree's implementation for sub and superscript text.", 0);
            }
        }
        if (styleValues.containsKey("font-variant") && (fontVariantValue = styleValues.get("font-variant")).equals("small-caps")) {
            Node smallCapsAttribute = null;
            if (otherAttrs != null) {
                smallCapsAttribute = otherAttrs.getNamedItem("syntree-smallcaps");
            }
            if (smallCapsAttribute != null) {
                String smallCapsAttribVal = smallCapsAttribute.getNodeValue();
                Double scaledFontSize = new Double(smallCapsAttribVal.substring(0, smallCapsAttribVal.length() - 3));
                StyleConstants.setFontSize(res, (int)Math.round(scaledFontSize));
                res.addAttribute("syntree-smallcaps", scaledFontSize);
                styleValues.remove("font-size");
                styleValues.remove("font-variant");
            } else {
                if (!styleValues.containsKey("baseline-shift")) {
                    throw new ParseException("Invalid definition of small caps font style!\nCompulsory property 'syntree-smallcaps' not defined with property 'font-variant'\nThis property is necessary in SynTree's implementation for small cap font.", 0);
                }
                res.addAttribute("syntree-smallcaps", 0.0);
            }
        }
        for (String key : styleValues.keySet()) {
            if (key.equals("font-size")) {
                StyleConstants.setFontSize(res, Integer.parseInt(styleValues.get(key)));
                continue;
            }
            if (key.equals("font-family")) {
                StyleConstants.setFontFamily(res, styleValues.get(key));
                continue;
            }
            if (key.equals("font-weight")) {
                StyleConstants.setBold(res, styleValues.get(key).equals("bold"));
                continue;
            }
            if (key.equals("font-style")) {
                StyleConstants.setItalic(res, styleValues.get(key).equals("italic"));
                continue;
            }
            if (key.equals("text-decoration")) {
                if (styleValues.get(key).indexOf("underline") > -1) {
                    StyleConstants.setUnderline(res, styleValues.get(key).indexOf("underline") > -1);
                }
                if (styleValues.get(key).indexOf("line-through") <= -1) continue;
                StyleConstants.setStrikeThrough(res, styleValues.get(key).indexOf("line-through") > -1);
                continue;
            }
            if (key.equals("fill")) {
                String hexColor = styleValues.get(key);
                Color fillColor = null;
                if (hexColor.startsWith("#")) {
                    if (hexColor.length() == 4) {
                        hexColor = hexColor + hexColor.charAt(hexColor.length() - 1);
                        hexColor = hexColor + hexColor.charAt(hexColor.length() - 1);
                        hexColor = hexColor + hexColor.charAt(hexColor.length() - 1);
                    }
                    fillColor = Color.decode(hexColor);
                } else if (hexColor.startsWith("rgb")) {
                    Pattern c = Pattern.compile("rgb *\\( *([0-9]+), *([0-9]+), *([0-9]+) *\\)");
                    Matcher m = c.matcher(hexColor);
                    if (m.matches()) {
                        fillColor = new Color(Integer.valueOf(m.group(1)), Integer.valueOf(m.group(2)), Integer.valueOf(m.group(3)));
                    } else {
                        throw new ParseException("Unparseble syntax for fill color value '" + hexColor + "'!", 0);
                    }
                }
                if (fillColor == null) continue;
                StyleConstants.setForeground(res, fillColor);
                continue;
            }
            if (!key.equals("baseline-shift")) continue;
            String baselineShiftValue = styleValues.get(key);
            if (baselineShiftValue.equals("63.0%") || baselineShiftValue.equals("super")) {
                StyleConstants.setSuperscript(res, true);
                continue;
            }
            if (!baselineShiftValue.equals("-18.0%") && !baselineShiftValue.equals("sub")) continue;
            StyleConstants.setSubscript(res, true);
        }
        return res;
    }

    public static int writeText(DefaultStyledDocument docToUpdate, int startPosition, Node text) throws BadLocationException, IOException {
        NodeList textNodeChildren = text.getChildNodes();
        int numCharsWritten = 0;
        for (int i = 0; i < textNodeChildren.getLength(); ++i) {
            Node textNodeChild = textNodeChildren.item(i);
            if (IGNORE_READABILITY_WHITESPACE.matcher(textNodeChild.getNodeValue()).matches()) continue;
            String s = textNodeChild.getNodeValue();
            if (trimLeadingAndTrailingWhitespace) {
                s = s.replaceAll("\n", "");
                if (!"\n".equals(BatikTextWriter.documentLineBreak)) {
                    s = s.replaceAll(BatikTextWriter.documentLineBreak, "");
                }
                s = s.replaceAll(tabCharacter, "");
                s = s.replaceAll("\t", "");
            }
            SimpleAttributeSet localAttribs = null;
            try {
                localAttribs = BatikTextReader.getCharacterAttributes(text);
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            SimpleAttributeSet mergedStyleAttribs = new SimpleAttributeSet(lastParagraphStyle.copyAttributes());
            mergedStyleAttribs.addAttributes(localAttribs);
            lastCharacterStyle = mergedStyleAttribs;
            docToUpdate.insertString(startPosition, s, mergedStyleAttribs);
            numCharsWritten += s.length();
        }
        if (numCharsWritten == 0) {
            System.err.println("No text was written for text node: " + text.getNodeValue());
        }
        return numCharsWritten;
    }

    public static Map<String, String> parseSVGStyleAttribute(String style) throws ParseException {
        HashMap<String, String> styleValues = new HashMap<String, String>();
        StringTokenizer strTok = new StringTokenizer(style);
        String attribute = null;
        String value = null;
        while (strTok.hasMoreTokens()) {
            attribute = strTok.nextToken(":");
            attribute = attribute.replaceAll(";", "");
            attribute = attribute.trim();
            if (!strTok.hasMoreTokens()) continue;
            value = strTok.nextToken(";");
            value = value.replaceAll("'", "");
            value = value.replaceAll(":", "");
            value = value.trim();
            if (attribute.equals("font-size")) {
                if (!value.endsWith("pt")) {
                    throw new ParseException("No or unsupported font size unit found!\nOnly 'pt' unit is supported.", style.indexOf(value));
                }
                value = value.replace("pt", "");
            } else if (attribute.equals("font-style")) {
                if (!value.equals("normal") && !value.equals("italic")) {
                    throw new ParseException("Unsupported value (" + value + ") found with attribute '" + "font-style" + "'!\n Only '" + "normal" + "' and '" + "italic" + "' are supported.", style.indexOf(value));
                }
            } else if (attribute.equals("text-decoration")) {
                if (value.indexOf("underline") == -1 && value.indexOf("line-through") == -1) {
                    throw new ParseException("Unsupported value (" + value + ") found with attribute '" + "text-decoration" + "'!\n Only '" + "underline" + "' and '" + "line-through" + "' are supported.", style.indexOf(value));
                }
            } else if (attribute.equals("font-weight")) {
                if (!value.equals("normal") && !value.equals("bold")) {
                    throw new ParseException("Unsupported value (" + value + ") found with attribute '" + "font-weight" + "'!\n Only '" + "normal" + "' and '" + "bold" + "' are supported.", style.indexOf(value));
                }
            } else if (attribute.equals("fill")) {
                if (!value.startsWith("#") && !value.startsWith("rgb")) {
                    throw new ParseException("Unsupported value (" + value + ") found with attribute '" + "color" + "'!\n Value should be in hexadecimal and start with a '#' or in rgb(xxx, xxx, xxx) format where xxx is between 0 - 255.", style.indexOf(value));
                }
            } else if (attribute.equals("text-align")) {
                if (!(value.equals("start") || value.equals("middle") || value.equals("end"))) {
                    throw new ParseException("Unsupported value (" + value + ") found with attribute '" + "text-align" + "'!\n Value should be '" + "start" + "', '" + "middle" + "' or '" + "end" + "'.", style.indexOf(value));
                }
            } else if (attribute.equals("line-height")) {
                if (value.matches("/[a-zA-Z]/")) {
                    throw new ParseException("Unsupported value (" + value + ") found with attribute '" + "line-height" + "'!\n Value should be a factor consisting of integers or fractions.", style.indexOf(value));
                }
            } else if (attribute.equals("baseline-shift")) {
                if (!value.equals("super") && !value.equals("sub") && value.indexOf("%") == -1) {
                    throw new ParseException("Unsupported value (" + value + ") found with attribute '" + "baseline-shift" + "'!\n Value should be '" + "super" + "', '" + "sub" + "' or a percentage (ended with '%').", style.indexOf(value));
                }
            } else if (attribute.equals("font-variant") && !value.equals("small-caps") && !value.equals("normal")) {
                throw new ParseException("Unsupported value (" + value + ") found with attribute '" + "font-variant" + "'!\n Value should be '" + "small-caps" + "' or '" + "normal" + "'.", style.indexOf(value));
            }
            styleValues.put(attribute, value);
        }
        return styleValues;
    }

    public static int countChildNodes(Node node, String name) {
        int numOfChildren = 0;
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!childNodes.item(i).getNodeName().equals(name)) continue;
            ++numOfChildren;
        }
        return numOfChildren;
    }

    public static float convertPixelsToPoints(float pixels, float dpi) {
        return pixels * 72.0f / dpi;
    }

    public static float convertPointsToPixels(float points, float dpi) {
        return points * (dpi / 72.0f);
    }

    public static int getScreenDPI(Component context) {
        Toolkit contextKit;
        int dpi = -1;
        dpi = context == null ? Toolkit.getDefaultToolkit().getScreenResolution() : ((contextKit = context.getToolkit()) != null ? contextKit.getScreenResolution() : Toolkit.getDefaultToolkit().getScreenResolution());
        return dpi;
    }
}

