/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.batik.texteditor.editorkit;

import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.rug.batik.texteditor.SVGFlowRootJTextPane;
import nl.rug.batik.texteditor.editorkit.BatikTextReader;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGOMTSpanElement;
import org.apache.batik.dom.svg.SVGOMTextElement;
import org.apache.batik.dom.svg12.SVGOMFlowRootElement;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGRect;
import org.xml.sax.SAXException;

public class BatikTextWriter {
    public static final String SVGNS = "http://www.w3.org/2000/svg";
    public static boolean useIndenting = false;
    protected static javax.swing.text.Element lastWrittenText = null;
    public static final String documentLineBreak = System.getProperty("line.separator");
    public static final float DEFAULT_TEXT_ELEMENT_LINE_SPACING = 5.0f;
    public static final float MULTI_LINE_TEXT_WIDTH_MARGIN = 6.0f;
    public static final float DEFAULT_FLOWROOT_WIDTH = 2.0f;
    public static final float DEFAULT_FLOWROOT_HEIGHT = 4.0f;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(Document document, int startPosition, int length, Writer out, SVGFlowRootJTextPane editor) throws IOException, BadLocationException, NoninvertibleTransformException {
        out.write("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.2\">");
        if (useIndenting) {
            out.write(documentLineBreak + "    ");
        }
        out.write("<flowRoot>");
        if (useIndenting) {
            out.write(documentLineBreak + "        ");
        }
        out.write("<flowRegion>");
        if (useIndenting) {
            out.write(documentLineBreak + "            ");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<flowDiv>");
        javax.swing.text.Element root = document.getDefaultRootElement();
        int iStart = root.getElementIndex(startPosition);
        int iEnd = root.getElementIndex(startPosition + length);
        for (int i = iStart; i <= iEnd; ++i) {
            javax.swing.text.Element par = root.getElement(i);
            try {
                BatikTextWriter.writeParagraph(par, startPosition, length, buffer);
                continue;
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        if (useIndenting) {
            buffer.append(documentLineBreak + "        ");
        }
        buffer.append("</flowDiv>");
        if (useIndenting) {
            buffer.append(documentLineBreak + "    ");
        }
        SVGOMFlowRootElement labelToEdit = editor.getSVGOMFlowRootElement();
        Rectangle2D flowRootBounds = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            org.w3c.dom.Document dom = db.parse(new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + buffer.toString()).getBytes("UTF-8")));
            flowRootBounds = BatikTextWriter.determineFlowRootDimensions(dom.getDocumentElement(), (AbstractDocument)labelToEdit.getOwnerDocument());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new IOException(pce.getCause());
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new IOException(se.getCause());
        }
        NodeList pathElements = labelToEdit.getElementsByTagNameNS(SVGNS, "path");
        if (pathElements.getLength() != 1) throw new IOException("Error occurred while converting changed label back to SVG.\nThe provided SVG label for editing contains multiple <path> tags to wrap the edited text into, but only one can be handled by SynTree.\nSynTree does not know which tag to use, cancelling conversion.");
        SVGOMPathElement pathElement = (SVGOMPathElement)pathElements.item(0);
        SVGPathSeg pathSeg = pathElement.getPathSegList().getItem(0);
        if (pathSeg.getPathSegType() != 2) throw new IOException("'d' attribute of <path> tag does not start with required SVG absolute MOVE_TO segment (i.e. 'M').\nCannot validly recalculate text wrap area to reflect the edit.\nAborting conversion of text edits to SVG.");
        double width = flowRootBounds.getWidth() + 1.0;
        double height = flowRootBounds.getHeight();
        String dAttribValue = "M" + -0.5 * width + "," + -0.5 * height + " ";
        dAttribValue = dAttribValue + "l" + width + "," + 0.0f + " ";
        dAttribValue = dAttribValue + "l0.0," + height + " ";
        dAttribValue = dAttribValue + "l" + -width + "," + 0.0f + " ";
        dAttribValue = dAttribValue + "z";
        out.write("<path fill=\"none\" d=\"" + dAttribValue + "\"/>");
        if (useIndenting) {
            out.write(documentLineBreak + "        ");
        }
        out.write("</flowRegion>");
        if (useIndenting) {
            out.write(documentLineBreak + "        ");
        }
        out.write(buffer.toString());
        out.write("</flowRoot>");
        if (useIndenting) {
            out.write(documentLineBreak);
        }
        out.write("</svg>");
    }

    public static void writeParagraph(javax.swing.text.Element paragraph, int startPosition, int length, StringBuffer buffer) throws IOException, BadLocationException, ParseException {
        TabSet ts;
        if (useIndenting) {
            buffer.append(documentLineBreak + "            ");
        }
        buffer.append("<flowPara");
        boolean isStartParagraphOpen = true;
        AttributeSet paragraphAttributes = paragraph.getAttributes();
        boolean isStyleAttrAdded = false;
        if (paragraphAttributes.isDefined(AbstractDocument.BranchElement.ResolveAttribute) && paragraphAttributes.getAttributeCount() > 1 || !paragraphAttributes.isDefined(AbstractDocument.BranchElement.ResolveAttribute) && paragraphAttributes.getAttributeCount() > 0) {
            buffer.append(" style=\"");
            isStyleAttrAdded = true;
            if (paragraphAttributes.isDefined(StyleConstants.Alignment)) {
                int align = StyleConstants.getAlignment(paragraphAttributes);
                String textAlign = null;
                if (align == 0) {
                    textAlign = "start";
                } else if (align == 1) {
                    textAlign = "middle";
                } else if (align == 2) {
                    textAlign = "end";
                } else {
                    throw new ParseException("Unsupported alignment value '" + align + "' found.", startPosition);
                }
                buffer.append("text-align:" + textAlign + ";");
            }
            BatikTextWriter.writeCharacterAttributes(buffer, paragraph);
        }
        if ((ts = StyleConstants.getTabSet(paragraphAttributes)) != null) {
            throw new IOException("TabSet saving is not supported!");
        }
        int paragraphFontSize = 1;
        for (int i = 0; i < paragraph.getElementCount(); ++i) {
            javax.swing.text.Element child = paragraph.getElement(i);
            int startOffset = child.getStartOffset();
            String text = child.getDocument().getText(startOffset, child.getEndOffset() - startOffset);
            if (child.getAttributes().getAttributeCount() <= 0 || !child.getName().equals("content") || text.equals(documentLineBreak)) continue;
            paragraphFontSize = Math.max(StyleConstants.getFontSize(child.getAttributes()), paragraphFontSize);
        }
        int iStart = paragraph.getElementIndex(startPosition);
        int iEnd = paragraph.getElementIndex(startPosition + length);
        int numOfEmptyChildren = BatikTextWriter.countEmptyChildElements(paragraph);
        int nonEmptyChildren = paragraph.getElementCount() - numOfEmptyChildren;
        if (numOfEmptyChildren != paragraph.getElementCount()) {
            for (int i = iStart; i <= iEnd; ++i) {
                javax.swing.text.Element child = paragraph.getElement(i);
                int textStart = Math.max(startPosition, child.getStartOffset());
                int textEnd = Math.min(startPosition + length, child.getEndOffset());
                String s = child.getDocument().getText(textStart, textEnd - textStart);
                if (s.isEmpty() || BatikTextReader.IGNORE_READABILITY_WHITESPACE.matcher(s).matches()) continue;
                if (child.getAttributes().getAttributeCount() > 0 && child.getName().equals("content") && nonEmptyChildren == 1) {
                    if (!isStyleAttrAdded) {
                        buffer.append(" style=\"");
                    }
                    BatikTextWriter.writeCharacterAttributes(buffer, child);
                    buffer.append("\"");
                    BatikTextWriter.writeCustomAttributes(buffer, child.getAttributes());
                    isStyleAttrAdded = false;
                    if (isStartParagraphOpen) {
                        buffer.append(">");
                        isStartParagraphOpen = false;
                    }
                    BatikTextWriter.writeText(child, startPosition, length, buffer);
                    lastWrittenText = child;
                    continue;
                }
                if (child.getAttributes().getAttributeCount() > 0 && child.getName().equals("content") && nonEmptyChildren > 1) {
                    if (isStyleAttrAdded) {
                        buffer.append("font-size:" + paragraphFontSize + "pt;");
                        buffer.append("\"");
                        isStyleAttrAdded = false;
                    }
                    if (isStartParagraphOpen) {
                        buffer.append(">");
                        isStartParagraphOpen = false;
                    }
                    BatikTextWriter.writeSpan(child, startPosition, length, buffer);
                    lastWrittenText = child;
                    continue;
                }
                if (child.getName().equals("content")) {
                    if (isStyleAttrAdded) {
                        buffer.append("\"");
                        isStyleAttrAdded = false;
                    }
                    if (isStartParagraphOpen) {
                        buffer.append(">");
                        isStartParagraphOpen = false;
                    }
                    BatikTextWriter.writeText(child, startPosition, length, buffer);
                    lastWrittenText = child;
                    continue;
                }
                if (child.getName().equals("paragraph")) {
                    if (isStyleAttrAdded) {
                        buffer.append("font-size:" + paragraphFontSize + "pt;");
                        buffer.append("\"");
                        isStyleAttrAdded = false;
                    }
                    if (isStartParagraphOpen) {
                        buffer.append(">");
                        isStartParagraphOpen = false;
                    }
                    BatikTextWriter.writeParagraph(child, startPosition, length, buffer);
                    continue;
                }
                throw new ParseException("Illegal enclosing of SVG tag '" + child.getName() + "' in <" + "flowPara" + "> tag!\nOnly <" + "flowSpan" + "> tags, <" + "flowPara" + "> and text are allowed.", startPosition);
            }
        } else if (lastWrittenText != null) {
            BatikTextWriter.writeCharacterAttributes(buffer, lastWrittenText);
        }
        if (isStyleAttrAdded) {
            buffer.append("\"");
            isStyleAttrAdded = false;
        }
        if (isStartParagraphOpen) {
            buffer.append(">");
            isStartParagraphOpen = false;
        }
        buffer.append("</flowPara>");
    }

    public static void writeSpan(javax.swing.text.Element span, int startPosition, int length, StringBuffer buffer) throws IOException, BadLocationException, ParseException {
        buffer.append("<flowSpan");
        AttributeSet attributes = span.getAttributes();
        if (attributes.getAttributeCount() > 0) {
            BatikTextWriter.writeCustomAttributes(buffer, attributes);
            buffer.append(" style=\"");
            BatikTextWriter.writeCharacterAttributes(buffer, span);
            buffer.append("\"");
        }
        buffer.append(">");
        int iStart = span.getElementIndex(startPosition);
        int iEnd = span.getElementIndex(startPosition + length);
        if (iStart == -1 && iEnd == -1) {
            BatikTextWriter.writeText(span, startPosition, length, buffer);
        } else {
            for (int i = iStart; i <= iEnd; ++i) {
                javax.swing.text.Element child = span.getElement(i);
                if (child.getName().equals("flowSpan")) {
                    BatikTextWriter.writeSpan(child, startPosition, length, buffer);
                    continue;
                }
                if (child.getName().equals("content")) {
                    BatikTextWriter.writeText(child, startPosition, length, buffer);
                    continue;
                }
                throw new ParseException("Illegal enclosing of SVG tag '" + child.getName() + "' in <" + "flowSpan" + "> tag!\nOnly <" + "flowSpan" + "> tags and text are allowed.", startPosition);
            }
        }
        buffer.append("</flowSpan>");
    }

    public static void writeText(javax.swing.text.Element text, int startPosition, int length, StringBuffer buffer) throws IOException, BadLocationException {
        int textStart = Math.max(startPosition, text.getStartOffset());
        int textEnd = Math.min(startPosition + length, text.getEndOffset());
        String s = text.getDocument().getText(textStart, textEnd - textStart);
        if (s.endsWith(documentLineBreak)) {
            int removeNumChars = documentLineBreak.length();
            s = s.substring(0, s.length() - removeNumChars);
        } else if (s.endsWith("\n")) {
            int removeNumChars = "\n".length();
            s = s.substring(0, s.length() - removeNumChars);
        }
        s = BatikTextWriter.escapeForXML(s);
        buffer.append(s);
    }

    public static void writeCharacterAttributes(StringBuffer buffer, javax.swing.text.Element nodeWithAttr) throws IOException, ParseException {
        AttributeSet attributes = nodeWithAttr.getAttributes();
        if (attributes.isDefined("syntree-smallcaps")) {
            buffer.append("font-variant:small-caps;");
        }
        if (attributes.isDefined(StyleConstants.Superscript) || attributes.isDefined(StyleConstants.Subscript)) {
            boolean isSuperScripted = StyleConstants.isSuperscript(nodeWithAttr.getAttributes());
            boolean isSubScripted = StyleConstants.isSubscript(nodeWithAttr.getAttributes());
            if (isSuperScripted || isSubScripted) {
                buffer.append("baseline-shift:");
                if (isSuperScripted) {
                    buffer.append("63.0%");
                } else if (isSubScripted) {
                    buffer.append("-18.0%");
                }
                buffer.append(";");
                int fontSize = StyleConstants.getFontSize(attributes);
                double subSuperScriptFontSize = 0.58 * (double)fontSize;
                buffer.append("font-size:" + (int)Math.round(subSuperScriptFontSize) + "pt;");
            }
        } else if (attributes.isDefined(StyleConstants.FontSize)) {
            int fs = StyleConstants.getFontSize(attributes);
            buffer.append("font-size:" + fs + "pt;");
        }
        if (attributes.isDefined(StyleConstants.FontFamily)) {
            int familyEnd;
            int containsFamily;
            String name = StyleConstants.getFontFamily(attributes);
            int latestStyleAttrParentPos = buffer.lastIndexOf("flowSpan");
            if (latestStyleAttrParentPos == -1) {
                latestStyleAttrParentPos = buffer.lastIndexOf("flowPara");
            }
            if (latestStyleAttrParentPos > -1 && (containsFamily = buffer.indexOf("font-family", latestStyleAttrParentPos)) > -1 && (familyEnd = buffer.indexOf(";", containsFamily)) > -1) {
                buffer.delete(containsFamily, familyEnd + 1);
            }
            buffer.append("font-family:'" + name + "';");
        }
        if (attributes.isDefined(StyleConstants.Bold)) {
            boolean bold = StyleConstants.isBold(attributes);
            buffer.append("font-weight:" + (bold ? "bold" : "normal") + ";");
        }
        if (attributes.isDefined(StyleConstants.Italic)) {
            boolean italic = StyleConstants.isItalic(attributes);
            buffer.append("font-style:" + (italic ? "italic" : "normal") + ";");
        }
        if (attributes.isDefined(StyleConstants.Underline) || attributes.isDefined(StyleConstants.StrikeThrough)) {
            boolean underline = StyleConstants.isUnderline(nodeWithAttr.getAttributes());
            boolean strikeThrough = StyleConstants.isStrikeThrough(nodeWithAttr.getAttributes());
            if (underline || strikeThrough) {
                buffer.append("text-decoration:");
                if (underline) {
                    buffer.append("underline");
                }
                if (strikeThrough) {
                    if (underline) {
                        buffer.append(",");
                    }
                    buffer.append("line-through");
                }
                buffer.append(";");
            }
        }
        if (attributes.isDefined(StyleConstants.Foreground)) {
            Color fontColor = StyleConstants.getForeground(nodeWithAttr.getAttributes());
            String hexCode = Integer.toHexString(fontColor.getRGB() & 0xFFFFFF | 0x1000000).substring(1);
            buffer.append("fill:#" + hexCode + ";");
        }
    }

    public static void writeCustomAttributes(StringBuffer buffer, AttributeSet attributes) {
        Object isSuperscript = attributes.getAttribute(StyleConstants.Superscript);
        Object isSubscript = attributes.getAttribute(StyleConstants.Subscript);
        if (isSuperscript != null || isSubscript != null) {
            if (isSuperscript != null && ((Boolean)isSuperscript).booleanValue() || isSubscript != null && ((Boolean)isSubscript).booleanValue()) {
                double subSuperScriptFontSize = 0.58 * (double)StyleConstants.getFontSize(attributes);
                buffer.append(" syntree-subsuperscript-size=\"" + subSuperScriptFontSize + "pt;\"");
            }
        } else if (attributes.getAttribute("syntree-smallcaps") != null) {
            double smallCapsFontSize = (Double)attributes.getAttribute("syntree-smallcaps");
            buffer.append(" syntree-smallcaps=\"" + smallCapsFontSize + "pt;\"");
        }
    }

    public static String escapeForXML(String source) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '>') {
                res.append("&gt;");
                continue;
            }
            if (c == '<') {
                res.append("&lt;");
                continue;
            }
            if (c == '&') {
                res.append("&amp;");
                continue;
            }
            if (c == '\"') {
                res.append("&quot;");
                continue;
            }
            if (c == '\t') {
                BatikTextWriter.addChar(9, res);
                continue;
            }
            if (c == '\'') {
                BatikTextWriter.addChar(39, res);
                continue;
            }
            res.append(c);
        }
        return res.toString();
    }

    private static void addChar(Integer charCode, StringBuilder aBuilder) {
        String padding = "";
        if (charCode <= 9) {
            padding = "00";
        } else if (charCode <= 99) {
            padding = "0";
        }
        String number = padding + charCode.toString();
        aBuilder.append("&#").append(number).append(";");
    }

    public static String unescapeForXML(String source) {
        StringBuilder res = new StringBuilder(source);
        int i = res.indexOf("&");
        while (i >= 0) {
            int charEnd;
            String s = res.substring(i);
            if (s.startsWith("&lt;")) {
                res.replace(i, i + 4, "<");
            } else if (s.startsWith("&gt;")) {
                res.replace(i, i + 4, ">");
            } else if (s.startsWith("&amp;")) {
                res.replace(i, i + 5, "&");
            } else if (s.startsWith("&qout;")) {
                res.replace(i, i + 6, "\"");
            } else if (s.startsWith("&#") && (charEnd = res.indexOf(";", i)) >= 0) {
                String cStr = res.substring(i + 2, charEnd);
                char c = (char)Integer.parseInt(cStr);
                res.replace(i, charEnd + 1, c + "");
            }
            i = res.indexOf("&", i + 1);
        }
        return res.toString();
    }

    public static int countEmptyChildElements(javax.swing.text.Element element) throws BadLocationException {
        int numOfChildren = 0;
        for (int i = 0; i < element.getElementCount(); ++i) {
            javax.swing.text.Element child = element.getElement(i);
            int textStart = child.getStartOffset();
            int textEnd = child.getEndOffset();
            String s = child.getDocument().getText(textStart, textEnd - textStart);
            if (!BatikTextReader.IGNORE_READABILITY_WHITESPACE.matcher(s).matches() && !s.isEmpty()) continue;
            ++numOfChildren;
        }
        return numOfChildren;
    }

    public static Rectangle2D determineFlowRootDimensions(Node subject, AbstractDocument context) throws IOException {
        Rectangle2D.Float dimensions = null;
        Element documentElement = context.getDocumentElement();
        float width = 0.0f;
        float height = 0.0f;
        int minFontSize = 0;
        if (subject.getNodeName().equals("flowDiv")) {
            NodeList flowParas = subject.getChildNodes();
            for (int i = 0; i < flowParas.getLength(); ++i) {
                Node flowPara = flowParas.item(i);
                SVGOMTextElement textLine = (SVGOMTextElement)context.createElementNS(SVGNS, "text");
                NamedNodeMap flowParaAttribs = flowPara.getAttributes();
                Node childStyleAttr = null;
                if (flowParaAttribs != null) {
                    childStyleAttr = flowParaAttribs.getNamedItem("style");
                }
                if (childStyleAttr != null) {
                    String childStyleVal = childStyleAttr.getNodeValue();
                    textLine.setAttributeNS(null, "style", childStyleVal);
                    int fontSizeValStart = childStyleVal.indexOf("font-size");
                    if (fontSizeValStart > -1) {
                        String fontSize = childStyleVal.substring(fontSizeValStart += "font-size".length() + 1, childStyleVal.indexOf(";", fontSizeValStart));
                        fontSize = fontSize.replace("pt", "");
                        minFontSize = Integer.parseInt(fontSize);
                    }
                }
                NodeList flowParaChildren = flowPara.getChildNodes();
                for (int j = 0; j < flowParaChildren.getLength(); ++j) {
                    minFontSize = BatikTextWriter.determineFlowSpanDimensions(textLine, flowParaChildren.item(j), context, minFontSize);
                }
                documentElement.appendChild(textLine);
                SVGRect bbox = textLine.getBBox();
                float lineWidth = 0.0f;
                float lineHeight = 0.0f;
                if (!textLine.getTextContent().isEmpty() && bbox != null) {
                    lineWidth = bbox.getWidth();
                    lineHeight = bbox.getHeight();
                }
                documentElement.removeChild(textLine);
                float largestWidth = (float)Math.ceil(Math.max(lineWidth, width));
                if (lineWidth > width) {
                    largestWidth += 6.0f;
                }
                width = largestWidth;
                float mfsPx = BatikTextReader.convertPointsToPixels(minFontSize, BatikTextReader.getScreenDPI(null));
                if (lineHeight < mfsPx) {
                    lineHeight = mfsPx;
                }
                height = (float)Math.ceil(height + lineHeight);
                minFontSize = 0;
            }
            height += 5.0f * (float)(flowParas.getLength() - 1);
        } else {
            throw new IOException("Illegal argument to method.\nExpected 'flowDiv' DOM element, but received " + subject.getNodeName());
        }
        width = width < 1.0E-4f ? (width = 2.0f) : width;
        height = height < 1.0E-4f ? (height = 4.0f) : height;
        dimensions = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        return dimensions;
    }

    private static int determineFlowSpanDimensions(SVGOMElement textLine, Node flowParaChild, AbstractDocument context, int minFontSize) {
        String childText = flowParaChild.getTextContent();
        if (BatikTextReader.IGNORE_READABILITY_WHITESPACE.matcher(childText).matches()) {
            return minFontSize;
        }
        if (flowParaChild.getNodeType() == 3) {
            Text textNode = context.createTextNode(childText);
            textLine.appendChild(textNode);
        } else if (flowParaChild.getNodeName().equals("flowSpan")) {
            SVGOMTSpanElement tspan = (SVGOMTSpanElement)context.createElementNS(SVGNS, "tspan");
            Node spanStyleAttr = flowParaChild.getAttributes().getNamedItem("style");
            if (spanStyleAttr != null) {
                String childStyleVal = spanStyleAttr.getNodeValue();
                tspan.setAttributeNS(null, "style", childStyleVal);
                int fontSizeValStart = childStyleVal.indexOf("font-size");
                if (fontSizeValStart > -1) {
                    String fontSize = childStyleVal.substring(fontSizeValStart += "font-size".length() + 1, childStyleVal.indexOf(";", fontSizeValStart));
                    int spanMinFontSize = Integer.parseInt(fontSize = fontSize.replace("pt", ""));
                    if (spanMinFontSize > minFontSize) {
                        minFontSize = spanMinFontSize;
                    }
                }
            }
            NodeList flowSpanChildren = flowParaChild.getChildNodes();
            for (int i = 0; i < flowSpanChildren.getLength(); ++i) {
                minFontSize = BatikTextWriter.determineFlowSpanDimensions(tspan, flowSpanChildren.item(i), context, minFontSize);
            }
            textLine.appendChild(tspan);
        }
        return minFontSize;
    }
}

