/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.batik.texteditor.editorkit;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.apache.batik.swing.svg.JSVGComponent;

public class ScaledView
extends BoxView {
    public static final double SCALING_COMPENSATION_FACTOR = 1.33;

    public ScaledView(Element elem, int axis) {
        super(elem, axis);
    }

    public double getXZoomFactor() {
        JSVGComponent parentComponent = (JSVGComponent)this.getDocument().getProperty("PARENT_COMPONENT");
        double scalingFactor = 1.0;
        if (parentComponent != null && parentComponent.getViewingTransform() != null) {
            scalingFactor = parentComponent.getViewingTransform().getScaleX();
            scalingFactor *= 1.33;
            double renderScaleX = parentComponent.getRenderingTransform().getScaleX();
            if (renderScaleX != 1.0) {
                scalingFactor *= renderScaleX;
            }
        }
        return scalingFactor;
    }

    public double getYZoomFactor() {
        JSVGComponent parentComponent = (JSVGComponent)this.getDocument().getProperty("PARENT_COMPONENT");
        double scalingFactor = 1.0;
        if (parentComponent != null && parentComponent.getViewingTransform() != null) {
            scalingFactor = parentComponent.getViewingTransform().getScaleY();
            scalingFactor *= 1.33;
            double renderScaleY = parentComponent.getRenderingTransform().getScaleY();
            if (renderScaleY != 1.0) {
                scalingFactor *= renderScaleY;
            }
        }
        return scalingFactor;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Graphics2D g2d = (Graphics2D)g;
        double zoomXFactor = this.getXZoomFactor();
        double zoomYFactor = this.getYZoomFactor();
        AffineTransform old = g2d.getTransform();
        g2d.scale(zoomXFactor, zoomYFactor);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        super.paint(g2d, allocation);
        g2d.setTransform(old);
    }

    @Override
    public float getMinimumSpan(int axis) {
        float f = super.getMinimumSpan(axis);
        f = axis == 0 ? (float)((double)f * this.getXZoomFactor()) : (float)((double)f * this.getYZoomFactor());
        return f;
    }

    @Override
    public float getMaximumSpan(int axis) {
        float f = super.getMaximumSpan(axis);
        f = axis == 0 ? (float)((double)f * this.getXZoomFactor()) : (float)((double)f * this.getYZoomFactor());
        return f;
    }

    @Override
    public float getPreferredSpan(int axis) {
        float f = super.getPreferredSpan(axis);
        f = axis == 0 ? (float)((double)f * this.getXZoomFactor()) : (float)((double)f * this.getYZoomFactor());
        return f;
    }

    @Override
    protected void layout(int width, int height) {
        super.layout(new Double((double)width / this.getXZoomFactor()).intValue(), new Double((double)height * this.getYZoomFactor()).intValue());
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        double zoomXFactor = this.getXZoomFactor();
        double zoomYFactor = this.getYZoomFactor();
        Rectangle alloc = a.getBounds();
        Shape s = super.modelToView(pos, alloc, b);
        alloc = s.getBounds();
        alloc.x = (int)((double)alloc.x * zoomXFactor);
        alloc.y = (int)((double)alloc.y * zoomYFactor);
        alloc.width = (int)((double)alloc.width * zoomXFactor);
        alloc.height = (int)((double)alloc.height * zoomYFactor);
        return alloc;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        double zoomXFactor = this.getXZoomFactor();
        double zoomYFactor = this.getYZoomFactor();
        Rectangle alloc = a.getBounds();
        x = (float)((double)x / zoomXFactor);
        y = (float)((double)y / zoomYFactor);
        alloc.x = (int)((double)alloc.x / zoomXFactor);
        alloc.y = (int)((double)alloc.y / zoomYFactor);
        alloc.width = (int)((double)alloc.width / zoomXFactor);
        alloc.height = (int)((double)alloc.height / zoomYFactor);
        return super.viewToModel(x, y, alloc, bias);
    }
}

