/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree;

import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import nl.rug.syntree.Settings;
import nl.rug.syntree.bracketstructure.BracketView;
import nl.rug.syntree.hierarchicalmodel.HierarchicalClipboard;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.exporters.SerialExporter;
import nl.rug.syntree.mainview.MainFrame;
import nl.rug.syntree.mainview.UIUtilities;
import nl.rug.syntree.mainview.components.FormatActions;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.treediagram.TreeView;

public class Main {
    private static boolean inited = false;
    private static boolean noBv = false;
    private static int windows = 0;

    public static void globalInit() {
        if (inited) {
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        UIIcons.init();
        Settings.init();
        FormatActions.init();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread arg0, Throwable arg1) {
                System.err.println("Uncaught!");
                if (arg1 == null) {
                    System.err.println("Throwable is null!!");
                } else {
                    UIUtilities.handleException(arg1, null, null);
                }
            }
        });
        inited = true;
    }

    private static void startupDialog() {
        String startupMsg = "Welcome to Syntree v0.8 - Beta!\n\nNote that this is an extremely bleeding edge, alpha version.\nIt is almost completely broken, so don't use this for anything\nother than to have fun at our (the developers) expense.\n\nWhen you're done laughing at the many mistakes in this program,\nyou can help us fix them by pointing them out. To do this press the\nred/white exclamation-mark button labeled 'Bug report'. A dialog will\nappear containing further instructions. This dialog may also appear when\nSyntree runs into an error and happens to catch it by itself.\n\nGood luck!\n";
        JCheckBox box = new JCheckBox("Don't show this again");
        JOptionPane.showMessageDialog(null, new Object[]{startupMsg, box});
        Settings.set("startup-diag", Boolean.valueOf(!box.isSelected()));
    }

    public static void main(String[] argv) {
        File f;
        Main.globalInit();
        Vector<String> args = new Vector<String>();
        args.addAll(Arrays.asList(argv));
        if (args.remove("--purge-settings")) {
            Settings.purge();
        }
        if (args.remove("--no-bracket-view")) {
            noBv = true;
        }
        if (args.remove("--no-save-nag")) {
            Settings.DO_SAVE_NAG = false;
        }
        if (args.remove("--bv-no-change-update")) {
            Settings.BV_DISABLE_CHGUPD = true;
        }
        if (args.remove("--tv-enable-dump-svg")) {
            Settings.ENABLE_DUMP_SVG = true;
        }
        if (args.remove("--tv-keylistener")) {
            Settings.TREEVIEW_KEYLISTENER = true;
        }
        HierarchicalModel model = null;
        if (args.size() > 0 && (f = new File((String)args.get(0))).exists()) {
            model = SerialExporter.fileToModel(f);
        }
        if (model != null) {
            Main.addWindow(model, new HierarchicalClipboard());
        } else {
            Main.addWindow(new HierarchicalClipboard());
        }
    }

    public static void addWindow(HierarchicalClipboard clipboard) {
        HierarchicalModel model = new HierarchicalModel();
        HierarchicalNode root = new HierarchicalNode(model);
        root.addChild(new HierarchicalNode(model));
        root.addChild(new HierarchicalNode(model));
        model.addTree(root);
        Main.addWindow(model, clipboard);
    }

    public static void addWindow(HierarchicalModel model, HierarchicalClipboard clipboard) {
        HierarchicalController control = new HierarchicalController(model, clipboard);
        MainFrame mf = new MainFrame(control);
        TreeView tv = new TreeView(0, control, mf);
        control.setMf(mf);
        tv.init();
        BracketView bv = null;
        if (!noBv) {
            bv = new BracketView(2, mf, control);
        }
        ++windows;
        mf.init(tv, bv);
        mf.setVisible(true);
        mf.setLocationRelativeTo(null);
    }

    public static void closeWindow() {
        if (--windows < 1) {
            Settings.save();
            System.exit(0);
        }
    }
}

