/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Timer;

public class RepeatingReleasedEventsFixer
implements AWTEventListener {
    private final Map<Integer, ReleasedAction> _map = new HashMap<Integer, ReleasedAction>();

    public void install() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    public void remove() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        assert (event instanceof KeyEvent) : "Shall only listen to KeyEvents, so no other events shall come here";
        assert (RepeatingReleasedEventsFixer.assertEDT());
        if (event instanceof Reposted) {
            return;
        }
        if (event.getID() == 400) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)event;
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getID() == 402) {
            Timer timer = new Timer(2, null);
            ReleasedAction action = new ReleasedAction(keyEvent, timer);
            timer.addActionListener(action);
            timer.start();
            this._map.put(keyEvent.getKeyCode(), action);
            keyEvent.consume();
        } else if (keyEvent.getID() == 401) {
            ReleasedAction action = this._map.remove(keyEvent.getKeyCode());
            if (action != null) {
                action.cancel();
            }
        } else {
            throw new AssertionError((Object)"All IDs should be covered.");
        }
    }

    private static boolean assertEDT() {
        if (!EventQueue.isDispatchThread()) {
            throw new AssertionError((Object)("Not EDT, but [" + Thread.currentThread() + "]."));
        }
        return true;
    }

    public static class RepostedKeyEvent
    extends KeyEvent
    implements Reposted {
        public RepostedKeyEvent(Component source, int id, long when, int modifiers, int keyCode, char keyChar, int keyLocation) {
            super(source, id, when, modifiers, keyCode, keyChar, keyLocation);
        }
    }

    public static interface Reposted {
    }

    private class ReleasedAction
    implements ActionListener {
        private final KeyEvent _originalKeyEvent;
        private Timer _timer;

        ReleasedAction(KeyEvent originalReleased, Timer timer) {
            this._timer = timer;
            this._originalKeyEvent = originalReleased;
        }

        void cancel() {
            assert (RepeatingReleasedEventsFixer.assertEDT());
            this._timer.stop();
            this._timer = null;
            RepeatingReleasedEventsFixer.this._map.remove(this._originalKeyEvent.getKeyCode());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (RepeatingReleasedEventsFixer.assertEDT());
            if (this._timer == null) {
                return;
            }
            this.cancel();
            RepostedKeyEvent newEvent = new RepostedKeyEvent((Component)this._originalKeyEvent.getSource(), this._originalKeyEvent.getID(), this._originalKeyEvent.getWhen(), this._originalKeyEvent.getModifiers(), this._originalKeyEvent.getKeyCode(), this._originalKeyEvent.getKeyChar(), this._originalKeyEvent.getKeyLocation());
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(newEvent);
        }
    }
}

