/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.exporters.Base64;
import nl.rug.syntree.mainview.View;

public final class Settings {
    private static SettingMap defaults = null;
    private static SettingMap globals = null;
    public static final String VERSION = "0.8";
    public static final String CODENAME = "Beta";
    public static final String DEVEMAIL = "incompleteparenthesis@rug.nl";
    public static final String SUBTITLE = "Practicals version";
    public static final String SELECTED_COLOUR_KEY = "selection-colour";
    private static final Color SELECTED_COLOUR = Color.cyan;
    public static final String STARTUP_DIAG_KEY = "startup-diag";
    private static final boolean STARTUP_DIAG = true;
    public static final String FONT_ALIGNMENT_KEY = "font-alignment";
    private static final int FONT_ALIGNMENT = 1;
    public static final String FONT_BACKGROUND_KEY = "font-background";
    private static final Color FONT_BACKGROUND = Color.white;
    public static final String FONT_BOLD_KEY = "font-bold";
    private static final boolean FONT_BOLD = false;
    public static final String FONT_COLOUR_KEY = "font-colour";
    private static final Color FONT_COLOUR = Color.black;
    public static final String FONT_FACE_KEY = "font-face";
    private static final String FONT_FACE = "Verdana";
    public static final String FONT_ITALIC_KEY = "font-italic";
    private static final boolean FONT_ITALIC = false;
    public static final String FONT_SIZE_KEY = "font-size";
    private static final int FONT_SIZE = 32;
    public static final String FONT_STRIKETHROUGH_KEY = "font-strikethrough";
    private static final boolean FONT_STRIKETHROUGH = false;
    public static final String FONT_SUBSCRIPT_KEY = "font-subscript";
    private static final boolean FONT_SUBSCRIPT = false;
    public static final String FONT_UNDERLINE_KEY = "font-underline";
    private static final boolean FONT_UNDERLINE = false;
    public static final String GHOST_BACKGROUND_COLOUR_KEY = "tv-ghost-bg-colour";
    private static final Color GHOST_BACKGROUND_COLOUR = Color.lightGray;
    public static final String LABEL_MIN_SIZE_KEY = "tv-label-min-size";
    private static final float LABEL_MIN_SIZE = 20.0f;
    public static final String LINE_COLOUR_KEY = "tv-line-colour";
    private static final Color LINE_COLOUR = Color.gray;
    public static final String LINE_WARNING_COLOUR_KEY = "tv-line-warning-colour";
    private static final Color LINE_WARNING_COLOUR = Color.red;
    public static final String LINE_WIDTH_KEY = "tv-line-width";
    private static final int LINE_WIDTH = 3;
    public static final String MARK_MIN_RADIUS_KEY = "tv-mark-min-radius";
    private static final float MARK_MIN_RADIUS = 20.0f;
    public static final String NODE_BACKGROUND_COLOUR_KEY = "tv-node-bg-colour";
    private static final Color NODE_BACKGROUND_COLOUR = Color.white;
    public static final String NODE_HOVER_COLOUR_KEY = "tv-node-hover-colour";
    private static final Color NODE_HOVER_COLOUR = Color.lightGray;
    public static final String POS_SELECTED_COLOUR_KEY = "tv-pos-selected-colour";
    private static final Color POS_SELECTED_COLOUR = Color.lightGray;
    public static final String SHOW_DEPLINES_KEY = "tv-show-deplines";
    private static final boolean SHOW_DEPLINES = true;
    public static final String BRANCH_TYPE_KEY = "tv-branch-type";
    private static final BranchType BRANCH_TYPE = BranchType.DEFAULT;
    public static final String STRIKE_COLOUR_KEY = "tv-strike-colour";
    private static final Color STRIKE_COLOUR = Color.red;
    public static final String LINE_AUX_MIN_OFFSET_KEY = "tv-line-aux-offset";
    private static final float LINE_AUX_MIN_OFFSET = 20.0f;
    public static final String SELECTER_TIMEMIN_KEY = "tv-selecter-timemin";
    private static final long SELECTER_TIMEMIN = 250L;
    public static final String TREEPOS_INVERTED_KEY = "tv-inverted";
    private static final boolean TREEPOS_INVERTED = false;
    public static final String TREEPOS_HORIZONTAL_KEY = "tv-horizontal";
    private static final boolean TREEPOS_HORIZONTAL = false;
    public static final String TREEPOS_LOWER_ENDNODES_KEY = "tv-lower-endnodes";
    private static final boolean TREEPOS_LOWER_ENDNODES = false;
    public static final String TREEPOS_SET_CONSTANT_ANGLE_KEY = "tv-set-constant-angle";
    private static final boolean TREEPOS_SET_CONSTANT_ANGLE = false;
    public static final String TREEPOS_SET_MAX_ANGLE_KEY = "tv-set-max-angle";
    private static final boolean TREEPOS_SET_MAX_ANGLE = false;
    public static final String TREEPOS_SET_MAX_HEIGHT_KEY = "tv-set-max-height";
    private static final boolean TREEPOS_SET_MAX_HEIGHT = false;
    public static final String TREEPOS_CONSTANT_ANGLE_KEY = "tv-constant-angle";
    private static final float TREEPOS_CONSTANT_ANGLE = 90.0f;
    public static final String TREEPOS_MAX_ANGLE_KEY = "tv-max-angle";
    private static final float TREEPOS_MAX_ANGLE = 120.0f;
    public static final String TREEPOS_MAX_HEIGHT_PERC_KEY = "tv-max-height";
    private static final float TREEPOS_MAX_HEIGHT_PERC = 200.0f;
    public static final String TREEPOS_OFFSETX_KEY = "tv-offset-x";
    private static final float TREEPOS_OFFSETX = 5.0f;
    public static final String TREEPOS_OFFSETY_KEY = "tv-offset-y";
    private static final float TREEPOS_OFFSETY = 5.0f;
    public static final String TREEPOS_HORIZONTAL_MARGIN_KEY = "tv-horizontal-margin";
    private static final float TREEPOS_HORIZONTAL_MARGIN = 55.0f;
    public static final String TREEPOS_HORIZONTAL_PERC_KEY = "tv-horizontal-perc";
    private static final float TREEPOS_HORIZONTAL_PERC = 100.0f;
    public static final String TREEPOS_VERTICAL_MARGIN_KEY = "tv-vertical-margin";
    private static final float TREEPOS_VERTICAL_MARGIN = 55.0f;
    public static final String TREEPOS_VERTICAL_PERC_KEY = "tv-vertical-perc";
    private static final float TREEPOS_VERTICAL_PERC = 100.0f;
    public static final String BRACKET_OPT_BACKGROUND_COLOUR_KEY = "bv-bracket-opt-background-colour";
    private static final Color BRACKET_OPT_BACKGROUND_COLOUR = Color.yellow;
    public static final String BRACKET_PARENT_SUBSCRIPT_KEY = "bv-bracket-parent-subscript";
    private static final boolean BRACKET_PARENT_SUBSCRIPT = true;
    public static final String BRACKET_PREG_BRACKGROUND_COLOUR_KEY = "bv-bracket-preg-background-colour";
    private static final Color BRACKET_PREG_BACKGROUND_COLOUR = Color.green;
    public static final String BRACKET_TYPE_CLOSE_KEY = "bv-bracket-type-close";
    private static final String BRACKET_TYPE_CLOSE = "]";
    public static final String BRACKET_TYPE_OPEN_KEY = "bv-bracket-type-open";
    private static final String BRACKET_TYPE_OPEN = "[";
    public static final String SHOW_NODE_BACKGROUND_COLOUR_ENABLED_KEY = "bv-show-node-background-colour-enabled";
    private static final boolean SHOW_NODE_BACKGROUND_COLOUR = true;
    public static final String SHOW_BRANCHES_BACKGROUND_COLOUR_ENABLED_KEY = "bv-show-branches-background-colour-enabled";
    private static final boolean SHOW_BRANCHES_BACKGROUND_COLOUR = true;
    public static final String BRACKET_PARENT_SUPER_KEY = "bv-parent-super";
    private static final boolean BRACKET_PARENT_SUPER = false;
    public static final String BRACKET_PARENT_SUB_KEY = "bv-parent-sub";
    private static final boolean BRACKET_PARENT_SUB = true;
    public static final String BRACKET_PARENT_BOLD_KEY = "bv-parent-bold";
    private static final boolean BRACKET_PARENT_BOLD = false;
    public static final String BRACKET_PARENT_ITALIC_KEY = "bv-parent-italic";
    private static final boolean BRACKET_PARENT_ITALIC = false;
    public static final String KEY_UNDO_KEY = "key-undo";
    private static final KeyStroke KEY_UNDO = KeyStroke.getKeyStroke("control Z");
    public static final String KEY_REDO_KEY = "key-redo";
    private static final KeyStroke KEY_REDO = KeyStroke.getKeyStroke("control Y");
    public static Color UI_BTN_BG = new Color(0.9f, 0.9f, 0.9f);
    public static Color UI_BTN_HOVER = Color.lightGray;
    public static int[] UI_WHTABLE_TICKS = new int[]{0, 100, 200, 300, 400, 500};
    public static int[] UI_ANGTABLE_TICKS = new int[]{20, 40, 60, 80, 100, 120, 140, 160, 180};
    public static int UI_WIDTH_MIN = 0;
    public static int UI_WIDTH_MAX = 300;
    public static int UI_HEIGHT_MIN = 0;
    public static int UI_HEIGHT_MAX = 300;
    public static int UI_ANGLE_MIN = 20;
    public static int UI_ANGLE_MAX = 180;
    public static String BV_HARD_SPACE = "_";
    public static boolean DO_SAVE_NAG = true;
    public static boolean BV_DISABLE_CHGUPD = false;
    public static boolean ENABLE_DUMP_SVG = false;
    public static boolean TREEVIEW_KEYLISTENER = true;

    private static SettingMap makeDefaults() {
        SettingMap ret = new SettingMap();
        ret.put(SELECTED_COLOUR_KEY, SELECTED_COLOUR);
        ret.put(STARTUP_DIAG_KEY, true);
        ret.put(FONT_ALIGNMENT_KEY, 1);
        ret.put(FONT_BACKGROUND_KEY, FONT_BACKGROUND);
        ret.put(FONT_BOLD_KEY, false);
        ret.put(FONT_COLOUR_KEY, FONT_COLOUR);
        ret.put(FONT_FACE_KEY, FONT_FACE);
        ret.put(FONT_ITALIC_KEY, false);
        ret.put(FONT_SIZE_KEY, 32);
        ret.put(FONT_STRIKETHROUGH_KEY, false);
        ret.put(FONT_SUBSCRIPT_KEY, false);
        ret.put(FONT_UNDERLINE_KEY, false);
        ret.put(GHOST_BACKGROUND_COLOUR_KEY, GHOST_BACKGROUND_COLOUR);
        ret.put(LABEL_MIN_SIZE_KEY, Float.valueOf(20.0f));
        ret.put(LINE_COLOUR_KEY, LINE_COLOUR);
        ret.put(LINE_WARNING_COLOUR_KEY, LINE_WARNING_COLOUR);
        ret.put(LINE_WIDTH_KEY, 3);
        ret.put(MARK_MIN_RADIUS_KEY, Float.valueOf(20.0f));
        ret.put(NODE_BACKGROUND_COLOUR_KEY, NODE_BACKGROUND_COLOUR);
        ret.put(NODE_HOVER_COLOUR_KEY, NODE_HOVER_COLOUR);
        ret.put(POS_SELECTED_COLOUR_KEY, POS_SELECTED_COLOUR);
        ret.put(SHOW_DEPLINES_KEY, true);
        ret.put(BRANCH_TYPE_KEY, BRANCH_TYPE);
        ret.put(STRIKE_COLOUR_KEY, STRIKE_COLOUR);
        ret.put(LINE_AUX_MIN_OFFSET_KEY, Float.valueOf(20.0f));
        ret.put(SELECTER_TIMEMIN_KEY, 250L);
        ret.put(TREEPOS_INVERTED_KEY, false);
        ret.put(TREEPOS_HORIZONTAL_KEY, false);
        ret.put(TREEPOS_LOWER_ENDNODES_KEY, false);
        ret.put(TREEPOS_SET_CONSTANT_ANGLE_KEY, false);
        ret.put(TREEPOS_SET_MAX_ANGLE_KEY, false);
        ret.put(TREEPOS_SET_MAX_HEIGHT_KEY, false);
        ret.put(TREEPOS_CONSTANT_ANGLE_KEY, Float.valueOf(90.0f));
        ret.put(TREEPOS_MAX_ANGLE_KEY, Float.valueOf(120.0f));
        ret.put(TREEPOS_MAX_HEIGHT_PERC_KEY, Float.valueOf(200.0f));
        ret.put(TREEPOS_OFFSETX_KEY, Float.valueOf(5.0f));
        ret.put(TREEPOS_OFFSETY_KEY, Float.valueOf(5.0f));
        ret.put(TREEPOS_HORIZONTAL_MARGIN_KEY, Float.valueOf(55.0f));
        ret.put(TREEPOS_HORIZONTAL_PERC_KEY, Float.valueOf(100.0f));
        ret.put(TREEPOS_VERTICAL_MARGIN_KEY, Float.valueOf(55.0f));
        ret.put(TREEPOS_VERTICAL_PERC_KEY, Float.valueOf(100.0f));
        ret.put(BRACKET_OPT_BACKGROUND_COLOUR_KEY, BRACKET_OPT_BACKGROUND_COLOUR);
        ret.put(BRACKET_PARENT_SUBSCRIPT_KEY, true);
        ret.put(BRACKET_PREG_BRACKGROUND_COLOUR_KEY, BRACKET_PREG_BACKGROUND_COLOUR);
        ret.put(BRACKET_TYPE_CLOSE_KEY, BRACKET_TYPE_CLOSE);
        ret.put(BRACKET_TYPE_OPEN_KEY, BRACKET_TYPE_OPEN);
        ret.put(SHOW_NODE_BACKGROUND_COLOUR_ENABLED_KEY, true);
        ret.put(SHOW_BRANCHES_BACKGROUND_COLOUR_ENABLED_KEY, true);
        ret.put(BRACKET_PARENT_SUPER_KEY, false);
        ret.put(BRACKET_PARENT_SUB_KEY, true);
        ret.put(BRACKET_PARENT_BOLD_KEY, false);
        ret.put(BRACKET_PARENT_ITALIC_KEY, false);
        ret.put(KEY_UNDO_KEY, KEY_UNDO);
        ret.put(KEY_REDO_KEY, KEY_REDO);
        return ret;
    }

    private static Serializable from64(String str) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decode(str));
        ObjectInputStream ois = new ObjectInputStream(bis);
        return (Serializable)ois.readObject();
    }

    private static String to64(Serializable obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        return Base64.encodeToString(bos.toByteArray(), false);
    }

    private static Preferences getPrefs() {
        return Preferences.userRoot().node(Settings.class.getPackage().getName());
    }

    private static SettingMap initGlobals() throws BackingStoreException, ClassNotFoundException, IOException {
        SettingMap ret = Settings.makeDefaults();
        Preferences prefs = Settings.getPrefs();
        for (String key : prefs.keys()) {
            Serializable val = Settings.from64(prefs.get(key, null));
            ret.put(key, val);
        }
        return ret;
    }

    private static void saveGlobals(SettingMap set) throws IOException, BackingStoreException {
        Preferences prefs = Settings.getPrefs();
        for (String key : set.keySet()) {
            prefs.put(key, Settings.to64((Serializable)set.get(key)));
        }
        prefs.sync();
    }

    public static Object get(String key) {
        Object ret = globals.get(key);
        if (ret == null) {
            ret = defaults.get(key);
        }
        return ret;
    }

    public static Object get(String key, HierarchicalModel model) {
        Object ret = null;
        if (model != null) {
            ret = model.getSetting(key);
        }
        if (ret == null) {
            ret = Settings.get(key);
        }
        return ret;
    }

    public static Object get(String key, HierarchicalModel model, View view) {
        Object ret = null;
        if (view != null) {
            ret = Settings.get(key + "-" + view.getId(), model);
        }
        if (ret == null) {
            ret = Settings.get(key, model);
        }
        return ret;
    }

    private static void putPrefBytes(Preferences prefs, String key, byte[] val) {
        int to;
        int from;
        int cnt = 0;
        int len = 4096;
        do {
            from = cnt * len;
            to = (cnt + 1) * len;
            int n = to = to > val.length ? val.length : to;
            if (from > to) break;
            byte[] tmp = Arrays.copyOfRange(val, from, to);
            prefs.putByteArray(key + "." + cnt, tmp);
            ++cnt;
        } while (from < to);
        prefs.putInt(key, cnt);
    }

    private static byte[] readPrefBytes(Preferences prefs, String key) throws BackingStoreException, IOException {
        int cnt = prefs.getInt(key, -1);
        if (cnt == -1) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < cnt; ++i) {
            bos.write(prefs.getByteArray(key + "." + i, null));
        }
        return bos.toByteArray();
    }

    public static void defaultStyle(MutableAttributeSet s, HierarchicalModel m) {
        s.addAttribute(StyleConstants.Alignment, (int)((Integer)Settings.get(FONT_ALIGNMENT_KEY, m)));
        s.addAttribute(StyleConstants.FontFamily, (String)Settings.get(FONT_FACE_KEY, m));
        s.addAttribute(StyleConstants.FontSize, (int)((Integer)Settings.get(FONT_SIZE_KEY, m)));
        s.addAttribute(StyleConstants.Foreground, (Color)Settings.get(FONT_COLOUR_KEY, m));
        s.addAttribute(StyleConstants.Subscript, (boolean)((Boolean)Settings.get(FONT_SUBSCRIPT_KEY, m)));
        s.addAttribute(StyleConstants.Bold, (boolean)((Boolean)Settings.get(FONT_BOLD_KEY, m)));
        s.addAttribute(StyleConstants.Italic, (boolean)((Boolean)Settings.get(FONT_ITALIC_KEY, m)));
        s.addAttribute(StyleConstants.StrikeThrough, (boolean)((Boolean)Settings.get(FONT_STRIKETHROUGH_KEY, m)));
        s.addAttribute(StyleConstants.Underline, (boolean)((Boolean)Settings.get(FONT_UNDERLINE_KEY, m)));
        s.addAttribute(StyleConstants.Background, (Color)Settings.get(FONT_BACKGROUND_KEY, m));
    }

    public static void defaultParaStyle(MutableAttributeSet s, HierarchicalModel m) {
        s.addAttribute(StyleConstants.Alignment, (int)((Integer)Settings.get(FONT_ALIGNMENT_KEY, m)));
    }

    public static void init() {
        try {
            defaults = Settings.makeDefaults();
            globals = Settings.initGlobals();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void purge() {
        System.out.println("Settings.purge");
        try {
            globals = Settings.makeDefaults();
            Settings.saveGlobals(globals);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        System.out.println("Settings.save");
        try {
            Settings.saveGlobals(globals);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static void set(String key, Serializable value) {
        globals.put(key, value);
    }

    public static void set(String key, Object val) {
        if (!(val instanceof Serializable)) {
            return;
        }
        Settings.set(key, (Serializable)val);
    }

    public static class SettingMap
    extends HashMap<String, Serializable> {
        private static final long serialVersionUID = 8085646895105032724L;
    }

    public static enum BranchType {
        ANGULATED1("Angulated-1", "icons/tree_angulated1.png"),
        ANGULATED2("Angulated-2", "icons/tree_angulated2.png"),
        DEFAULT("Default", "icons/tree_default.png"),
        DENDROGRAM("Dendrogram", "icons/tree_dendrogram.png"),
        LINKEDSISTER("Linked sister", "icons/tree_linkedsister.png"),
        TRIANGLE("Triangle", "icons/branch_triangle.png");

        private String title;
        private String icon;

        private BranchType(String title, String icon) {
            this.title = title;
            this.icon = icon;
        }

        public String title() {
            return this.title;
        }

        public String icon() {
            return this.icon;
        }
    }
}

