/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.bracketstructure;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.undo.CompoundEdit;
import nl.rug.syntree.bracketstructure.BracketModel;
import nl.rug.syntree.bracketstructure.BracketParser;
import nl.rug.syntree.bracketstructure.BracketView;
import nl.rug.syntree.bracketstructure.PartialUpdate;
import nl.rug.syntree.bracketstructure.Pregnancy;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.mainview.components.NavigatableDialog;

public class BracketController {
    private BracketView bv;
    private HierarchicalController controller;
    private BracketParser parser;
    private BracketModel bracketModel;
    public boolean brackets = false;
    public boolean emptyModel = false;
    public boolean incorrectBracketString = false;
    public boolean consume = false;
    public boolean setCaret = false;
    public int zoomLevel = 0;
    public int caret;
    HierarchicalNode node;
    Pregnancy p;
    int caretCopy;

    public BracketController(BracketView bv, HierarchicalController controller) {
        this.bv = bv;
        this.controller = controller;
        this.parser = new BracketParser(this.bv);
    }

    public void addOuterLayer(boolean before, String content) {
        try {
            int caretPosition = this.bv.getCaretPosition();
            String openingBracket = (String)this.bv.getSetting("bv-bracket-type-open");
            String closingBracket = (String)this.bv.getSetting("bv-bracket-type-close");
            BracketModel.BracketTree tree = this.bracketModel.getBracketTree(caretPosition + (before ? 1 : 0));
            if (tree != null) {
                int nextCaretPosition = caretPosition + (before ? 1 : 2) + (!before || content.length() > 0 ? 1 : 0);
                if (!content.equals(" ")) {
                    if (!content.isEmpty()) {
                        ++nextCaretPosition;
                    }
                    content = " " + content;
                }
                int startIndex = this.bracketModel.startIndex(tree);
                this.bv.updatingDocument = true;
                this.bv.getBracketDocument().insertString(startIndex, openingBracket + (before ? content : "") + " ", this.bv.getDefaultStyle());
                this.bv.updatingDocument = false;
                int endLocation = startIndex + (before ? content.length() + 2 : 2) + tree.getTreeDocument().getLength();
                if (this.bv.getBracketDocument().getText(endLocation - 1, 1).equals("\n")) {
                    --endLocation;
                }
                this.bv.getBracketDocument().insertString(endLocation, (before ? "" : content) + closingBracket, this.bv.getDefaultStyle());
                System.out.println("Setting caret position after adding outer layer");
                this.bv.setCaretPosition(nextCaretPosition);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void addTree(int caret) throws BadLocationException {
        String str = "\n" + (String)this.bv.getSetting("bv-bracket-type-open") + "  " + (String)this.bv.getSetting("bv-bracket-type-close");
        this.bv.getBracketDocument().insertString(caret, str, this.bv.getDefaultStyle());
        this.bv.setCaretPosition(caret + 2);
    }

    private void autoComplete(Pregnancy p, int caret, HierarchicalNode node) throws BadLocationException {
        int cntBracketOpt = 0;
        int c = 0;
        for (int i = 0; i < this.bv.getBracketDocument().getLength(); ++i) {
            Element e = this.bv.getBracketDocument().getCharacterElement(i);
            if (!e.getAttributes().containsAttribute("bracket-opt", "bracket-opt")) continue;
            ++cntBracketOpt;
            c = i;
        }
        if (cntBracketOpt == 1) {
            this.processCaretUpdate(c);
            this.consume = false;
        }
    }

    private boolean checkForEmptyNode(KeyEvent e) throws BadLocationException {
        int caret = this.bv.getCaretPosition();
        DefaultStyledDocument doc = this.bv.getBracketDocument();
        return doc.getText(caret, 1).equals(" ") && !Character.isLetterOrDigit(doc.getText(caret + 1, 1).charAt(0)) && !doc.getText(caret + 1, 1).equals("\\") && !doc.getText(caret + 1, 1).equals("_") && !doc.getText(caret + 1, 1).equals((String)this.bv.getSetting("bv-bracket-type-open"));
    }

    private CompoundEdit compareModels(HierarchicalModel oldModel, HierarchicalModel newModel) {
        int i;
        ArrayList<PartialUpdate> updates = new ArrayList<PartialUpdate>();
        List<HierarchicalNode> oldRoots = oldModel.getRootNodes();
        List<HierarchicalNode> newRoots = newModel.getRootNodes();
        Vector<HierarchicalNode> removals = new Vector<HierarchicalNode>();
        Vector<HierarchicalNode> addals = new Vector<HierarchicalNode>();
        if (oldRoots.size() > newRoots.size()) {
            for (i = oldRoots.size() - 1; i > newRoots.size() - 1; --i) {
                removals.add(oldRoots.get(i));
            }
        }
        for (i = 0; i < oldRoots.size(); ++i) {
            List<PartialUpdate> pu = this.compareNodes(oldRoots.get(i), newRoots.get(i));
            if (pu == null) continue;
            updates.addAll(pu);
        }
        if (oldRoots.size() < newRoots.size()) {
            for (i = oldRoots.size(); i < newRoots.size(); ++i) {
                HierarchicalNode root = new HierarchicalNode(oldModel, newRoots.get(i).getContent());
                root.copyChildren(newRoots.get(i));
                addals.add(root);
            }
        }
        if (updates.size() > 0 || addals.size() > 0 || removals.size() > 0) {
            CompoundEdit ce = new CompoundEdit();
            for (HierarchicalNode node : removals) {
                ce.addEdit(oldModel.removeTree(node));
            }
            for (HierarchicalNode node : addals) {
                ce.addEdit(oldModel.addTree(node));
            }
            for (PartialUpdate pu : updates) {
                ce.addEdit(pu.processUpdate());
            }
            ce.end();
            return ce;
        }
        return null;
    }

    private List<PartialUpdate> compareNodes(HierarchicalNode oldNode, HierarchicalNode newNode) {
        ArrayList<PartialUpdate> updates = new ArrayList<PartialUpdate>();
        if (oldNode.getChildren().size() != newNode.getChildren().size()) {
            updates.add(new PartialUpdate(oldNode, newNode, true, false));
            return updates;
        }
        if (!oldNode.getContent().compareDocumentContent(newNode.getContent())) {
            updates.add(new PartialUpdate(oldNode, newNode, false, false));
        } else if (oldNode.getParent() != null && newNode.getParent() != null) {
            nl.rug.syntree.hierarchicalmodel.annotations.Style s1 = (nl.rug.syntree.hierarchicalmodel.annotations.Style)oldNode.getParent().getBranchFor(oldNode).getTweakByType(Style.class);
            nl.rug.syntree.hierarchicalmodel.annotations.Style s2 = (nl.rug.syntree.hierarchicalmodel.annotations.Style)newNode.getParent().getBranchFor(newNode).getTweakByType(Style.class);
            if (s1 == null || s2 == null || !s1.equals(s2)) {
                updates.add(new PartialUpdate(oldNode, newNode, false, true));
            }
        }
        Vector<HierarchicalNode> newNodeChildren = newNode.getChildren();
        for (int i = 0; i < oldNode.getChildren().size(); ++i) {
            updates.addAll(this.compareNodes(oldNode.getChildren().get(i), newNodeChildren.get(i)));
        }
        return updates;
    }

    private DefaultStyledDocument copyDefaultStyledDocument(DefaultStyledDocument document) throws BadLocationException {
        DefaultStyledDocument doc = (DefaultStyledDocument)this.bv.getEditorKit().createDefaultDocument();
        for (int i = 0; i < document.getLength(); ++i) {
            Element e = document.getCharacterElement(i);
            doc.insertString(doc.getLength(), document.getText(i, 1), e.getAttributes().copyAttributes());
        }
        return doc;
    }

    private void determineChildRemoval(int position, boolean bracketOpen) throws BadLocationException {
        BracketModel.BracketTree t = this.bracketModel.getBracketTree(position);
        int origPosition = position;
        position = bracketOpen ? position - this.bracketModel.startIndex(t) + 1 : position - this.bracketModel.startIndex(t);
        HierarchicalNode node = this.matchCaretPostionToNode(position, t);
        this.bv.setFocusListenerEnabled(false);
        Object[] options = new Object[]{"Remove subtree", "Move children up", "Cancel"};
        JOptionPane optionPane = new JOptionPane("Do you want to remove the entire subtree, or do you want to remove the brackets and label only\n and move the contents one level up.", 3, 1, null, options, options[0]);
        NavigatableDialog dialog = new NavigatableDialog(optionPane, "Removing bracket pair");
        Object result = dialog.getResult();
        if (result != options[0] && result != options[1]) {
            return;
        }
        int bracketPairs = 0;
        for (int i = position - 1; i > 0; --i) {
            String character = t.getTreeDocument().getText(i, 1);
            if (character.equals((String)this.bv.getSetting("bv-bracket-type-close"))) {
                ++bracketPairs;
            }
            if (!character.equals((String)this.bv.getSetting("bv-bracket-type-open"))) continue;
            if (bracketPairs == 0) {
                this.bv.setCaretPosition(i + this.bracketModel.startIndex(t));
                break;
            }
            --bracketPairs;
        }
        if (result == options[0]) {
            int treeLength = t.getTreeDocument().getLength();
            this.controller.clearNode(node);
            int nextPosition = (origPosition - treeLength + 2) % (this.bv.getDocument().getLength() + 2);
            this.putCaretInTree(this.bv.getDocument(), nextPosition);
        } else {
            this.controller.moveChildrenUp(node);
        }
        this.bv.setLengthyActionStage(0);
        this.bv.setFocusListenerEnabled(true);
    }

    private void determinePregnancy(int caret, KeyEvent e, boolean bracketOpen) throws BadLocationException {
        boolean parent = true;
        int childindex = -1;
        String openingBracket = (String)this.bv.getSetting("bv-bracket-type-open");
        String closingBracket = (String)this.bv.getSetting("bv-bracket-type-close");
        if (this.bv.getModel().getRootNodes().size() == 0) {
            return;
        }
        BracketModel.BracketTree t = this.bracketModel.getBracketTree(caret);
        HierarchicalNode node = t.getRoot();
        String str = t.getTreeDocument().getText(0, t.getTreeDocument().getLength());
        int caretCopy = caret;
        System.out.println("caret position in determine pregnancy " + (caret -= this.bracketModel.startIndex(t)));
        if (!bracketOpen && caret == 1 || bracketOpen && caret == str.length() - 1 && !str.substring(caret - 1, caret).equals(" ")) {
            childindex = -2;
        } else {
            if (bracketOpen && str.substring(caret - 1, caret + 1).matches("[^ ] ")) {
                ++caret;
                parent = false;
            } else if (!bracketOpen) {
                if (str.substring(caret - 1, caret + 1).matches(" [^ \\]]")) {
                    --caret;
                } else {
                    parent = false;
                }
            }
            for (int i = 2; i <= caret; ++i) {
                if (str.substring(i - 1, i).equals(" ")) {
                    ++childindex;
                    continue;
                }
                if (str.substring(i - 1, i).equals(openingBracket)) {
                    node = node.getChildren().get(childindex);
                    childindex = -1;
                    continue;
                }
                if (!str.substring(i - 1, i).equals(closingBracket)) continue;
                childindex = node.getParent().getChildren().indexOf(node);
                node = node.getParent();
            }
            if (!bracketOpen) {
                parent = childindex == -1;
            }
        }
        Pregnancy p = new Pregnancy(childindex, bracketOpen, parent);
        node.addTweak(p);
        this.node = node;
        this.p = p;
        this.caretCopy = caretCopy;
        this.bv.getBracketPane().displayMessage("Choose intended bracket by clicking or selecting with Arrow Keys + Enter. Press Escape to cancel.", 0);
        System.out.println("Pregnancy:" + p.getChildRank() + " " + node.getContent().getText(0, node.getContent().getLength()));
        this.bv.update();
        try {
            this.consume = true;
            for (int i = this.caretCopy; i < this.bv.getBracketDocument().getLength(); ++i) {
                Element elm = this.bv.getBracketDocument().getCharacterElement(i);
                if (!elm.getAttributes().containsAttribute("bracket-opt", "bracket-opt")) continue;
                this.bv.setCaret(i);
                break;
            }
            this.autoComplete(this.p, this.caretCopy, this.node);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    private boolean doPartialUpdate(DefaultStyledDocument doc, boolean affectDocument) throws BadLocationException {
        HierarchicalModel model = new HierarchicalModel();
        DefaultStyledDocument doc2 = doc.getLength() > 2 ? this.doPreParseProcessing(doc) : doc;
        System.out.println("BC - doPartialUpdate:" + doc2.getText(0, doc2.getLength()));
        if (this.parser.parse(model, doc2)) {
            if (this.bv.getBracketPane() != null) {
                this.bv.getBracketPane().removeMessage();
            }
            this.incorrectBracketString = false;
            CompoundEdit partialUpdateEdit = this.compareModels(this.bv.getModel(), model);
            if (partialUpdateEdit == null) {
                System.out.println("No updates found");
                return true;
            }
            this.bv.setUpdating(!affectDocument);
            this.controller.update(partialUpdateEdit);
            return true;
        }
        if (this.bv.getBracketPane() != null) {
            this.bv.getBracketPane().displayMessage(" " + this.parser.getErrorMessage(), 1);
        }
        JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Reverting operation because the resulting string is invalid. Perhaps a bracket is missing.", "Invalid String", 0);
        this.incorrectBracketString = true;
        return false;
    }

    private HierarchicalNode matchCaretPostionToNode(int position, BracketModel.BracketTree bracketTree) throws BadLocationException {
        HierarchicalNode node = bracketTree.getRoot();
        String str = bracketTree.getTreeDocument().getText(0, bracketTree.getTreeDocument().getLength());
        int childIdx = -1;
        String openingBracket = (String)this.bv.getSetting("bv-bracket-type-open");
        String closingBracket = (String)this.bv.getSetting("bv-bracket-type-close");
        for (int i = 2; i <= position; ++i) {
            if (str.substring(i - 1, i).equals(" ")) {
                ++childIdx;
                continue;
            }
            if (str.substring(i - 1, i).equals(openingBracket)) {
                node = node.getChildren().get(childIdx);
                childIdx = -1;
                continue;
            }
            if (!str.substring(i - 1, i).equals(closingBracket)) continue;
            childIdx = node.getParent().getChildren().indexOf(node);
            node = node.getParent();
        }
        return node;
    }

    protected int matchNodeToCaretPosition(HierarchicalNode node) throws BadLocationException {
        if (node == null) {
            return 1;
        }
        BracketModel.BracketTree bracketTree = this.bracketModel.getBracketTree(node);
        int startIndex = this.bracketModel.startIndex(bracketTree);
        String str = bracketTree.getTreeDocument().getText(0, bracketTree.getTreeDocument().getLength());
        int childIdx = -1;
        String openingBracket = (String)this.bv.getSetting("bv-bracket-type-open");
        String closingBracket = (String)this.bv.getSetting("bv-bracket-type-close");
        HierarchicalNode parent = node.getRoot();
        HierarchicalNode child = null;
        HierarchicalNode ret = parent;
        for (int i = 2; i <= bracketTree.getTreeDocument().getLength(); ++i) {
            if (str.substring(i - 1, i).equals(" ")) {
                if (node == child || node == parent) {
                    return startIndex + i - 1;
                }
                child = parent.getChildren().get(++childIdx);
                continue;
            }
            if (str.substring(i - 1, i).equals(openingBracket)) {
                parent = child;
                child = null;
                childIdx = -1;
                continue;
            }
            if (!str.substring(i - 1, i).equals(closingBracket)) continue;
            if (node == child) {
                return startIndex + i - 1;
            }
            child = parent;
            if ((parent = parent.getParent()) == null) break;
            childIdx = parent.getChildren().indexOf(child);
        }
        return 1;
    }

    private boolean matchLabel(DefaultStyledDocument document, int i) throws BadLocationException {
        while (Character.isLetterOrDigit(document.getText(i, 1).charAt(0)) || document.getText(i, 1).equals("\\") || document.getText(i, 1).equals("_")) {
            ++i;
        }
        return document.getText(i, 1).equals((String)this.bv.getSetting("bv-bracket-type-close"));
    }

    private void moveToPotentialBracket(boolean toTheLeft) {
        int caret = this.bv.getCaretPosition();
        if (toTheLeft) {
            for (int i = caret - 1; i > 0; --i) {
                if (!this.bv.getBracketDocument().getCharacterElement(i).getAttributes().containsAttribute("bracket-opt", "bracket-opt")) continue;
                this.bv.setCaret(i);
                break;
            }
        } else {
            for (int i = caret + 1; i < this.bv.getBracketDocument().getLength(); ++i) {
                if (!this.bv.getBracketDocument().getCharacterElement(i).getAttributes().containsAttribute("bracket-opt", "bracket-opt")) continue;
                this.bv.setCaret(i);
                break;
            }
        }
    }

    private void processBracketEvent(final KeyEvent ke, final boolean bracketOpen, final boolean bracketClose) throws BadLocationException {
        this.bv.setLengthyActionStage(1);
        this.controller.invokeLater(new Runnable(){

            @Override
            public void run() {
                BracketController.this.bv.setLengthyActionStage(2);
                BracketController.this.bv.update();
                try {
                    boolean afterTree = BracketController.this.bv.isCaretAfterTree();
                    boolean beforeTree = BracketController.this.bv.isCaretBeforeTree();
                    if (afterTree || beforeTree) {
                        BracketController.this.addOuterLayer(beforeTree, bracketOpen == afterTree ? "[ ]" : "");
                        BracketController.this.bv.setLengthyActionStage(0);
                        return;
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                int caret = BracketController.this.bv.getCaretPosition();
                BracketModel.BracketTree tree = null;
                try {
                    tree = BracketController.this.bracketModel.getBracketTree(caret);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                if (tree == null) {
                    BracketController.this.bv.setLengthyActionStage(1);
                    return;
                }
                System.out.println("BV.pBE: " + BracketController.this.bv.getBracketDocument() + ", " + tree.getTreeDocument());
                if (bracketOpen) {
                    BracketController.this.brackets = true;
                    try {
                        BracketController.this.determinePregnancy(caret, ke, bracketOpen);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                } else if (bracketClose) {
                    BracketController.this.brackets = true;
                    try {
                        BracketController.this.determinePregnancy(caret, ke, bracketOpen);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        ke.consume();
    }

    private void processCaretUpdate(int caret) throws BadLocationException {
        DefaultStyledDocument doc = this.copyDefaultStyledDocument(this.bv.getBracketDocument());
        Element elm = this.bv.getBracketDocument().getCharacterElement(caret);
        Element elm2 = this.bv.getBracketDocument().getCharacterElement(caret - 1);
        boolean bracket = doc.getText(caret, 1).equals((String)this.bv.getSetting("bv-bracket-type-open")) || doc.getText(caret, 1).equals((String)this.bv.getSetting("bv-bracket-type-close"));
        ArrayList<Object> attrNames = Collections.list(elm.getAttributes().getAttributeNames());
        for (Object name : attrNames) {
            if (!name.toString().equals("bracket-opt") || !bracket) continue;
            this.processChoice(caret, doc);
            return;
        }
        if (caret - 1 > 0) {
            bracket = doc.getText(caret - 1, 1).equals((String)this.bv.getSetting("bv-bracket-type-open")) || doc.getText(caret - 1, 1).equals((String)this.bv.getSetting("bv-bracket-type-close"));
            attrNames = Collections.list(elm2.getAttributes().getAttributeNames());
            for (Object name : attrNames) {
                if (!name.toString().equals("bracket-opt") || !bracket) continue;
                this.processChoice(caret - 1, doc);
                return;
            }
        }
    }

    private void processChoice(int caret, DefaultStyledDocument doc) throws BadLocationException {
        boolean bracketOpen = false;
        if (doc.getText(caret, 1).equals(this.bv.getSetting("bv-bracket-type-open"))) {
            doc.insertString(caret, (String)this.bv.getSetting("bv-bracket-type-open"), this.bv.getDefaultStyle());
            bracketOpen = true;
        } else {
            doc.insertString(caret, (String)this.bv.getSetting("bv-bracket-type-close"), this.bv.getDefaultStyle());
        }
        doc = this.removeOptionalBrackets(doc, bracketOpen);
        int openLocation = bracketOpen ? caret - this.bv.countOpeningOptions(caret) : this.findPregnantBracket(doc);
        this.bv.getModel().removePregnancies();
        if (this.doPartialUpdate(doc, true)) {
            this.putCaretInTree(this.bv.getDocument(), openLocation);
            this.brackets = false;
            this.consume = false;
            this.bv.setLengthyActionStage(0);
        }
        this.bv.getBracketPane().removeMessage();
    }

    private int findPregnantBracket(DefaultStyledDocument doc) throws BadLocationException {
        for (int i = 0; i < doc.getLength(); ++i) {
            String str = doc.getText(i, 1);
            if (!str.equals((String)this.bv.getSetting("bv-bracket-type-open")) && !str.equals((String)this.bv.getSetting("bv-bracket-type-close"))) continue;
            Element elm = doc.getCharacterElement(i);
            ArrayList attrNames = Collections.list(elm.getAttributes().getAttributeNames());
            for (Object name : attrNames) {
                if (!name.equals("bracket-preg")) continue;
                return i;
            }
        }
        return -1;
    }

    private void putCaretInTree(Document document, int startPosition) throws BadLocationException {
        if (document.getText(startPosition + 1, 1).equals(" ")) {
            this.bv.setCaretPosition(startPosition + 1);
            return;
        }
        int bracketSets = 0;
        for (int i = startPosition + 1; i < document.getLength() - 1; ++i) {
            String current = document.getText(i, 2);
            if (current.equals(" ]") || current.equals("  ")) {
                if (bracketSets != 0) continue;
                this.bv.setCaretPosition(i + 1);
                return;
            }
            if (current.startsWith("[")) {
                ++bracketSets;
                continue;
            }
            if (!current.startsWith("]")) continue;
            if (bracketSets == 0) {
                this.bv.setCaretPosition(i);
                return;
            }
            --bracketSets;
        }
    }

    private void processDeleteEvent(final int position, KeyEvent ke) throws BadLocationException {
        final boolean bracketOpen = this.bv.getBracketDocument().getText(position, 1).equals((String)this.bv.getSetting("bv-bracket-type-open"));
        if (bracketOpen || this.bv.getBracketDocument().getText(position, 1).equals((String)this.bv.getSetting("bv-bracket-type-close"))) {
            this.bv.setLengthyActionStage(1);
            ke.consume();
            this.controller.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BracketController.this.bv.setLengthyActionStage(2);
                    try {
                        BracketController.this.determineChildRemoval(position, bracketOpen);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private DefaultStyledDocument removeOptionalBrackets(DefaultStyledDocument document, boolean bracketOpen) throws BadLocationException {
        DefaultStyledDocument doc = (DefaultStyledDocument)this.bv.getEditorKit().createDefaultDocument();
        System.out.println("removing brackets");
        int spaceToBeRemoved = 0;
        int bracketCount = 0;
        for (int i = 0; i < document.getLength(); ++i) {
            Element elm = document.getCharacterElement(i);
            String str = document.getText(i, 1);
            ArrayList attrNames = Collections.list(elm.getAttributes().getAttributeNames());
            boolean skipChar = false;
            for (Object name : attrNames) {
                if (!name.equals("bracket-opt")) continue;
                System.out.println("found brackets to remove");
                skipChar = true;
                spaceToBeRemoved = document.getText(i + 1, 1).equals(" ") ? i : 0;
                ++bracketCount;
            }
            if (skipChar) {
                System.out.println("skippin");
                continue;
            }
            doc.insertString(doc.getLength(), str, elm.getAttributes());
        }
        if (bracketOpen && spaceToBeRemoved != 0) {
            System.out.println("Also removing character" + doc.getText(spaceToBeRemoved - bracketCount, 1));
            doc.remove(spaceToBeRemoved - bracketCount + 1, 1);
        }
        return doc;
    }

    private void selectNode(int caret) throws BadLocationException {
        BracketModel.BracketTree bt = this.bracketModel.getBracketTree(caret);
        if (bt == null || caret == this.bracketModel.startIndex(bt) || caret == this.bracketModel.startIndex(bt) + bt.getTreeDocument().getLength() || !this.controller.getModel().isUpToDate()) {
            this.controller.selectNone();
            return;
        }
        caret -= this.bracketModel.startIndex(bt);
        String str = bt.getTreeDocument().getText(0, bt.getTreeDocument().getLength());
        int childIdx = -1;
        String openingBracket = (String)this.bv.getSetting("bv-bracket-type-open");
        String closingBracket = (String)this.bv.getSetting("bv-bracket-type-close");
        HierarchicalNode node = bt.getRoot();
        System.out.println("Selecting node, caret: " + caret + " tree: " + str);
        for (int i = 2; i <= caret; ++i) {
            if (str.substring(i - 1, i).equals(" ")) {
                ++childIdx;
                continue;
            }
            if (str.substring(i - 1, i).equals(openingBracket)) {
                if (i - 2 >= 0 && str.substring(i - 2, i - 1).equals(openingBracket)) {
                    childIdx = 0;
                }
                node = node.getChildren().get(childIdx);
                childIdx = -1;
                continue;
            }
            if (!str.substring(i - 1, i).equals(closingBracket)) continue;
            childIdx = node.getSiblingIndex();
            node = node.getParent();
        }
        if (childIdx != -1 && node != null) {
            node = node.getChildren().get(childIdx);
        }
        this.controller.selectOnly(node);
    }

    public DefaultStyledDocument doPreParseProcessing(DefaultStyledDocument document) throws BadLocationException {
        DefaultStyledDocument doc = new DefaultStyledDocument();
        String bracketOpen = (String)this.bv.getSetting("bv-bracket-type-open");
        String bracketClose = (String)this.bv.getSetting("bv-bracket-type-close");
        for (int i = 0; i < document.getLength(); ++i) {
            if (document.getText(i, 1).equals(bracketOpen)) {
                doc.insertString(doc.getLength(), bracketOpen, this.bv.getDefaultStyle());
                if (document.getText(i + 1, 1).equals(bracketClose)) {
                    doc.insertString(doc.getLength(), "\u200b \u200b", this.bv.getDefaultStyle());
                } else if (document.getText(i + 1, 1).equals(" ")) {
                    doc.insertString(doc.getLength(), "\u200b", this.bv.getDefaultStyle());
                } else if (document.getText(i + 1, 1).equals(bracketOpen)) {
                    doc.insertString(doc.getLength(), "\u200b ", this.bv.getDefaultStyle());
                } else if (this.matchLabel(document, i + 1)) {
                    while (Character.isLetterOrDigit(document.getText(i + 1, 1).charAt(0)) || document.getText(i + 1, 1).equals("\\")) {
                        doc.insertString(doc.getLength(), document.getText(i + 1, 1), document.getCharacterElement(i + 1).getAttributes().copyAttributes());
                        ++i;
                    }
                    doc.insertString(doc.getLength(), " \u200b", this.bv.getDefaultStyle());
                }
            } else if (document.getText(i, 2).equals("  ") || document.getText(i, 2).equals(" " + bracketClose)) {
                doc.insertString(doc.getLength(), " \u200b", this.bv.getDefaultStyle());
            } else if (Character.isLetterOrDigit(document.getText(i, 1).charAt(0))) {
                doc.insertString(doc.getLength(), document.getText(i, 1), document.getCharacterElement(i).getAttributes().copyAttributes());
                if (document.getText(i + 1, 1).equals(bracketOpen)) {
                    doc.insertString(doc.getLength(), " ", this.bv.getDefaultStyle());
                }
            } else {
                doc.insertString(doc.getLength(), document.getText(i, 1), document.getCharacterElement(i).getAttributes().copyAttributes());
            }
            Element elm = doc.getCharacterElement(i);
            int fontSize = (Integer)this.bv.getSetting("font-size");
            if (elm.getAttributes().getAttribute(StyleConstants.FontSize) != null) {
                fontSize = (Integer)elm.getAttributes().getAttribute(StyleConstants.FontSize) - this.zoomLevel;
            }
            Style fontStyle = doc.addStyle("font-zoom", null);
            fontStyle.addAttribute(StyleConstants.FontSize, fontSize);
            doc.setCharacterAttributes(i, 1, fontStyle, false);
            ArrayList<Object> attributeNames = Collections.list(elm.getAttributes().getAttributeNames());
            SimpleAttributeSet mas = new SimpleAttributeSet();
            for (Object name : attributeNames) {
                if (!name.toString().equals("parent-subscript")) continue;
                for (Object n : attributeNames) {
                    if (n.toString().equals("parent-subscript") || n.toString().equals("subscript")) continue;
                    mas.addAttribute(n, elm.getAttributes().getAttribute(n));
                }
                doc.setCharacterAttributes(i, 1, mas, true);
            }
            elm = doc.getCharacterElement(i);
            attributeNames = Collections.list(elm.getAttributes().getAttributeNames());
            mas = new SimpleAttributeSet();
            for (Object name : attributeNames) {
                if (!name.toString().equals("hidden-background")) continue;
                for (Object n : attributeNames) {
                    if (n.toString().equals("hidden-background")) continue;
                    mas.addAttribute(n, elm.getAttributes().getAttribute(n));
                }
                mas.addAttribute(StyleConstants.Background, elm.getAttributes().getAttribute(name));
                doc.setCharacterAttributes(i, 1, mas, true);
            }
        }
        System.out.println("BC - preProcess:" + doc.getText(0, doc.getLength()));
        return doc;
    }

    public void processCaretEvent(final CaretEvent ce) {
        System.out.println("Trying to process caret event (BC)");
        if (this.setCaret) {
            System.out.println("Processing caret event failed, setCaret false");
            this.setCaret = false;
            return;
        }
        try {
            if (this.brackets) {
                System.out.println("Processing caret event failed, brackets active");
                this.processCaretUpdate(ce.getDot());
            } else {
                System.out.println("Processing caret event later" + ce.getDot());
                this.controller.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BracketController.this.selectNode(ce.getDot());
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void processDocumentEvent(DocumentEvent de) {
        try {
            System.out.println("Processing document event (" + this.bv.updatingDocument + ") " + de.getType() + "docEventDoc: " + de.getDocument().getText(0, de.getDocument().getLength()) + " doc:" + this.bv.getBracketDocument().getText(0, this.bv.getBracketDocument().getLength()));
            this.setCaret = true;
            this.doPartialUpdate(this.bv.getBracketDocument(), false);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void processKeyEvent(KeyEvent ke) {
        try {
            if (this.incorrectBracketString || ke.isControlDown()) {
                return;
            }
            if (!this.brackets) {
                String openingBracket = (String)this.bv.getSetting("bv-bracket-type-open");
                if (ke.getKeyCode() == 127) {
                    this.processDeleteEvent(this.bv.getCaretPosition(), ke);
                } else if (ke.getKeyCode() == 8) {
                    this.processDeleteEvent(this.bv.getCaretPosition() - 1, ke);
                } else if (ke.getKeyCode() == 10) {
                    if (this.bv.getBracketDocument().getText(this.bv.getCaretPosition(), 1).equals("\n")) {
                        this.addTree(this.bv.getCaretPosition());
                        ke.consume();
                    } else {
                        ke.consume();
                    }
                } else if (openingBracket.equals("[") && (ke.getKeyChar() == '[' || ke.getKeyChar() == ']')) {
                    this.processBracketEvent(ke, ke.getKeyChar() == '[', ke.getKeyChar() == ']');
                } else if (openingBracket.equals("{") && (ke.getKeyChar() == '{' || ke.getKeyChar() == '}')) {
                    this.processBracketEvent(ke, ke.getKeyChar() == '{', ke.getKeyChar() == '}');
                } else if (openingBracket.equals("(") && (ke.getKeyChar() == '(' || ke.getKeyChar() == ')')) {
                    this.processBracketEvent(ke, ke.getKeyChar() == '(', ke.getKeyChar() == ')');
                } else if (openingBracket.equals("<") && (ke.getKeyChar() == '<' || ke.getKeyChar() == '>')) {
                    this.processBracketEvent(ke, ke.getKeyChar() == '<', ke.getKeyChar() == '>');
                } else if (ke.getKeyCode() == 32) {
                    if (this.bv.isCaretAfterTree() || this.bv.isCaretBeforeTree()) {
                        this.addOuterLayer(this.bv.isCaretBeforeTree(), " ");
                        this.consume = true;
                    } else if (this.checkForEmptyNode(ke)) {
                        this.consume = true;
                        this.bv.setCaret(this.bv.getCaretPosition() + 1);
                    }
                } else if (ke.getKeyCode() == 9) {
                    ke.consume();
                    if (!this.bv.isCaretAfterTree() && !this.bv.isCaretBeforeTree()) {
                        this.bv.getBracketDocument().insertString(this.bv.getCaretPosition(), " ", this.bv.getDefaultStyle());
                    } else {
                        this.addOuterLayer(this.bv.isCaretBeforeTree(), " ");
                    }
                } else if (ke.getKeyChar() != '\uffff') {
                    if (this.bv.isCaretAfterTree() || this.bv.isCaretBeforeTree()) {
                        this.consume = true;
                        this.addOuterLayer(this.bv.isCaretBeforeTree(), "" + ke.getKeyChar());
                    } else if (this.bv.getDocument().getText(this.bv.getCaretPosition() - 1, 1).equals((String)this.bv.getSetting("bv-bracket-type-close"))) {
                        this.bv.getBracketDocument().insertString(this.bv.getCaretPosition(), " ", this.bv.getDefaultStyle());
                    }
                }
            } else {
                System.out.println(this.bv.lengthyActionStage);
                if (this.bv.lengthyActionStage != 0) {
                    ke.consume();
                    return;
                }
                if (ke.getKeyCode() == 27) {
                    this.bv.getModel().removePregnancies();
                    this.bv.getBracketPane().removeMessage();
                    DefaultStyledDocument document = (DefaultStyledDocument)this.bv.getDocument();
                    int pregnantPosition = this.findPregnantBracket(document);
                    int openingOptions = this.bv.countOpeningOptions(pregnantPosition);
                    int caretPosition = pregnantPosition - (openingOptions > 0 ? openingOptions + 1 : 0);
                    this.bv.setCaret(caretPosition);
                    this.brackets = false;
                    this.bv.update();
                } else if (ke.getKeyCode() == 37) {
                    this.moveToPotentialBracket(true);
                    ke.consume();
                } else if (ke.getKeyCode() == 39) {
                    this.moveToPotentialBracket(false);
                    ke.consume();
                } else if (ke.getKeyCode() == 10) {
                    ke.consume();
                    this.controller.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BracketController.this.processCaretUpdate(BracketController.this.bv.getCaretPosition());
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                } else {
                    ke.consume();
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setBracketModel(BracketModel bracketModel) {
        this.bracketModel = bracketModel;
    }
}

