/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.bracketstructure;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import nl.rug.syntree.Settings;
import nl.rug.syntree.bracketstructure.BracketController;
import nl.rug.syntree.bracketstructure.BracketView;
import nl.rug.syntree.bracketstructure.Pregnancy;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.annotations.Style;

public class BracketModel {
    private BracketView bv;
    private HierarchicalController controller;
    private BracketController bc;
    private DefaultStyledDocument doc;
    public ArrayList<BracketTree> bracketTrees = new ArrayList();

    public BracketModel(BracketView bview, HierarchicalController controller, BracketController bc) {
        this.bv = bview;
        this.controller = controller;
        this.bc = bc;
        this.doc = new DefaultStyledDocument();
    }

    private void addSubscript(DefaultStyledDocument source, DefaultStyledDocument dest) throws BadLocationException {
        int len = source.getLength();
        SimpleAttributeSet mas = new SimpleAttributeSet();
        Object subscript = this.bv.getSetting("bv-parent-sub");
        Object superscript = this.bv.getSetting("bv-parent-super");
        mas.addAttribute(StyleConstants.Subscript, subscript);
        mas.addAttribute(StyleConstants.Superscript, superscript);
        mas.addAttribute(StyleConstants.Bold, this.bv.getSetting("bv-parent-bold"));
        mas.addAttribute(StyleConstants.Italic, this.bv.getSetting("bv-parent-italic"));
        if (((Boolean)subscript).booleanValue() || ((Boolean)superscript).booleanValue()) {
            int size = (Integer)this.bv.getSetting("font-size");
            int smallSize = (int)(0.7f * (float)size);
            mas.addAttribute(StyleConstants.FontSize, smallSize);
        }
        dest.setCharacterAttributes(dest.getLength() - len, len, mas, false);
    }

    private void mergeDocument(DefaultStyledDocument source, DefaultStyledDocument dest) throws BadLocationException {
        for (int i = 0; i < source.getLength(); ++i) {
            Element elm = source.getCharacterElement(i);
            AttributeSet a = new SimpleAttributeSet();
            if (!((Boolean)this.bv.getSetting("bv-show-node-background-colour-enabled")).booleanValue()) {
                SimpleAttributeSet mas = new SimpleAttributeSet();
                ArrayList attrNames = Collections.list(elm.getAttributes().getAttributeNames());
                for (Object name : attrNames) {
                    if (name.toString().equals("background")) {
                        mas.addAttribute("hidden-background", elm.getAttributes().getAttribute(name));
                        continue;
                    }
                    mas.addAttribute(name, elm.getAttributes().getAttribute(name));
                }
                a = mas;
            } else {
                a = elm.getAttributes().copyAttributes();
            }
            if (source.getText(i, 1).equals("\n")) {
                dest.insertString(dest.getLength(), "\\", a);
                continue;
            }
            if (!source.getText(0, source.getLength()).equals(" ") && source.getText(i, 1).equals(" ")) {
                dest.insertString(dest.getLength(), Settings.BV_HARD_SPACE, a);
                continue;
            }
            dest.insertString(dest.getLength(), source.getText(i, 1), a);
        }
    }

    private void saveStyles(DefaultStyledDocument source, DefaultStyledDocument dest, int offset) {
        for (int i = 0; i < source.getLength(); ++i) {
            Element elm = source.getCharacterElement(i);
            AttributeSet as = elm.getAttributes().copyAttributes();
            SimpleAttributeSet mas = new SimpleAttributeSet();
            mas.addAttribute("bracket-backup-styles", as);
            dest.setCharacterAttributes(offset + i, 1, mas, false);
        }
    }

    private DefaultStyledDocument toBracket(HierarchicalNode node, DefaultStyledDocument doc) throws BadLocationException {
        boolean pregnant;
        Pregnancy pregnancy = (Pregnancy)node.getTweakByType(Pregnancy.class);
        boolean bl = pregnant = pregnancy != null;
        if (node.hasChildren()) {
            this.mergeDocument(this.bv.getBracketOpenDoc(), doc);
        }
        if (pregnant) {
            if (pregnancy.isBracketOpen() && pregnancy.getChildRank() == -1) {
                this.mergeDocument(this.bv.getBracketPregOpenDoc(), doc);
                if (!pregnancy.isParent()) {
                    this.mergeDocument(this.bv.getNodeSeparatorDoc(), doc);
                }
            } else if (!pregnancy.isBracketOpen()) {
                this.mergeDocument(this.bv.getBracketOptOpenDoc(), doc);
            }
        }
        this.mergeDocument(node.getContent(), doc);
        if (node.hasChildren()) {
            this.saveStyles(node.getContent(), doc, doc.getLength() - node.getContent().getLength());
            this.addSubscript(node.getContent(), doc);
        }
        if (pregnant) {
            if (pregnancy.isBracketOpen() && pregnancy.getChildRank() == -1) {
                this.mergeDocument(this.bv.getBracketOptCloseDoc(), doc);
            } else if (!pregnancy.isBracketOpen() && pregnancy.getChildRank() == -1) {
                this.mergeDocument(this.bv.getBracketPregCloseDoc(), doc);
            }
        }
        if (node.hasChildren()) {
            int childindex = 0;
            for (HierarchicalNode child : node.getChildren()) {
                Style s;
                this.mergeDocument(this.bv.getNodeSeparatorDoc(), doc);
                if (child.getParent() != null && (s = (Style)child.getParent().getBranchFor(child).getTweakByType(Style.class)) != null && s.colour != null) {
                    SimpleAttributeSet mas = new SimpleAttributeSet();
                    if (((Boolean)this.bv.getSetting("bv-show-branches-background-colour-enabled")).booleanValue()) {
                        mas.addAttribute(StyleConstants.Background, s.colour);
                    } else {
                        mas.addAttribute("hidden-background", s.colour);
                    }
                    doc.setCharacterAttributes(doc.getLength() - 1, 1, mas, false);
                }
                if (pregnant) {
                    if (pregnancy.isBracketOpen() && childindex == pregnancy.getChildRank()) {
                        this.mergeDocument(this.bv.getBracketPregOpenDoc(), doc);
                        if (!pregnancy.isParent()) {
                            this.mergeDocument(this.bv.getNodeSeparatorDoc(), doc);
                        }
                    } else if (!pregnancy.isBracketOpen() && childindex <= pregnancy.getChildRank()) {
                        this.mergeDocument(this.bv.getBracketOptOpenDoc(), doc);
                        if (!pregnancy.isParent() && childindex == pregnancy.getChildRank()) {
                            this.mergeDocument(this.bv.getNodeSeparatorDoc(), doc);
                        }
                    }
                }
                this.toBracket(child, doc);
                if (pregnant) {
                    if (!pregnancy.isBracketOpen() && childindex == pregnancy.getChildRank()) {
                        if (pregnancy.isParent()) {
                            this.mergeDocument(this.bv.getNodeSeparatorDoc(), doc);
                        }
                        this.mergeDocument(this.bv.getBracketPregCloseDoc(), doc);
                    } else if (pregnancy.isBracketOpen() && pregnancy.getChildRank() == -2 && node.getChildren().lastElement().equals(child)) {
                        this.mergeDocument(this.bv.getNodeSeparatorDoc(), doc);
                        this.mergeDocument(this.bv.getBracketPregOpenDoc(), doc);
                        this.mergeDocument(this.bv.getBracketOptCloseDoc(), doc);
                    } else if (pregnancy.isBracketOpen() && childindex >= pregnancy.getChildRank() && pregnancy.getChildRank() != -2) {
                        this.mergeDocument(this.bv.getBracketOptCloseDoc(), doc);
                    }
                }
                ++childindex;
            }
            this.mergeDocument(this.bv.getBracketCloseDoc(), doc);
        }
        return doc;
    }

    private void toBracketPostProcessing(DefaultStyledDocument doc) {
        try {
            String bracketOpen = (String)this.bv.getSetting("bv-bracket-type-open");
            for (int i = 0; i < doc.getLength(); ++i) {
                if (!doc.getText(i, 1).equals(bracketOpen + " " + bracketOpen)) continue;
                doc.remove(i, 1);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void getBracketDocument(DefaultStyledDocument doc) {
        try {
            doc.remove(0, doc.getLength());
            for (BracketTree tree : this.bracketTrees) {
                for (int i = 0; i < tree.getTreeDocument().getLength(); ++i) {
                    Element elm = tree.getTreeDocument().getCharacterElement(i);
                    doc.insertString(doc.getLength(), tree.getTreeDocument().getText(i, 1), elm.getAttributes().copyAttributes());
                }
            }
            for (int i = 0; i < doc.getLength(); ++i) {
                Element elm = doc.getCharacterElement(i);
                int fontSize = (Integer)this.bv.getSetting("font-size");
                if (elm.getAttributes().getAttribute(StyleConstants.FontSize) != null) {
                    fontSize = (Integer)elm.getAttributes().getAttribute(StyleConstants.FontSize) + this.bc.zoomLevel;
                }
                javax.swing.text.Style fontStyle = doc.addStyle("font-zoom", null);
                fontStyle.addAttribute(StyleConstants.FontSize, fontSize);
                doc.setCharacterAttributes(i, 1, fontStyle, false);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public BracketTree getBracketTree(int position) throws BadLocationException {
        for (BracketTree t : this.bracketTrees) {
            if (position <= t.getTreeDocument().getText(0, t.getTreeDocument().getLength()).replaceAll("\n", "").length()) {
                return t;
            }
            position -= t.getTreeDocument().getText(0, t.getTreeDocument().getLength()).replaceAll("\n", "").length();
        }
        return this.bracketTrees.size() - 1 > 0 ? this.bracketTrees.get(this.bracketTrees.size() - 1) : null;
    }

    public BracketTree getBracketTree(HierarchicalNode node) {
        HierarchicalNode root = node.getRoot();
        for (BracketTree tree : this.bracketTrees) {
            if (tree.root != root) continue;
            return tree;
        }
        return null;
    }

    public int startIndex(BracketTree tree) throws BadLocationException {
        int index = 0;
        for (BracketTree t : this.bracketTrees) {
            if (tree.equals(t)) break;
            index += t.getTreeDocument().getLength();
        }
        return index;
    }

    public void update() {
        try {
            this.bracketTrees.clear();
            int idx = 0;
            for (HierarchicalNode root : this.controller.getModel().getRootNodes()) {
                DefaultStyledDocument doc = this.toBracket(root, new DefaultStyledDocument());
                if (this.controller.getModel().getRootNodes().size() > 1 && idx < this.controller.getModel().getRootNodes().size() - 1) {
                    doc.insertString(doc.getLength(), "\n", (AttributeSet)this.bv.getSetting("DEFAULT_STYLE"));
                }
                this.toBracketPostProcessing(doc);
                this.bracketTrees.add(new BracketTree(root, doc));
                System.out.println("Bracketmodel update tree " + idx + ": " + doc);
                ++idx;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public class BracketTree {
        private HierarchicalNode root;
        private DefaultStyledDocument doc;

        public BracketTree(HierarchicalNode root, DefaultStyledDocument doc) {
            this.root = root;
            this.doc = doc;
        }

        public void clearDocument() {
            try {
                this.doc.remove(0, this.doc.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        public HierarchicalNode getRoot() {
            return this.root;
        }

        public DefaultStyledDocument getTreeDocument() {
            return this.doc;
        }
    }
}

