/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.bracketstructure;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import nl.rug.syntree.bracketstructure.BracketView;
import nl.rug.syntree.mainview.ViewPane;
import nl.rug.syntree.mainview.components.ActionSupport;
import nl.rug.syntree.mainview.components.BracketMenu;
import nl.rug.syntree.mainview.components.UIIcons;
import nl.rug.syntree.mainview.menus.ParentMenu;

public class BracketPane
extends ViewPane {
    private static final long serialVersionUID = 1L;
    private BracketView bv;
    private JLabel errorImage;
    private JLabel errorLabel;

    public BracketPane(BracketView bview) {
        super(new JScrollPane(bview, 22, 32), "[view: bracket structure]");
        this.bv = bview;
        this.bv.setBracketPane(this);
        this.setPreferredSize(new Dimension(this.getSize().width, 200));
        this.addMenu(new ParentMenu(this.bv));
        this.addMenu(new BracketMenu(this.bv));
        this.addButton(ActionSupport.makeButton(new HideViewAction()));
    }

    @Override
    public void zoomIn() {
        this.bv.zoomIn();
    }

    @Override
    public void zoomOut() {
        this.bv.zoomOut();
    }

    @Override
    public void zoomRestore() {
        this.bv.zoomReset();
    }

    private class ParentSubAction
    extends AbstractAction
    implements Observer {
        private BracketView bv;

        public ParentSubAction(BracketView bv) {
            this.bv = bv;
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/style_subscript.png"));
            this.putValue("ActionSupport-togglable", true);
            bv.getModel().addObserver(this);
            this.update(null, null);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            boolean sel = (Boolean)this.bv.getSetting("bv-bracket-parent-subscript");
            this.bv.setSetting("bv-bracket-parent-subscript", Boolean.valueOf(!sel));
        }

        @Override
        public void update(Observable obs, Object arg) {
            boolean sel = (Boolean)this.bv.getSetting("bv-bracket-parent-subscript");
            if (sel) {
                this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/style_subscript.png"));
            } else {
                this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/style_normalscript.png"));
            }
            this.putValue("SwingSelectedKey", sel);
        }
    }

    private class ShowViewAction
    extends AbstractAction {
        JSplitPane splitPane;

        public ShowViewAction(JSplitPane splitPane) {
            this.splitPane = splitPane;
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/arrow_up_double.png"));
            this.putValue("ActionSupport-togglable", true);
            this.putValue("ShortDescription", "Show the bracketview again");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.splitPane.remove(2);
            this.splitPane.add((Component)BracketPane.this, "bottom");
            this.splitPane.setEnabled(true);
            this.splitPane.setResizeWeight(0.75);
        }
    }

    private class HideViewAction
    extends AbstractAction {
        public HideViewAction() {
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon("icons/arrow_down_double.png"));
            this.putValue("ActionSupport-togglable", true);
            this.putValue("ShortDescription", "Temporarily hide the bracketview");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSplitPane splitPane = (JSplitPane)BracketPane.this.getParent();
            splitPane.remove(BracketPane.this);
            AbstractButton button = ActionSupport.makeButton(new ShowViewAction(splitPane));
            splitPane.add((Component)button, "bottom");
            splitPane.setResizeWeight(1.0);
            splitPane.setEnabled(false);
        }
    }
}

