/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.bracketstructure;

import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyleConstants;
import nl.rug.syntree.bracketstructure.BracketView;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.annotations.Style;
import nl.rug.syntree.hierarchicalmodel.nodecontent.DocumentContent;

public class BracketParser {
    private BracketView bv;
    private DefaultStyledDocument document;
    private String bracketString;
    private int index;
    private String errorMessage;
    private TokenObject tokenObj;
    private DocumentContent content;
    private Style style;
    private HierarchicalModel model;

    public BracketParser(BracketView bv) {
        this.bv = bv;
    }

    private boolean accept(Token t) {
        if (this.tokenObj.token.equals((Object)t)) {
            this.content = this.tokenObj.content;
            if (t.equals((Object)Token.NODE_SEPARATOR)) {
                this.style = this.tokenObj.style;
            }
            this.tokenObj = this.getToken();
            return true;
        }
        return false;
    }

    private TokenObject getToken() {
        if (this.index == this.bracketString.length()) {
            return new TokenObject(Token.EOS, null, null);
        }
        String c = "" + this.bracketString.charAt(this.index);
        String bracketO = (String)this.bv.getSetting("bv-bracket-type-open");
        String bracketC = (String)this.bv.getSetting("bv-bracket-type-close");
        if (c.equals(bracketO)) {
            ++this.index;
            return new TokenObject(Token.BRACKET_OPEN, null, null);
        }
        if (c.equals(bracketC)) {
            ++this.index;
            return new TokenObject(Token.BRACKET_CLOSE, null, null);
        }
        if (c.equals(" ")) {
            Color colour = (Color)this.document.getCharacterElement(this.index).getAttributes().getAttribute(StyleConstants.Background);
            if (colour != null && !colour.equals(Color.white)) {
                Style s = new Style();
                s.colour = colour;
                ++this.index;
                return new TokenObject(Token.NODE_SEPARATOR, null, s);
            }
            ++this.index;
            return new TokenObject(Token.NODE_SEPARATOR, null, null);
        }
        if (c.equals("\n")) {
            ++this.index;
            return new TokenObject(Token.TREE_SEPARATOR, null, null);
        }
        if (c.equals("\u200b")) {
            ++this.index;
            DocumentContent dc = new DocumentContent();
            dc.clearContents();
            return new TokenObject(Token.LABEL, dc, null);
        }
        int start = this.index;
        while (!(this.index >= this.bracketString.length() || (c = "" + this.bracketString.charAt(this.index)).equals(bracketO) || c.equals(bracketC) || c.equals(" ") || c.equals("\n") || c.equals("\u200b"))) {
            ++this.index;
        }
        DocumentContent dc = new DocumentContent();
        dc.clearContents();
        System.out.println("Will copy content");
        dc.copyContent(this.document, start, this.index, this.bv);
        return new TokenObject(Token.LABEL, dc, null);
    }

    private boolean parseChild(HierarchicalModel model, HierarchicalNode child) {
        if (!this.accept(Token.NODE_SEPARATOR)) {
            return false;
        }
        if (!this.parseChildTail(model, child)) {
            this.tokenObj.token = Token.NODE_SEPARATOR;
            return false;
        }
        return true;
    }

    private boolean parseChildren(HierarchicalModel model, HierarchicalNode root) {
        int count = 0;
        HierarchicalNode child = new HierarchicalNode(model, "");
        while (this.parseChild(model, child)) {
            ++count;
            root.appendChild(child);
            if (this.style != null) {
                root.getBranchFor(child).addTweak(this.style);
            }
            child = new HierarchicalNode(model, "");
        }
        if (count == 0) {
            this.errorMessage = "parse error: expected atleast one child";
            System.err.println(this.errorMessage);
        }
        return count > 0;
    }

    private boolean parseChildTail(HierarchicalModel model, HierarchicalNode child) {
        return this.parseLabel(model, child) || this.parseTree(model, child);
    }

    private boolean parseLabel(HierarchicalModel model, HierarchicalNode node) {
        if (this.accept(Token.LABEL)) {
            node.setContent(this.content);
            return true;
        }
        return false;
    }

    private boolean parseModel(HierarchicalModel model) {
        HierarchicalNode root = new HierarchicalNode(model, "");
        if (this.parseTree(model, root)) {
            model.addTree(root);
            if (this.accept(Token.EOS)) {
                return true;
            }
            int count = 0;
            while (this.accept(Token.TREE_SEPARATOR)) {
                root = new HierarchicalNode(model, "");
                if (!this.parseTree(model, root)) {
                    return false;
                }
                model.addTree(root);
                ++count;
            }
            if (count == 0) {
                this.errorMessage = "parse error: expected multiple trees";
                System.err.println(this.errorMessage);
            }
            return count > 0 && this.accept(Token.EOS);
        }
        this.errorMessage = "parse error: could not parse a tree";
        System.err.println(this.errorMessage);
        return false;
    }

    private boolean parseTree(HierarchicalModel model, HierarchicalNode root) {
        if (this.accept(Token.BRACKET_OPEN)) {
            return this.parseLabel(model, root) && this.parseChildren(model, root) && this.accept(Token.BRACKET_CLOSE);
        }
        return this.parseLabel(model, root);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean parse(HierarchicalModel model, DefaultStyledDocument document) {
        this.index = 0;
        this.model = model;
        this.document = document;
        try {
            this.bracketString = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.tokenObj = this.getToken();
        return this.parseModel(this.model);
    }

    private class TokenObject {
        public Token token;
        public DocumentContent content;
        public Style style;

        public TokenObject(Token token, DocumentContent content, Style style) {
            this.token = token;
            this.content = content;
            this.style = style;
        }
    }

    private static enum Token {
        BRACKET_OPEN,
        BRACKET_CLOSE,
        NODE_SEPARATOR,
        TREE_SEPARATOR,
        LABEL,
        EOS;

    }
}

