/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.bracketstructure;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import nl.rug.syntree.Settings;
import nl.rug.syntree.bracketstructure.BracketController;
import nl.rug.syntree.bracketstructure.BracketModel;
import nl.rug.syntree.bracketstructure.BracketPane;
import nl.rug.syntree.bracketstructure.texteditor.BracketEditorKit;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.mainview.Editor;
import nl.rug.syntree.mainview.MainFrame;
import nl.rug.syntree.mainview.View;
import nl.rug.syntree.mainview.components.RTFEditorPane;

public class BracketView
extends RTFEditorPane
implements Observer,
View,
Editor {
    private int id;
    private MainFrame mainFrame;
    private BracketPane bracketPane;
    private HierarchicalController controller;
    private BracketController bc;
    private BracketModel model;
    private BracketEditorKit editorKit;
    private DefaultStyledDocument document;
    private DefaultStyledDocument bracketOpenDoc;
    private DefaultStyledDocument bracketCloseDoc;
    private DefaultStyledDocument bracketOptOpenDoc;
    private DefaultStyledDocument bracketOptCloseDoc;
    private DefaultStyledDocument bracketPregOpenDoc;
    private DefaultStyledDocument bracketPregCloseDoc;
    private DefaultStyledDocument nodeSeparatorDoc;
    private Style defaultStyle;
    private Style subscriptStyle;
    private boolean updating = false;
    public static final int LENGTHY_ACTION_DONE = 0;
    public static final int LENGTHY_ACTION_INVOKED = 1;
    public static final int LENGTHY_ACTION_BUSY = 2;
    public int lengthyActionStage = 0;
    public boolean updatingDocument = false;
    public boolean trailingChange = false;
    public boolean focusListenerActive = true;

    public BracketView(int id, MainFrame mainFrame, HierarchicalController hController) {
        this.id = id;
        this.mainFrame = mainFrame;
        this.controller = hController;
        this.bc = new BracketController(this, this.controller);
        this.model = new BracketModel(this, this.controller, this.bc);
        this.bc.setBracketModel(this.model);
        this.controller.getModel().addObserver(this);
        this.editorKit = new BracketEditorKit();
        this.document = this.editorKit.createDefaultDocument();
        this.setEditorKit(this.editorKit);
        this.setDocument(this.document);
        System.out.println(this.getContentType());
        this.setupDocumentsAndStyles();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (!BracketView.this.focusListenerActive) {
                    return;
                }
                BracketView.this.controller.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BracketView.this.document.getLength() > 1) {
                            BracketView.this.controller.getModel().update();
                            HierarchicalNode firstSelected = BracketView.this.controller.getFirstSelectedNode();
                            try {
                                BracketView.this.setCaretPosition(BracketView.this.bc.matchNodeToCaretPosition(firstSelected));
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (BracketView.this.focusListenerActive) {
                    BracketView.this.getModel().removePregnancies();
                    BracketView.this.getBracketPane().removeMessage();
                    ((BracketView)BracketView.this).bc.brackets = false;
                    ((BracketView)BracketView.this).bc.consume = false;
                    BracketView.this.update();
                }
            }
        });
        this.document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(final DocumentEvent e) {
                if (Settings.BV_DISABLE_CHGUPD) {
                    return;
                }
                if (BracketView.this.updatingDocument) {
                    return;
                }
                if (BracketView.this.trailingChange) {
                    System.out.println("Killing changedUpdate on trailing change");
                    BracketView.this.trailingChange = false;
                    return;
                }
                BracketView.this.controller.getModel().setUpToDate(false);
                BracketView.this.controller.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BracketView.this.controller.getModel().isUpToDate()) {
                            return;
                        }
                        BracketView.this.controller.getModel().setUpToDate(true);
                        BracketView.this.bc.processDocumentEvent(e);
                    }
                });
            }

            @Override
            public void insertUpdate(final DocumentEvent e) {
                if (BracketView.this.updatingDocument) {
                    return;
                }
                BracketView.this.controller.getModel().setUpToDate(false);
                System.out.println("insertDoc" + e.getLength());
                BracketView.this.controller.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BracketView.this.controller.getModel().isUpToDate()) {
                            System.out.println("Model already up to date");
                            return;
                        }
                        BracketView.this.controller.getModel().setUpToDate(true);
                        BracketView.this.bc.processDocumentEvent(e);
                    }
                });
            }

            @Override
            public void removeUpdate(final DocumentEvent e) {
                if (BracketView.this.updatingDocument) {
                    return;
                }
                BracketView.this.controller.getModel().setUpToDate(false);
                BracketView.this.controller.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BracketView.this.controller.getModel().isUpToDate()) {
                            return;
                        }
                        BracketView.this.controller.getModel().setUpToDate(true);
                        BracketView.this.bc.processDocumentEvent(e);
                    }
                });
            }
        });
        this.addKeyListener(new KeyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                BracketView bracketView = BracketView.this;
                synchronized (bracketView) {
                    if (BracketView.this.updatingDocument) {
                        return;
                    }
                    System.out.println("keyPressed" + e.getKeyChar());
                    BracketView.this.bc.processKeyEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (BracketView.this.updatingDocument) {
                    return;
                }
                if (((BracketView)BracketView.this).bc.brackets || BracketView.this.lengthyActionStage != 0) {
                    e.consume();
                }
                if (((BracketView)BracketView.this).bc.consume) {
                    e.consume();
                    ((BracketView)BracketView.this).bc.consume = false;
                }
            }
        });
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (BracketView.this.updatingDocument) {
                    return;
                }
                BracketView.this.bc.processCaretEvent(e);
            }
        });
        this.setBorder(BorderFactory.createLineBorder(new Color(215, 215, 215)));
        this.update();
    }

    public int countOpeningOptions(int caret) {
        int count = 0;
        for (int i = caret - 1; i > 0; --i) {
            if (!this.document.getCharacterElement(i).getAttributes().containsAttribute("bracket-opt", "bracket-opt")) continue;
            ++count;
        }
        return count;
    }

    public void setLengthyActionStage(int stage) {
        if (this.lengthyActionStage == (stage + 2) % 3) {
            this.lengthyActionStage = stage;
        }
    }

    private void setupDocumentsAndStyles() {
        try {
            this.defaultStyle = this.document.addStyle("default", null);
            Settings.defaultStyle(this.defaultStyle, this.getModel());
            this.subscriptStyle = this.document.addStyle("parent-subscript", this.defaultStyle);
            this.subscriptStyle.addAttribute(StyleConstants.Subscript, true);
            this.subscriptStyle.addAttribute("parent-subscript", "parent-subscript");
            String bracketOpen = (String)this.getSetting("bv-bracket-type-open");
            String bracketClose = (String)this.getSetting("bv-bracket-type-close");
            this.bracketOpenDoc = this.editorKit.createDefaultDocument();
            this.bracketOpenDoc.insertString(0, bracketOpen, this.defaultStyle);
            this.bracketCloseDoc = this.editorKit.createDefaultDocument();
            this.bracketCloseDoc.insertString(0, bracketClose, this.defaultStyle);
            this.nodeSeparatorDoc = this.editorKit.createDefaultDocument();
            this.nodeSeparatorDoc.insertString(0, " ", this.defaultStyle);
            this.bracketOptOpenDoc = this.editorKit.createDefaultDocument();
            Style s = this.bracketOptOpenDoc.addStyle("bracket-opt-open", this.defaultStyle);
            s.addAttribute(StyleConstants.Background, this.getSetting("bv-bracket-opt-background-colour"));
            s.addAttribute("bracket-opt", "bracket-opt");
            this.bracketOptOpenDoc.insertString(0, bracketOpen, s);
            this.bracketOptCloseDoc = this.editorKit.createDefaultDocument();
            this.bracketOptCloseDoc.insertString(0, bracketClose, s);
            this.bracketPregOpenDoc = this.editorKit.createDefaultDocument();
            s = this.bracketPregOpenDoc.addStyle("bracket-preg-open", this.defaultStyle);
            s.addAttribute(StyleConstants.Background, this.getSetting("bv-bracket-preg-background-colour"));
            s.addAttribute("bracket-preg", "bracket-preg");
            this.bracketPregOpenDoc.insertString(0, bracketOpen, s);
            this.bracketPregCloseDoc = this.editorKit.createDefaultDocument();
            this.bracketPregCloseDoc.insertString(0, bracketClose, s);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void end() {
    }

    @Override
    public void focus() {
    }

    public DefaultStyledDocument getBracketCloseDoc() {
        return this.bracketCloseDoc;
    }

    public DefaultStyledDocument getBracketDocument() {
        return this.document;
    }

    public BracketModel getBracketModel() {
        return this.model;
    }

    public DefaultStyledDocument getBracketOpenDoc() {
        return this.bracketOpenDoc;
    }

    public DefaultStyledDocument getBracketOptCloseDoc() {
        return this.bracketOptCloseDoc;
    }

    public DefaultStyledDocument getBracketOptOpenDoc() {
        return this.bracketOptOpenDoc;
    }

    public BracketPane getBracketPane() {
        return this.bracketPane;
    }

    public DefaultStyledDocument getBracketPregCloseDoc() {
        return this.bracketPregCloseDoc;
    }

    public DefaultStyledDocument getBracketPregOpenDoc() {
        return this.bracketPregOpenDoc;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public HierarchicalController getController() {
        return this.controller;
    }

    public Style getDefaultStyle() {
        return this.defaultStyle;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public HierarchicalModel getModel() {
        return this.controller.getModel();
    }

    public DefaultStyledDocument getNodeSeparatorDoc() {
        return this.nodeSeparatorDoc;
    }

    public Object getSetting(String key) {
        return Settings.get(key, this.getModel(), this);
    }

    @Override
    public Class<BracketView> getType() {
        return BracketView.class;
    }

    public void setBracketPane(BracketPane pane) {
        this.bracketPane = pane;
    }

    public void setCaret(int caret) {
        this.bc.setCaret = true;
        this.setCaretPosition(caret);
    }

    public boolean isCaretBeforeTree() throws BadLocationException {
        int caretPosition = this.getCaretPosition();
        return caretPosition == 0 || this.document.getText(caretPosition - 1, 1).equals("\n");
    }

    public boolean isCaretAfterTree() throws BadLocationException {
        int caretPosition = this.getCaretPosition();
        return caretPosition == this.getDocument().getLength() || this.document.getText(caretPosition, 1).equals("\n");
    }

    @Override
    public String settingPrefix() {
        return "BV_";
    }

    public void setSetting(String key, Serializable value) {
        this.controller.setSetting(key, value, this);
    }

    public void setUpdating(boolean b) {
        this.updating = b;
    }

    public void changeBracket(Serializable value1, Serializable value2) {
        this.getModel().setSetting("bv-bracket-type-open", value1, this);
        this.getModel().setSetting("bv-bracket-type-close", value2, this);
        this.controller.update(null);
    }

    public void update() {
        this.update(null, null);
    }

    @Override
    public synchronized void update(Observable arg0, Object arg1) {
        if (!this.controller.getModel().isUpToDate()) {
            this.setUpdating(false);
            return;
        }
        System.out.println("BV (" + Thread.currentThread().getId() + ") update begin");
        this.updatingDocument = true;
        if (!this.bc.emptyModel) {
            this.setupDocumentsAndStyles();
            int caret = this.getCaretPosition();
            this.model.update();
            this.model.getBracketDocument(this.document);
            try {
                System.out.println(this.document.getText(0, this.document.getLength()));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.repaint();
            if (caret > this.document.getLength()) {
                caret = this.document.getLength() - 1;
            }
            this.setCaretPosition(caret);
            this.updatingDocument = false;
            System.out.println("Done in update");
            this.setLengthyActionStage(0);
            this.trailingChange = true;
        }
        System.out.println("BV (" + Thread.currentThread().getId() + ") update end");
    }

    public void zoomIn() {
        this.bc.zoomLevel += 4;
        this.update();
    }

    public void zoomOut() {
        if ((Integer)this.getSetting("font-size") + this.bc.zoomLevel > 0) {
            this.bc.zoomLevel -= 4;
            this.update();
        }
    }

    public void zoomReset() {
        this.bc.zoomLevel = 0;
        this.update();
    }

    public void setFocusListenerEnabled(boolean active) {
        this.focusListenerActive = active;
    }
}

