/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.bracketstructure;

import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.annotations.Style;
import nl.rug.syntree.hierarchicalmodel.annotations.Tweak;
import nl.rug.syntree.hierarchicalmodel.nodecontent.DocumentContent;
import nl.rug.syntree.hierarchicalmodel.undoableedits.LabelEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.TweakEdit;

public class PartialUpdate {
    private HierarchicalNode oldNode;
    private HierarchicalNode newNode;
    private boolean structureUpdate;
    private boolean branchUpdate;

    public PartialUpdate(HierarchicalNode oldNode, HierarchicalNode newNode, boolean structureUpdate, boolean branchUpdate) {
        this.oldNode = oldNode;
        this.newNode = newNode;
        this.structureUpdate = structureUpdate;
        this.branchUpdate = branchUpdate;
    }

    public UndoableEdit processUpdate() {
        if (this.branchUpdate) {
            Tweak oldTweak = this.oldNode.getParent().getBranchFor(this.oldNode).getTweakByType(Style.class);
            Style s = (Style)this.newNode.getParent().getBranchFor(this.newNode).getTweakByType(Style.class);
            this.oldNode.getParent().getBranchFor(this.oldNode).addTweak(s);
            return new TweakEdit(this.oldNode.getParent().getBranchFor(this.oldNode), oldTweak, Style.class);
        }
        CompoundEdit ce = new CompoundEdit();
        if (this.structureUpdate) {
            ce.addEdit(this.oldNode.getModel().removeChildren(this.oldNode));
            ce.addEdit(this.oldNode.getModel().copyChildren(this.oldNode, this.newNode));
        }
        DocumentContent oldContent = this.oldNode.getContent().createCopy();
        DocumentContent newContent = this.newNode.getContent();
        this.oldNode.getContent().copyContent(newContent, 0, newContent.getLength());
        ce.addEdit(new LabelEdit(this.oldNode.getContent(), oldContent));
        ce.end();
        return ce;
    }
}

