/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel;

import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;

public class HierarchicalBranch
extends HierarchicalObject {
    private static final long serialVersionUID = 8541494637449997700L;
    private HierarchicalNode childNode = null;
    private int style = 0;
    private boolean triangle = false;
    private static final int NUMBEROFSTYLES = 3;

    public HierarchicalBranch(HierarchicalModel model, HierarchicalNode childNode) {
        super(model);
        this.childNode = childNode;
    }

    @Override
    public void delete() {
        this.childNode.getParent().removeBranch(this);
        this.childNode.setParent(null);
    }

    public HierarchicalNode getChild() {
        return this.childNode;
    }

    public HierarchicalNode getParent() {
        if (this.childNode == null) {
            return null;
        }
        return this.childNode.getParent();
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isTriangle() {
        return this.triangle;
    }

    public void setChild(HierarchicalNode child) {
        this.childNode = child;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void switchShape() {
        this.triangle = !this.triangle;
    }

    public void switchStyle() {
        this.switchStyle(1);
    }

    public void switchStyle(int amount) {
        this.style = (this.style + amount) % 3;
    }

    @Override
    public boolean validate() {
        boolean ret;
        boolean bl = ret = this.childNode.validate() && super.validate();
        if (!ret) {
            System.out.println("Branch " + this + " invalidated");
        }
        return ret;
    }

    public HierarchicalBranch createCopy(HierarchicalModel model, HierarchicalNode child) {
        HierarchicalBranch copy = new HierarchicalBranch(model, child);
        copy.setStyle(this.style);
        if (this.triangle) {
            copy.switchShape();
        }
        return copy;
    }
}

