/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel;

import java.util.ArrayList;
import java.util.List;
import nl.rug.syntree.hierarchicalmodel.HierarchicalBranch;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Annotation;
import org.apache.batik.dom.util.HashTable;

public class HierarchicalClipboard {
    private List<HierarchicalNode> clipboardTrees;
    private List<Annotation> clipboardAnnotations;
    private HashTable cloneTable = new HashTable();

    public HierarchicalClipboard() {
        this.clipboardTrees = new ArrayList<HierarchicalNode>();
        this.clipboardAnnotations = new ArrayList<Annotation>();
    }

    public List<HierarchicalNode> getTrees() {
        return this.clipboardTrees;
    }

    public List<Annotation> getAnnotations() {
        return this.clipboardAnnotations;
    }

    public void clear() {
        this.clipboardTrees.clear();
        this.clipboardAnnotations.clear();
        this.cloneTable.clear();
    }

    public void addTree(HierarchicalNode node) {
        this.clipboardTrees.add(node);
    }

    public void addAnnotation(Annotation object) {
        this.clipboardAnnotations.add(object);
    }

    public void cloneObjects(HierarchicalModel model) {
        for (HierarchicalNode hierarchicalNode : this.clipboardTrees) {
            HierarchicalNode cloneNode = hierarchicalNode.parentlessDeepClone(model);
            this.cloneTable.put(hierarchicalNode, cloneNode);
            this.registerClonedOffspring(hierarchicalNode, cloneNode);
        }
        for (HierarchicalObject hierarchicalObject : this.clipboardAnnotations) {
            Annotation cloneAnnotation = ((Annotation)hierarchicalObject).createCopy();
            this.cloneTable.put(hierarchicalObject, cloneAnnotation);
        }
    }

    private void registerClonedOffspring(HierarchicalNode node, HierarchicalNode cloneNode) {
        if (node.getBranches().size() == 0) {
            return;
        }
        for (int i = 0; i < node.getBranches().size(); ++i) {
            HierarchicalBranch branch = node.getBranches().get(i);
            HierarchicalBranch cloneBranch = cloneNode.getBranches().get(i);
            this.cloneTable.put(branch, cloneBranch);
            this.cloneTable.put(branch.getChild(), cloneBranch.getChild());
            this.registerClonedOffspring(branch.getChild(), cloneBranch.getChild());
        }
    }

    public HashTable getCloneTable() {
        return this.cloneTable;
    }
}

