/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel;

import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import nl.rug.syntree.Main;
import nl.rug.syntree.hierarchicalmodel.HierarchicalBranch;
import nl.rug.syntree.hierarchicalmodel.HierarchicalClipboard;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.SelectionManager;
import nl.rug.syntree.hierarchicalmodel.actions.AboutAction;
import nl.rug.syntree.hierarchicalmodel.actions.AddChildAction;
import nl.rug.syntree.hierarchicalmodel.actions.AddChildTriangleAction;
import nl.rug.syntree.hierarchicalmodel.actions.AddParentAction;
import nl.rug.syntree.hierarchicalmodel.actions.AddParentLeftChildAction;
import nl.rug.syntree.hierarchicalmodel.actions.AddParentRightChildAction;
import nl.rug.syntree.hierarchicalmodel.actions.AddTreeAction;
import nl.rug.syntree.hierarchicalmodel.actions.AddTwoChildrenAction;
import nl.rug.syntree.hierarchicalmodel.actions.BranchShapeAction;
import nl.rug.syntree.hierarchicalmodel.actions.BranchStyleAction;
import nl.rug.syntree.hierarchicalmodel.actions.ClearModelAction;
import nl.rug.syntree.hierarchicalmodel.actions.CopyAction;
import nl.rug.syntree.hierarchicalmodel.actions.CutAction;
import nl.rug.syntree.hierarchicalmodel.actions.CutBranchAction;
import nl.rug.syntree.hierarchicalmodel.actions.ExpandCollapseAction;
import nl.rug.syntree.hierarchicalmodel.actions.ExportModelAction;
import nl.rug.syntree.hierarchicalmodel.actions.NewModelAction;
import nl.rug.syntree.hierarchicalmodel.actions.OpenModelAction;
import nl.rug.syntree.hierarchicalmodel.actions.PasteAction;
import nl.rug.syntree.hierarchicalmodel.actions.PasteUnderAction;
import nl.rug.syntree.hierarchicalmodel.actions.PendleAction;
import nl.rug.syntree.hierarchicalmodel.actions.PreferencesAction;
import nl.rug.syntree.hierarchicalmodel.actions.RedoAction;
import nl.rug.syntree.hierarchicalmodel.actions.RemoveObjectsAction;
import nl.rug.syntree.hierarchicalmodel.actions.SaveAsAction;
import nl.rug.syntree.hierarchicalmodel.actions.SaveModelAction;
import nl.rug.syntree.hierarchicalmodel.actions.TwistChildrenAction;
import nl.rug.syntree.hierarchicalmodel.actions.UndoAction;
import nl.rug.syntree.hierarchicalmodel.annotations.Annotation;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.hierarchicalmodel.exporters.SerialExporter;
import nl.rug.syntree.hierarchicalmodel.undoableedits.AddAnnotationEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.AddChildEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.AddParentEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.AddTreeEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.ExpandCollapseEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.ModifyBranchEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.PntEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.RemoveChildEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.RemoveTreeEdit;
import nl.rug.syntree.mainview.Aboat;
import nl.rug.syntree.mainview.Editor;
import nl.rug.syntree.mainview.MainFrame;
import nl.rug.syntree.mainview.PreferencesWindow;
import nl.rug.syntree.mainview.UIUtilities;
import nl.rug.syntree.mainview.View;
import nl.rug.syntree.mainview.components.NavigatableDialog;
import nl.rug.syntree.mainview.components.UIExportDialog;
import nl.rug.syntree.treediagram.TreeView;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.util.HashTable;
import org.apache.commons.io.FilenameUtils;

public class HierarchicalController {
    private HierarchicalModel model = null;
    private MainFrame mf = null;
    private SelectionManager selectionMgr = null;
    private UndoManager undoMgr = null;
    private CountingCompoundEdit cpEdit = null;
    public static final boolean LEFT = true;
    public static final boolean RIGHT = false;
    private Vector<Action> modelActions;
    private Vector<Action> fileActions;
    private Vector<Action> editActions;
    private Vector<Action> styleActions;
    private Vector<Action> allActions;
    private UpdateManager updateManager;
    private boolean centered;
    private File activeDirectory = new File(new String());

    public HierarchicalController(HierarchicalModel model, HierarchicalClipboard clipboard) {
        this.selectionMgr = new SelectionManager(this, clipboard);
        this.undoMgr = new UndoManager();
        this.model = model;
        this.initActions();
    }

    private void editHappened(UndoableEdit edit) {
        if (edit == null) {
            return;
        }
        if (this.cpEdit != null) {
            System.out.println(this.cpEdit.addEdit(edit));
            System.out.println("HC.eH: add to compound: " + edit + " (" + this.cpEdit + ")");
        } else {
            if (edit instanceof CountingCompoundEdit && ((CountingCompoundEdit)edit).size() == 0) {
                return;
            }
            this.undoMgr.undoableEditHappened(new UndoableEditEvent(this, edit));
            this.model.setDirty(true);
            System.out.println("HC.eH: add normal: " + edit);
        }
    }

    private void initActions() {
        this.modelActions = new Vector();
        this.modelActions.add(new AddTreeAction(this));
        this.modelActions.add(new AddChildAction(this));
        this.modelActions.add(new AddChildTriangleAction(this));
        this.modelActions.add(new AddTwoChildrenAction(this));
        this.modelActions.add(new AddParentAction(this));
        this.modelActions.add(new AddParentLeftChildAction(this));
        this.modelActions.add(new AddParentRightChildAction(this));
        this.modelActions.add(new TwistChildrenAction(this));
        this.modelActions.add(new CutBranchAction(this));
        this.styleActions = new Vector();
        this.styleActions.add(new ExpandCollapseAction(this));
        this.fileActions = new Vector();
        this.fileActions.add(new NewModelAction(this));
        this.fileActions.add(new ClearModelAction(this));
        this.fileActions.add(new OpenModelAction(this));
        this.fileActions.add(new SaveModelAction(this));
        this.fileActions.add(new SaveAsAction(this));
        this.fileActions.add(new ExportModelAction(this));
        this.fileActions.add(new PreferencesAction(this));
        this.fileActions.add(new AboutAction(this));
        this.editActions = new Vector();
        this.editActions.add(new CopyAction(this));
        this.editActions.add(new CutAction(this));
        this.editActions.add(new PasteAction(this));
        this.editActions.add(new PasteUnderAction(this));
        this.editActions.add(new UndoAction(this));
        this.editActions.add(new RedoAction(this));
        this.allActions = new Vector();
        this.allActions.addAll(this.modelActions);
        this.allActions.addAll(this.fileActions);
        this.allActions.addAll(this.editActions);
        this.allActions.addAll(this.styleActions);
        this.allActions.add(new BranchShapeAction(this));
        this.allActions.add(new BranchStyleAction(this));
        this.allActions.add(new PendleAction(this));
        this.allActions.add(new RemoveObjectsAction(this));
    }

    @Deprecated
    private boolean moveSubTree(HierarchicalNode subject, HierarchicalNode dest, int idx) {
        if (!dest.checkCyclicity(subject)) {
            return false;
        }
        CompoundEdit moveSubTreeEdit = new CompoundEdit();
        if (subject.isRoot()) {
            moveSubTreeEdit.addEdit(new RemoveTreeEdit(this.model, subject));
            this.model.getRootNodes().remove(subject);
        } else {
            moveSubTreeEdit.addEdit(new RemoveChildEdit(this.model, subject, subject.getParent(), subject.getSiblingIndex()));
            subject.getParent().removeChild(subject);
            subject.orphanize();
        }
        moveSubTreeEdit.addEdit(new AddChildEdit(this.model, dest, subject, idx));
        dest.addChild(subject, idx);
        moveSubTreeEdit.end();
        this.update(moveSubTreeEdit);
        return true;
    }

    private File selectFile(boolean save) {
        JFileChooser fc = new JFileChooser(this.activeDirectory);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Syntree save", "syn");
        fc.setFileFilter(filter);
        fc.setSelectedFile(this.model.file());
        if ((save ? fc.showSaveDialog(null) : fc.showOpenDialog(null)) != 0) {
            return null;
        }
        File f = fc.getSelectedFile();
        this.activeDirectory = fc.getCurrentDirectory();
        if (save && !f.getAbsolutePath().endsWith(".syn")) {
            f = new File(f.getAbsolutePath() + ".syn");
        }
        if (save && f.exists()) {
            JOptionPane confirmationPane = new JOptionPane("File '" + f.getName() + "' exists, save anyway?", 3, 0);
            NavigatableDialog dialog = new NavigatableDialog(confirmationPane, "Overwrite file?");
            int choice = (Integer)dialog.getResult();
            if (choice == 0) {
                return f;
            }
            if (choice == 1) {
                return this.selectFile(save);
            }
            return null;
        }
        if (!save && !f.exists()) {
            JOptionPane confirmationPane = new JOptionPane("File does not exist, choose another one", 0, 2);
            NavigatableDialog dialog = new NavigatableDialog(confirmationPane, "Non-existent file");
            int choice = (Integer)dialog.getResult();
            if (choice == 0) {
                return this.selectFile(save);
            }
            return null;
        }
        return f;
    }

    public void about() {
        new Aboat();
    }

    public void addAnnotation(HierarchicalObject an) {
        this.model.addAnnotation(an);
        this.update(new AddAnnotationEdit(this.model, an));
        this.selectionMgr.selectOnly(an);
    }

    public void addChild(boolean triangle) {
        HierarchicalNode child = null;
        this.startCompoundEdit();
        for (HierarchicalNode parent : this.selectionMgr.getNodes()) {
            AddChildEdit edit = this.model.addChild(parent);
            this.editHappened(edit);
            child = edit.child1();
            if (!triangle) continue;
            HierarchicalBranch branch = child.getParent().getBranchFor(child);
            branch.switchShape();
            this.editHappened(new ModifyBranchEdit(branch, 1));
        }
        if (child != null) {
            this.selectionMgr.selectOnly(child);
        }
        this.update(null);
    }

    public void addParent() {
        HierarchicalNode parent = null;
        for (HierarchicalNode child : this.selectionMgr.getNodes()) {
            AddParentEdit edit = this.model.addParent(child);
            this.editHappened(edit);
            parent = edit.parent();
        }
        if (parent != null) {
            this.selectionMgr.selectOnly(parent);
        }
        this.update(null);
    }

    public void addSibling(boolean left) {
        HierarchicalNode node = null;
        for (HierarchicalNode child : this.selectionMgr.getNodes()) {
            AbstractUndoableEdit edit = null;
            edit = child.hasParent() ? this.model.addSibling(child, left) : this.model.addParentAndSibling(child, left);
            this.editHappened(edit);
            node = child.getParent().getChildren().get(child.getSiblingIndex() + (left ? -1 : 1));
        }
        if (node != null) {
            this.selectionMgr.selectOnly(node);
        }
        this.update(null);
    }

    public void addTree() {
        AddTreeEdit edit = this.model.addTree();
        this.update(edit);
        this.selectionMgr.selectOnly(edit.tree());
    }

    public void addTree(HierarchicalNode tree) {
        AddTreeEdit edit = this.model.addTree(tree);
        this.update(edit);
        this.selectionMgr.selectOnly(edit.tree());
    }

    public AddChildEdit addTwoChildren(HierarchicalNode parent) {
        AddChildEdit edit = this.model.addTwoChildren(parent);
        this.editHappened(edit);
        return edit;
    }

    public void addTwoChildren() {
        HierarchicalNode child = null;
        for (HierarchicalNode parent : this.selectionMgr.getNodes()) {
            AddChildEdit edit = this.addTwoChildren(parent);
            child = edit.child1();
        }
        if (child != null) {
            this.selectionMgr.selectOnly(child);
        }
        this.update(null);
    }

    public void bugOut() {
        Exception ex = new Exception("Request to file a bug report");
        ex.printStackTrace();
        UIUtilities.handleException(ex, null, this.model);
    }

    public boolean canRedo() {
        return this.undoMgr.canRedo();
    }

    public boolean canUndo() {
        return this.undoMgr.canUndo();
    }

    public void clearClipboard() {
        this.selectionMgr.clearClipboard();
        this.selectionMgr.update();
    }

    public void clearModel() {
        JOptionPane confirmationPane = new JOptionPane("Would you like to save your model prior to clearing?", 3, 1);
        NavigatableDialog dialog = new NavigatableDialog(confirmationPane, "Save model?");
        int result = (Integer)dialog.getResult();
        if (result == 2) {
            return;
        }
        if (result == 0) {
            this.fileSave(false);
        }
        this.model.file(null);
        this.model.setCentered(true);
        this.selectionMgr.selectNone();
        this.update(this.model.clearModel());
        this.model.setCentered(false);
    }

    public void copySubtree() {
        this.selectionMgr.setClipboard();
    }

    public void clearNode(HierarchicalNode node) {
        if (node.hasParent()) {
            HierarchicalNode clearNode = new HierarchicalNode(this.model);
            this.pasteOnto(clearNode, node);
            this.update(null);
        } else if (this.model.getRootNodes().size() > 1) {
            int idx = this.model.getRootNodes().indexOf(node);
            this.removeNode(node);
            this.update(null);
            this.selectionMgr.selectOnly(this.model.getRootNodes().get(idx % this.model.getRootNodes().size()));
        } else {
            this.clearModel();
        }
    }

    public void cutBranch() {
        HierarchicalBranch branch = this.getFirstSelectedBranch();
        HierarchicalNode node = this.getFirstSelectedNode();
        if (branch == null && node != null) {
            branch = node.getParent().getBranchFor(node);
            this.startCompoundEdit();
            this.editHappened(this.model.addChild(node.getParent(), new HierarchicalNode(this.model), node.getSiblingIndex()));
        }
        this.removeBranch(branch);
    }

    public void cutObjects() {
        this.selectionMgr.setClipboard();
        this.startCompoundEdit();
        for (HierarchicalNode node : this.selectionMgr.getClipboard().getTrees()) {
            if (node.isRoot() && this.model.getRootNodes().size() == 1) {
                this.clearModel();
                continue;
            }
            if (node.isRoot() || this.selectionMgr.getBranches().contains(node.getParent().getBranchFor(node))) {
                this.removeNode(node);
                continue;
            }
            this.editHappened(this.model.replaceNode(node, new HierarchicalNode(this.model)));
        }
        for (Annotation annotation : this.selectionMgr.getClipboard().getAnnotations()) {
            this.editHappened(this.model.removeAnnotation(annotation));
        }
        this.update(null);
    }

    public void deselect(HierarchicalObject obj) {
        this.selectionMgr.deselect(obj);
    }

    public CompoundEdit endCompoundEdit() {
        if (this.cpEdit == null) {
            return null;
        }
        this.cpEdit.end();
        System.out.println("HC end compound");
        CountingCompoundEdit ret = this.cpEdit.size() > 0 ? this.cpEdit : null;
        this.cpEdit = null;
        return ret;
    }

    public void expandCollapseNodes() {
        this.startCompoundEdit();
        for (HierarchicalNode node : this.getSelectedNodes()) {
            ExpandCollapseEdit edit = this.model.expandCollapseNode(node);
            this.editHappened(edit);
        }
        this.update(null);
    }

    public void fileExport() {
        final TreeView tv = this.mf.getTV();
        if (tv == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HierarchicalController.this.selectNone();
                UIExportDialog exp = new UIExportDialog();
                if (exp.getFilePathMemory().equals("")) {
                    exp.setFilePathMemory(HierarchicalController.this.activeDirectory.getPath());
                }
                if (HierarchicalController.this.model.file() != null) {
                    exp.suggestFileName(FilenameUtils.getBaseName(HierarchicalController.this.model.file().getName()));
                }
                Rectangle2D.Float rect = new Rectangle2D.Float(tv.getCachedX(), tv.getCachedY(), tv.getCachedWidth(), tv.getCachedHeight());
                exp.showExportDialog(HierarchicalController.this.mf, "Syntree Export", tv, rect, "Untitled");
                String path = exp.getFilePathMemory();
                if (!path.equals("")) {
                    HierarchicalController.this.activeDirectory = new File(path);
                }
            }
        });
    }

    public void fileNew() {
        Main.addWindow(this.selectionMgr.getClipboard());
    }

    public void fileOpen() {
        File f = this.selectFile(false);
        if (f == null) {
            return;
        }
        HierarchicalModel newModel = SerialExporter.fileToModel(f);
        newModel.file(f);
        this.replaceModel(newModel);
    }

    public void filePrint() {
    }

    public void fileSave(boolean as) {
        File f = this.model.file();
        if (as || f == null) {
            f = this.selectFile(true);
        }
        if (f == null) {
            return;
        }
        this.model.file(f);
        this.model.setDirty(false);
        SerialExporter.modelToFile(this.model, f);
        this.update(null);
    }

    public Action getAction(Class<? extends Action> cls) {
        for (Action act : this.allActions) {
            if (!cls.isAssignableFrom(act.getClass())) continue;
            return act;
        }
        return null;
    }

    public List<HierarchicalObject> getClipboard() {
        Vector<HierarchicalObject> clipboardObjects = new Vector<HierarchicalObject>();
        clipboardObjects.addAll(this.selectionMgr.getClipboard().getTrees());
        clipboardObjects.addAll(this.selectionMgr.getClipboard().getAnnotations());
        return clipboardObjects;
    }

    public Vector<Action> getEditActions() {
        return this.editActions;
    }

    public Vector<Action> getFileActions() {
        return this.fileActions;
    }

    public HierarchicalBranch getFirstSelectedBranch() {
        return this.selectionMgr.getFirstBranch();
    }

    public HierarchicalNode getFirstSelectedNode() {
        return this.selectionMgr.getFirstNode();
    }

    public HierarchicalObject getFirstSelectedObject() {
        return this.selectionMgr.getFirstObject();
    }

    public MainFrame getMainFrame() {
        return this.mf;
    }

    public HierarchicalModel getModel() {
        return this.model;
    }

    public Vector<Action> getModelActions() {
        return this.modelActions;
    }

    public List<HierarchicalBranch> getSelectedBranches() {
        return this.selectionMgr.getBranches();
    }

    public List<HierarchicalNode> getSelectedNodes() {
        return this.selectionMgr.getNodes();
    }

    public List<HierarchicalObject> getSelection() {
        return this.selectionMgr.getObjects();
    }

    public SelectionManager getSelectionManager() {
        return this.selectionMgr;
    }

    public void invokeLater(Runnable runnable) {
        if (this.updateManager != null) {
            this.updateManager.getUpdateRunnableQueue().invokeLater(runnable);
        }
    }

    public boolean isSelected(HierarchicalObject obj) {
        return this.selectionMgr.contains(obj);
    }

    public void moveChild(HierarchicalNode child, int newIdx) {
        this.update(this.model.moveChild(child, newIdx));
    }

    public void moveChildrenUp(HierarchicalNode node) {
        this.startCompoundEdit();
        HierarchicalNode parent = node.getParent();
        int index = node.getSiblingIndex();
        for (HierarchicalNode child : node.getChildren()) {
            this.editHappened(this.model.removeChild(child));
            if (parent != null) {
                this.editHappened(this.model.addChild(parent, child, index));
            } else {
                this.editHappened(this.model.addTree(child, index));
                if (!child.hasChildren()) {
                    this.editHappened(this.model.addChild(child, new HierarchicalNode(this.model), 0));
                }
            }
            ++index;
        }
        this.removeNode(node);
        this.update(null);
    }

    @Deprecated
    public boolean moveSubTree(HierarchicalNode subject, HierarchicalNode dest) {
        return this.moveSubTree(subject, dest, -1);
    }

    public void pasteOnto() {
        HierarchicalNode target;
        this.selectionMgr.getClipboard().cloneObjects(this.model);
        List<HierarchicalNode> nodes = this.selectionMgr.getClipboard().getTrees();
        List<Annotation> annotations = this.selectionMgr.getClipboard().getAnnotations();
        HashTable cloneTable = this.selectionMgr.getClipboard().getCloneTable();
        if (nodes.isEmpty() && annotations.isEmpty()) {
            return;
        }
        this.startCompoundEdit();
        HierarchicalObject annotationTarget = target = this.selectionMgr.getFirstNode();
        int result = 0;
        if (!nodes.isEmpty()) {
            annotationTarget = (HierarchicalObject)cloneTable.get(nodes.get(0));
            System.out.println("Annotationtarget" + annotationTarget);
            if (target != null && target.hasChildren()) {
                JOptionPane confirmationPane = new JOptionPane("If you paste onto this node, the current node and everything below will be replaced, are you sure you want to continue?", 2, 2);
                NavigatableDialog dialog = new NavigatableDialog(confirmationPane, "Replace node?");
                result = (Integer)dialog.getResult();
            }
        }
        if (result == 0) {
            HierarchicalNode parent = null;
            for (HierarchicalNode node : nodes) {
                if (parent == null || target == null) {
                    if (target != null) {
                        parent = target.getParent();
                    }
                    this.pasteOnto((HierarchicalNode)cloneTable.get(node), target);
                    if (parent != null) continue;
                    target = null;
                    continue;
                }
                this.editHappened(this.model.addChild(parent, (HierarchicalNode)cloneTable.get(node)));
            }
        }
        this.pasteAnnotations(annotationTarget);
        this.update(null);
    }

    private void pasteOnto(Annotation annotation, HierarchicalObject annotationTarget) {
        Position oldPosition = (Position)annotation.getTweakByType(Position.class);
        HashTable cloneTable = this.selectionMgr.getClipboard().getCloneTable();
        Annotation annotationClone = (Annotation)cloneTable.get(annotation);
        Position clonePosition = (Position)annotationClone.getTweakByType(Position.class);
        if (oldPosition != null) {
            System.out.println("Begin annotation pasting procedure");
            Iterator<Position.Pnt> pointIterator = oldPosition.iterator();
            Iterator<Position.Pnt> clonePointIterator = clonePosition.iterator();
            int outsidePointCounter = 0;
            while (pointIterator.hasNext()) {
                ++outsidePointCounter;
                Position.Pnt point = pointIterator.next();
                System.out.println(point);
                Position.Pnt clonePoint = clonePointIterator.next();
                System.out.println(clonePoint);
                HierarchicalObject targetClone = (HierarchicalObject)cloneTable.get(point.target());
                System.out.println(targetClone);
                if (targetClone != null) {
                    outsidePointCounter = -1;
                    System.out.println("Clone exists on clipboard");
                    this.changePntTarget(clonePoint, targetClone);
                    System.out.println("Point changed to clone");
                    continue;
                }
                if (oldPosition.size() != outsidePointCounter) continue;
                System.out.println("Point is first in simples");
                this.changePntTarget(clonePosition.first(), annotationTarget);
                System.out.println("First point changed to target");
            }
        }
        this.editHappened(this.model.addAnnotation(annotationClone));
    }

    private void changePntTarget(Position.Pnt point, HierarchicalObject target) {
        Position.Pnt copyPnt = point.createCopy();
        point.target(target);
        System.out.println("Anchor: " + point.anchor());
        point.setIncomplete();
        this.editHappened(new PntEdit(point, copyPnt));
    }

    public void pasteOnto(HierarchicalNode node, HierarchicalNode target) {
        if (target == null) {
            this.addTree(node);
        } else {
            this.replaceNode(target, node);
        }
    }

    public void pasteUnder() {
        this.selectionMgr.getClipboard().cloneObjects(this.model);
        List<HierarchicalNode> nodes = this.selectionMgr.getClipboard().getTrees();
        List<Annotation> annotations = this.selectionMgr.getClipboard().getAnnotations();
        HashTable cloneTable = this.selectionMgr.getClipboard().getCloneTable();
        if (nodes.isEmpty() && annotations.isEmpty()) {
            return;
        }
        this.startCompoundEdit();
        HierarchicalNode target = this.selectionMgr.getFirstNode();
        if (target == null) {
            this.pasteOnto();
            return;
        }
        HierarchicalNode annotationTarget = target;
        for (HierarchicalNode node : nodes) {
            this.editHappened(this.model.addChild(target, (HierarchicalNode)cloneTable.get(node)));
        }
        this.pasteAnnotations(annotationTarget);
        this.update(null);
    }

    private void pasteAnnotations(HierarchicalObject target) {
        List<Annotation> annotations = this.selectionMgr.getClipboard().getAnnotations();
        if (target == null) {
            target = this.selectionMgr.getFirstObject();
        }
        if (target == null) {
            return;
        }
        for (Annotation annotation : annotations) {
            this.pasteOnto(annotation, target);
        }
    }

    public void pendleNode(HierarchicalNode node) {
        this.model.pendleNode(node);
        this.selectionMgr.selectOnly(node);
        this.update(null);
    }

    public void pendleNodes() {
        for (HierarchicalNode node : this.selectionMgr.getNodes()) {
            this.pendleNode(node);
        }
    }

    public void redo() {
        System.out.println("Redo Start" + this.undoMgr.getRedoPresentationName());
        this.undoMgr.redo();
        this.model.update();
        this.selectionMgr.update();
        System.out.println("Redo Done");
    }

    public void removeAnnotation(HierarchicalObject obj) {
        this.editHappened(this.model.removeAnnotation(obj));
        this.update(null);
    }

    public void removeBranch(HierarchicalBranch branch) {
        this.startCompoundEdit();
        HierarchicalNode parent = branch.getParent();
        this.editHappened(this.model.removeBranch(branch));
        this.editHappened(this.model.complementNode(parent, 1));
        this.update(null);
    }

    public void removeNode(HierarchicalNode node) {
        this.editHappened(this.model.removeNode(node));
        this.selectionMgr.deselect(node);
    }

    public void removeObjects() {
        Vector<HierarchicalNode> roots = new Vector<HierarchicalNode>(this.model.getRootNodes());
        if (!roots.retainAll(this.selectionMgr.getObjects())) {
            JOptionPane confirmationPane = new JOptionPane("You are about to remove the last tree, this will clear the entire model. Are you sure?", 3, 0);
            NavigatableDialog dialog = new NavigatableDialog((Component)this.mf, confirmationPane, "Clearing model");
            int result = (Integer)dialog.getResult();
            if (result == 0) {
                this.clearModel();
            }
            return;
        }
        for (HierarchicalObject obj : new Vector<HierarchicalObject>(this.selectionMgr.getObjects())) {
            if (obj instanceof HierarchicalBranch) {
                this.removeNode(((HierarchicalBranch)obj).getChild());
                continue;
            }
            if (obj instanceof HierarchicalNode) {
                HierarchicalNode node = (HierarchicalNode)obj;
                if (node.isRoot() && node.getModel().getRootNodes().size() == 1) {
                    this.clearModel();
                    continue;
                }
                this.removeNode(node);
                continue;
            }
            this.removeAnnotation(obj);
        }
        this.update(null);
    }

    public void replaceModel(HierarchicalModel model) {
        for (Observer obs : this.model.getObservers()) {
            model.addObserver(obs);
        }
        this.undoMgr.discardAllEdits();
        this.model.deleteObservers();
        this.model = model;
        this.model.setUpToDate(true);
        this.update(null);
    }

    public void replaceNode(HierarchicalNode target, HierarchicalNode nwNode) {
        UndoableEdit edit = this.model.replaceNode(target, nwNode);
        this.editHappened(edit);
        if (edit != null) {
            this.selectionMgr.selectOnly(nwNode);
        }
    }

    public void select(HierarchicalObject obj) {
        this.selectionMgr.addObject(obj);
        this.selectionMgr.update();
    }

    public void selectAbove() {
        this.selectionMgr.selectAbove();
        this.selectionMgr.update();
    }

    public void selectAll() {
        this.selectionMgr.selectAll(this.model);
        this.selectionMgr.update();
    }

    public void selectBelow() {
        this.selectionMgr.selectBelow();
        this.selectionMgr.update();
    }

    public void selectLeft() {
        this.selectionMgr.selectLeft();
        this.selectionMgr.update();
    }

    public void selectNone() {
        this.selectionMgr.selectNone();
        this.selectionMgr.update();
    }

    public void selectObjects(Collection<? extends HierarchicalObject> objs) {
        this.selectionMgr.selectNone();
        this.selectionMgr.addObjects(objs);
        this.selectionMgr.update();
    }

    public void selectOnly(HierarchicalObject obj) {
        this.selectionMgr.selectOnly(obj);
        this.selectionMgr.update();
    }

    public void selectRight() {
        this.selectionMgr.selectRight();
        this.selectionMgr.update();
    }

    public void selectSubtree() {
        this.selectionMgr.selectSubtree();
        this.selectionMgr.update();
    }

    public void selectSupertree() {
        this.selectionMgr.selectSupertree();
        this.selectionMgr.update();
    }

    public void setClipboard(HierarchicalNode node) {
        this.selectionMgr.setClipboard(node);
        this.selectionMgr.update();
    }

    public void setMf(MainFrame mf) {
        this.mf = mf;
    }

    public void setSetting(String key, Serializable val) {
        this.setSetting(key, val, null);
    }

    public void setSetting(String key, Serializable val, View vw) {
        this.model.setSetting(key, val, vw);
        this.update(null);
    }

    public void setUpdateManager(UpdateManager manager) {
        this.updateManager = manager;
    }

    public void showSettings() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PreferencesWindow(HierarchicalController.this);
            }
        });
    }

    public CompoundEdit startCompoundEdit() {
        if (this.cpEdit == null) {
            this.cpEdit = new CountingCompoundEdit();
        }
        System.out.println("HC start compound");
        return this.cpEdit;
    }

    public void switchBranchShape() {
        HierarchicalBranch branch = this.selectionMgr.getFirstBranch();
        branch.switchShape();
        this.update(new ModifyBranchEdit(branch, 1));
    }

    public void switchBranchStyle() {
        HierarchicalBranch branch = this.selectionMgr.getFirstBranch();
        branch.switchStyle();
        this.update(new ModifyBranchEdit(branch, 0));
    }

    public void switchNodes() {
        List<HierarchicalNode> nodes = this.selectionMgr.getNodes();
        if (nodes.size() == 1) {
            this.switchNodes(nodes.get(0));
        } else if (nodes.size() == 2) {
            this.switchNodes(nodes.get(0), nodes.get(1));
        } else {
            return;
        }
        this.update(null);
    }

    public void switchNodes(HierarchicalNode child) {
        this.editHappened(this.model.switchNodes(child));
    }

    public void switchNodes(HierarchicalNode c1, HierarchicalNode c2) {
        this.editHappened(this.model.switchNodes(c1, c2));
    }

    public void undo() {
        System.out.println("Undo Start");
        this.undoMgr.undo();
        this.model.update();
        this.selectionMgr.update();
        System.out.println("Undo Done");
    }

    public void update(UndoableEdit edit) {
        if (edit != null) {
            this.editHappened(edit);
        } else if (this.cpEdit != null) {
            this.update(this.endCompoundEdit());
        }
        this.model.update();
        this.selectionMgr.update();
    }

    public void endCurrentEditor() {
        Editor currentEditor = this.mf.getCurrentEditor();
        if (currentEditor != null) {
            currentEditor.end();
        }
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public void removeObserver(Observer o) {
        this.model.deleteObserver(o);
        this.selectionMgr.deleteObserver(o);
    }

    public Vector<Action> getStyleActions() {
        return this.styleActions;
    }

    private static class CountingCompoundEdit
    extends CompoundEdit {
        private int len = 0;

        private CountingCompoundEdit() {
        }

        @Override
        public boolean addEdit(UndoableEdit edit) {
            ++this.len;
            return super.addEdit(edit);
        }

        public int size() {
            return this.len;
        }
    }
}

