/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import nl.rug.syntree.Settings;
import nl.rug.syntree.bracketstructure.Pregnancy;
import nl.rug.syntree.hierarchicalmodel.HierarchicalBranch;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Style;
import nl.rug.syntree.hierarchicalmodel.undoableedits.AddAnnotationEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.AddChildEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.AddParentEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.AddTreeEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.ExpandCollapseEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.MoveChildEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.RemoveAnnotationEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.RemoveBranchEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.RemoveChildEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.RemoveTreeEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.ReplaceNodeEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.SettingEdit;
import nl.rug.syntree.hierarchicalmodel.undoableedits.SwitchNodesEdit;
import nl.rug.syntree.mainview.View;

public class HierarchicalModel
extends Observable
implements Serializable {
    private static final long serialVersionUID = -8057392738017691859L;
    private Vector<HierarchicalNode> roots = null;
    private int currentID = 0;
    private Vector<HierarchicalObject> annotations = new Vector();
    private Settings.SettingMap settings;
    private transient ArrayList<Observer> observers = null;
    private transient boolean dirty = true;
    private transient boolean upToDate = true;
    private transient File fileName = null;
    private boolean centered;

    public HierarchicalModel() {
        this.init();
    }

    private HierarchicalNode addParent(HierarchicalNode child, boolean allowInternal) {
        HierarchicalNode oldParent = child.getParent();
        if (oldParent != null && !allowInternal) {
            return null;
        }
        HierarchicalNode ret = new HierarchicalNode(this);
        int idx = child.getSiblingIndex();
        if (oldParent != null) {
            oldParent.removeChild(child);
            oldParent.addChild(ret, idx);
        } else {
            this.roots.remove(child);
            this.roots.insertElementAt(ret, idx);
        }
        ret.addChild(child);
        return ret;
    }

    private void init() {
        this.roots = new Vector();
        this.observers = new ArrayList();
        this.settings = new Settings.SettingMap();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.init();
        in.defaultReadObject();
    }

    private void removePregnanciesTree(HierarchicalNode node) {
        node.removeTweaksByType(Pregnancy.class);
        for (HierarchicalNode child : node.getChildren()) {
            this.removePregnanciesTree(child);
        }
    }

    void update(Boolean dirt, boolean validate) {
        if (dirt != null) {
            this.setDirty(dirt);
        }
        if (validate) {
            this.doValidate();
        }
        this.setChanged();
        this.notifyObservers();
        this.setCentered(false);
    }

    public AddAnnotationEdit addAnnotation(HierarchicalObject an) {
        this.annotations.add(an);
        return new AddAnnotationEdit(this, an);
    }

    public void addBranch(HierarchicalNode parent, HierarchicalBranch branch, int idx) {
        if (branch.getChild() == null) {
            return;
        }
        parent.addChild(branch.getChild(), branch, idx);
    }

    public AddChildEdit addChild(HierarchicalNode parent) {
        HierarchicalNode ret = new HierarchicalNode(this);
        if (parent.hasChildren()) {
            ret.pendle(true);
        }
        int idx = parent.getChildren().size() / 2;
        parent.addChild(ret, idx);
        return new AddChildEdit(this, parent, ret, idx);
    }

    public AddChildEdit addChild(HierarchicalNode parent, HierarchicalNode child) {
        if (child.hasParent()) {
            this.removeChild(child);
        }
        parent.addChild(child);
        return new AddChildEdit(this, parent, child, child.getSiblingIndex());
    }

    public AddChildEdit addChild(HierarchicalNode parent, HierarchicalNode child, int idx) {
        if (child.hasParent()) {
            this.removeChild(child);
        }
        parent.addChild(child, idx);
        return new AddChildEdit(this, parent, child, idx);
    }

    @Override
    public void addObserver(Observer o) {
        super.addObserver(o);
        this.observers.add(o);
    }

    public AddParentEdit addParent(HierarchicalNode child) {
        HierarchicalNode parent = this.addParent(child, true);
        return new AddParentEdit(this, parent, child, parent.getSiblingIndex());
    }

    public AddParentEdit addParentAndSibling(HierarchicalNode child, boolean left) {
        if (child.getParent() != null) {
            return null;
        }
        HierarchicalNode parent = this.addParent(child, false);
        HierarchicalNode nwChild = new HierarchicalNode(this);
        if (left) {
            parent.addChild(nwChild, 0);
        } else {
            parent.addChild(nwChild);
        }
        return new AddParentEdit(this, parent, child, parent.getSiblingIndex());
    }

    public AddChildEdit addSibling(HierarchicalNode child, boolean left) {
        HierarchicalNode parent = child.getParent();
        if (parent == null) {
            return null;
        }
        HierarchicalNode nwChild = new HierarchicalNode(this);
        int idx = child.getSiblingIndex();
        if (!left) {
            ++idx;
        }
        parent.addChild(nwChild, idx);
        return new AddChildEdit(this, parent, nwChild, idx);
    }

    public AddTreeEdit addTree() {
        HierarchicalNode tree = new HierarchicalNode(this);
        return this.addTree(tree);
    }

    public AddTreeEdit addTree(HierarchicalNode childNode) {
        if (childNode.hasParent()) {
            this.removeChild(childNode);
        }
        childNode.setParent(null);
        this.roots.add(childNode);
        AddChildEdit addChildEdit = null;
        if (!childNode.hasChildren()) {
            addChildEdit = this.addTwoChildren(childNode);
        }
        return new AddTreeEdit(this, childNode, addChildEdit);
    }

    public AddTreeEdit addTree(HierarchicalNode childNode, int idx) {
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= this.roots.size()) {
            this.roots.add(childNode);
        } else {
            this.roots.add(idx, childNode);
        }
        return new AddTreeEdit(this, childNode);
    }

    public AddChildEdit addTwoChildren(HierarchicalNode parent) {
        HierarchicalNode c1 = new HierarchicalNode(this);
        HierarchicalNode c2 = new HierarchicalNode(this);
        parent.addChild(c1);
        parent.addChild(c2);
        return new AddChildEdit(this, parent, c1, c2);
    }

    public CompoundEdit clearModel() {
        CompoundEdit ce = new CompoundEdit();
        Iterator<HierarchicalNode> nodeIt = this.roots.iterator();
        while (nodeIt.hasNext()) {
            HierarchicalNode root = nodeIt.next();
            nodeIt.remove();
            ce.addEdit(new RemoveTreeEdit(this, root));
        }
        Iterator<HierarchicalObject> annoIt = this.annotations.iterator();
        while (annoIt.hasNext()) {
            HierarchicalObject anno = annoIt.next();
            annoIt.remove();
            ce.addEdit(new RemoveAnnotationEdit(this, anno));
        }
        ce.addEdit(this.addTree());
        ce.end();
        return ce;
    }

    public CompoundEdit copyChildren(HierarchicalNode node, HierarchicalNode tempNode) {
        CompoundEdit ce = new CompoundEdit();
        for (HierarchicalNode childNode : tempNode.getChildren()) {
            HierarchicalNode newChildNode = new HierarchicalNode(this, childNode.getContent());
            newChildNode.copyChildren(childNode);
            ce.addEdit(this.addChild(node, newChildNode));
            if (childNode.getParent().getBranchFor(childNode).getTweakByType(Style.class) == null) continue;
            newChildNode.getParent().getBranchFor(newChildNode).addTweak(childNode.getParent().getBranchFor(childNode).getTweakByType(Style.class));
        }
        ce.end();
        return ce;
    }

    @Override
    public void deleteObserver(Observer o) {
        super.deleteObserver(o);
        this.observers.remove(o);
    }

    public void doValidate() {
        Iterator<HierarchicalObject> it = this.roots.iterator();
        while (it.hasNext()) {
            HierarchicalObject node = it.next();
            if (node.validate()) continue;
            it.remove();
        }
        it = this.annotations.iterator();
        while (it.hasNext()) {
            HierarchicalObject an = it.next();
            if (an.validate()) continue;
            it.remove();
        }
    }

    public ExpandCollapseEdit expandCollapseNode(HierarchicalNode node) {
        Vector<HierarchicalNode> nodes = node.collapse(!node.isCollapsed());
        return new ExpandCollapseEdit(this, nodes);
    }

    public File file() {
        return this.fileName;
    }

    public HierarchicalModel file(File f) {
        this.fileName = f;
        return this;
    }

    public void fixId(int newId) {
        if (this.currentID <= newId) {
            this.currentID = newId + 1;
        }
    }

    public List<HierarchicalObject> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public HierarchicalBranch getBranchById(int id) {
        for (HierarchicalNode root : this.roots) {
            HierarchicalBranch branch = root.getBranchById(id);
            if (branch == null) continue;
            return branch;
        }
        return null;
    }

    public int getID() {
        return this.currentID++;
    }

    public HierarchicalNode getNodeById(int id) {
        for (HierarchicalNode root : this.roots) {
            HierarchicalNode child = root.getChildById(id);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public HierarchicalObject getObjectById(int id) {
        for (HierarchicalObject obj : this.annotations) {
            if (obj.getId() != id) continue;
            return obj;
        }
        HierarchicalNode obj = this.getNodeById(id);
        if (obj != null) {
            return obj;
        }
        return this.getBranchById(id);
    }

    public ArrayList<Observer> getObservers() {
        return this.observers;
    }

    public List<HierarchicalNode> getRootNodes() {
        return Collections.unmodifiableList(this.roots);
    }

    public Serializable getSetting(String key) {
        return (Serializable)this.settings.get(key);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public MoveChildEdit moveChild(HierarchicalNode child, int idx) {
        HierarchicalNode parent = child.getParent();
        HierarchicalBranch branch = parent.getBranchFor(child);
        if (branch == null) {
            return null;
        }
        int from = child.getSiblingIndex();
        parent.getBranches().remove(branch);
        parent.getBranches().add(idx, branch);
        return new MoveChildEdit(this, child, from);
    }

    public void pendleNode(HierarchicalNode node) {
        node.pendle(true);
    }

    public RemoveAnnotationEdit removeAnnotation(HierarchicalObject an) {
        if (!this.annotations.remove(an)) {
            return null;
        }
        return new RemoveAnnotationEdit(this, an);
    }

    public RemoveBranchEdit removeBranch(HierarchicalBranch branch) {
        HierarchicalNode parent = branch.getParent();
        HierarchicalNode child = branch.getChild();
        if (parent == null || child == null) {
            return null;
        }
        int idx = child.getSiblingIndex();
        parent.removeBranch(branch);
        AddTreeEdit addTreeEdit = this.addTree(child);
        return new RemoveBranchEdit(this, branch, parent, idx, addTreeEdit);
    }

    public CompoundEdit removeChildAndComplement(HierarchicalNode child) {
        CompoundEdit ce = new CompoundEdit();
        HierarchicalNode parent = child.getParent();
        ce.addEdit(this.removeChild(child));
        CompoundEdit complementEdit = this.complementNode(parent, 1);
        if (complementEdit != null) {
            ce.addEdit(complementEdit);
        }
        ce.end();
        return ce;
    }

    public CompoundEdit complementNode(HierarchicalNode parent, int count) {
        if (parent.isRoot() && !parent.hasChildren()) {
            CompoundEdit ce = new CompoundEdit();
            for (int i = 0; i < count; ++i) {
                ce.addEdit(this.addChild(parent, new HierarchicalNode(this), i));
            }
            ce.end();
            return ce;
        }
        return null;
    }

    public RemoveChildEdit removeChild(HierarchicalNode child) {
        if (child.getParent() == null) {
            return null;
        }
        HierarchicalNode parent = child.getParent();
        int idx = child.getSiblingIndex();
        parent.removeChild(child);
        child.setParent(null);
        return new RemoveChildEdit(this, child, parent, idx);
    }

    public CompoundEdit removeChildren(HierarchicalNode node) {
        CompoundEdit ce = new CompoundEdit();
        Vector<HierarchicalNode> children = node.getChildren();
        for (HierarchicalNode child : children) {
            ce.addEdit(this.removeChild(child));
        }
        ce.end();
        return ce;
    }

    public UndoableEdit removeNode(HierarchicalNode node) {
        if (node.isRoot()) {
            return this.removeTree(node);
        }
        return this.removeChildAndComplement(node);
    }

    public void removePregnancies() {
        for (HierarchicalNode node : this.roots) {
            this.removePregnanciesTree(node);
        }
    }

    public RemoveTreeEdit removeTree(HierarchicalNode tree) {
        RemoveTreeEdit edit = new RemoveTreeEdit(this, tree);
        if (!this.roots.remove(tree)) {
            return null;
        }
        return edit;
    }

    public UndoableEdit replaceNode(HierarchicalNode target, HierarchicalNode nwNode) {
        HierarchicalNode parent = target.getParent();
        if (parent == null) {
            CompoundEdit replaceNodeEdit = new CompoundEdit();
            int targetLocation = target.getSiblingIndex();
            replaceNodeEdit.addEdit(this.removeNode(target));
            replaceNodeEdit.addEdit(this.addTree(nwNode, targetLocation));
            CompoundEdit complementEdit = this.complementNode(nwNode, 2);
            if (complementEdit != null) {
                replaceNodeEdit.addEdit(complementEdit);
            }
            replaceNodeEdit.end();
            return replaceNodeEdit;
        }
        HierarchicalBranch branch = parent.getBranchFor(target);
        nwNode.setParent(target.getParent());
        branch.setChild(nwNode);
        return new ReplaceNodeEdit(this, target, nwNode);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public SettingEdit setSetting(String key, Serializable val) {
        return this.setSetting(key, val, null);
    }

    public SettingEdit setSetting(String key, Serializable val, View vw) {
        if (vw != null) {
            key = key + "-" + vw.getId();
        }
        Serializable old = (Serializable)this.settings.get(key);
        this.settings.put(key, val);
        return new SettingEdit(this, key, old, val);
    }

    public void setUpToDate(boolean upToDate) {
        this.upToDate = upToDate;
    }

    public SwitchNodesEdit switchNodes(HierarchicalNode child) {
        if (!child.hasParent()) {
            return null;
        }
        HierarchicalNode parent = child.getParent();
        int size = parent.getChildren().size();
        if (size == 1) {
            return null;
        }
        int idx = (child.getSiblingIndex() + 1) % size;
        HierarchicalNode other = parent.getChildren().get(idx);
        return this.switchNodes(child, other);
    }

    public SwitchNodesEdit switchNodes(HierarchicalNode c1, HierarchicalNode c2) {
        HierarchicalNode parent = c1.getParent();
        if (parent != c2.getParent()) {
            return null;
        }
        SwitchNodesEdit edit = new SwitchNodesEdit(this, parent, c1, c1.getSiblingIndex(), c2, c2.getSiblingIndex());
        parent.switchChildren(c1, c2);
        return edit;
    }

    public void update() {
        this.update(null, true);
    }

    public boolean isUpToDate() {
        return this.upToDate;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public boolean isCentered() {
        return this.centered;
    }
}

