/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import nl.rug.syntree.hierarchicalmodel.HierarchicalBranch;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Style;
import nl.rug.syntree.hierarchicalmodel.nodecontent.DocumentContent;

public class HierarchicalNode
extends HierarchicalObject {
    private static final long serialVersionUID = -4966187267071848266L;
    private boolean pendling = false;
    private DocumentContent content = null;
    private HierarchicalNode parent = null;
    private Vector<HierarchicalBranch> branchesDown = new Vector();
    private boolean collapsed = false;

    public HierarchicalNode(HierarchicalModel model) {
        this(model, HierarchicalNode.makeDoc());
    }

    public HierarchicalNode(HierarchicalModel model, DocumentContent content) {
        super(model);
        this.content = content;
    }

    public HierarchicalNode(HierarchicalModel model, String text) {
        this(model, HierarchicalNode.makeDoc(text));
    }

    private boolean checkCyclicity() {
        return this.checkCyclicity(new Vector<HierarchicalNode>());
    }

    private boolean checkCyclicity(Vector<HierarchicalNode> visited) {
        if (visited.contains(this)) {
            System.out.println("HNode: cyclicity fail: " + this);
            return false;
        }
        visited.add(this);
        if (this.hasParent()) {
            return this.getParent().checkCyclicity(visited);
        }
        return true;
    }

    private void switchBranchesByIds(int positionA, int positionB) {
        HierarchicalBranch temp = this.branchesDown.get(positionA);
        this.branchesDown.set(positionA, this.branchesDown.get(positionB));
        this.branchesDown.set(positionB, temp);
    }

    public HierarchicalNode addChild(HierarchicalNode child) {
        return this.addChild(child, new HierarchicalBranch(this.model, child));
    }

    public HierarchicalNode addChild(HierarchicalNode childNode, HierarchicalBranch branch) {
        if (!this.checkCyclicity(childNode)) {
            return null;
        }
        branch.setChild(childNode);
        childNode.setParent(this);
        this.branchesDown.add(branch);
        return childNode;
    }

    public HierarchicalNode addChild(HierarchicalNode newChild, HierarchicalBranch branch, int position) {
        branch.setChild(newChild);
        if (position < 0 || position >= this.branchesDown.size()) {
            return this.addChild(newChild, branch);
        }
        if (!this.checkCyclicity(newChild)) {
            return null;
        }
        newChild.setParent(this);
        this.branchesDown.add(position, branch);
        return newChild;
    }

    public HierarchicalNode addChild(HierarchicalNode newChild, int position) {
        return this.addChild(newChild, new HierarchicalBranch(this.model, newChild), position);
    }

    public HierarchicalNode appendChild(HierarchicalNode childNode) {
        if (!this.checkCyclicity(childNode)) {
            return null;
        }
        HierarchicalBranch branch = new HierarchicalBranch(this.model, childNode);
        this.branchesDown.add(branch);
        if (childNode.getParent() != this) {
            childNode.setParent(this);
        }
        return childNode;
    }

    public boolean checkCyclicity(HierarchicalNode candidate) {
        Vector<HierarchicalNode> visited = new Vector<HierarchicalNode>();
        visited.add(candidate);
        return this.checkCyclicity(visited);
    }

    public void copyChildren(HierarchicalNode node) {
        for (HierarchicalNode childNode : node.getChildren()) {
            HierarchicalNode newChildNode = new HierarchicalNode(this.model, childNode.content);
            newChildNode.copyChildren(childNode);
            this.appendChild(newChildNode);
            if (childNode.getParent().getBranchFor(childNode).getTweakByType(Style.class) == null) continue;
            newChildNode.getParent().getBranchFor(newChildNode).addTweak(childNode.getParent().getBranchFor(childNode).getTweakByType(Style.class));
        }
    }

    public HierarchicalNode deepClone(HierarchicalModel model) {
        HierarchicalNode clone = this.parentlessDeepClone(model);
        clone.setParent(this.getParent());
        return clone;
    }

    public HierarchicalNode parentlessDeepClone(HierarchicalModel model) {
        HierarchicalNode ret = new HierarchicalNode(model);
        ret.setContent(this.getContent().createCopy());
        for (HierarchicalNode child : this.getChildren()) {
            HierarchicalNode childClone = child.deepClone(model);
            ret.addChild(childClone, this.getBranchFor(child).createCopy(model, childClone));
        }
        return ret;
    }

    @Override
    public void delete() {
        this.content.delete();
        if (this.isRoot()) {
            this.model.getRootNodes().remove(this);
            return;
        }
        this.parent.removeChild(this);
    }

    public Vector<HierarchicalNode> getAncestors() {
        Vector<HierarchicalNode> ret = new Vector<HierarchicalNode>();
        if (this.parent != null) {
            ret.add(this.parent);
            ret.addAll(this.parent.getAncestors());
        }
        return ret;
    }

    public HierarchicalBranch getBranchById(int id) {
        for (HierarchicalBranch branch : this.branchesDown) {
            if (branch.getId() == id) {
                return branch;
            }
            HierarchicalBranch child = branch.getChild().getBranchById(id);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public Vector<HierarchicalBranch> getBranches() {
        return this.branchesDown;
    }

    public HierarchicalBranch getBranchFor(HierarchicalNode selectedNode) {
        for (HierarchicalBranch itrBranch : this.branchesDown) {
            if (itrBranch.getChild() != selectedNode) continue;
            return itrBranch;
        }
        return null;
    }

    public HierarchicalNode getChildById(int id) {
        if (this.getId() == id) {
            return this;
        }
        for (HierarchicalNode child : this.getChildren()) {
            HierarchicalNode found = child.getChildById(id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Vector<HierarchicalNode> getChildren() {
        Vector<HierarchicalNode> childrenList = new Vector<HierarchicalNode>();
        for (HierarchicalBranch itrBranch : this.branchesDown) {
            childrenList.add(itrBranch.getChild());
        }
        return childrenList;
    }

    public DocumentContent getContent() {
        return this.content;
    }

    public int getDepth() {
        return this.hasParent() ? this.getParent().getDepth() + 1 : 0;
    }

    public Vector<HierarchicalObject> getDescendants(boolean branches) {
        Vector<HierarchicalObject> descendants = new Vector<HierarchicalObject>();
        for (HierarchicalNode childNode : this.getChildren()) {
            descendants.add(childNode);
            if (branches) {
                descendants.add(this.getBranchFor(childNode));
            }
            descendants.addAll(childNode.getDescendants(branches));
        }
        return descendants;
    }

    public HierarchicalNode getParent() {
        return this.parent;
    }

    public HierarchicalNode getRoot() {
        if (!this.hasParent()) {
            return this;
        }
        return this.getParent().getRoot();
    }

    public Vector<HierarchicalNode> getTerminals() {
        Vector<HierarchicalNode> terminals = new Vector<HierarchicalNode>();
        Vector<HierarchicalNode> children = this.getChildren();
        for (HierarchicalNode child : children) {
            Vector<HierarchicalNode> childTerminals = child.getTerminals();
            if (childTerminals.isEmpty()) {
                terminals.add(child);
                continue;
            }
            terminals.addAll(childTerminals);
        }
        return terminals;
    }

    public Vector<HierarchicalNode> getFirstExpandedOffspring() {
        Vector<HierarchicalNode> offspring = new Vector<HierarchicalNode>();
        Vector<HierarchicalNode> children = this.getChildren();
        for (HierarchicalNode child : children) {
            if (child.isCollapsed()) {
                offspring.addAll(child.getFirstExpandedOffspring());
                continue;
            }
            offspring.add(child);
        }
        return offspring;
    }

    public int getSiblingIndex() {
        if (this.parent != null) {
            int index = -1;
            if (this.parent.getChildren() != null) {
                index = this.parent.getChildren().indexOf(this);
            }
            return index;
        }
        return this.model.getRootNodes().indexOf(this);
    }

    public boolean hasChildren() {
        if (this.branchesDown == null) {
            return false;
        }
        return this.branchesDown.size() > 0;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void orphanize() {
        this.setParent(null);
    }

    public boolean pendle() {
        return this.pendling;
    }

    public void pendle(boolean plantChild) {
        this.pendling = plantChild;
    }

    public void removeBranch(HierarchicalBranch hierarchicalBranch) {
        this.branchesDown.remove(hierarchicalBranch);
    }

    public boolean removeChild(HierarchicalNode childNode) {
        Iterator<HierarchicalBranch> it = this.branchesDown.iterator();
        while (it.hasNext()) {
            HierarchicalBranch branch = it.next();
            if (branch.getChild().getId() != childNode.getId()) continue;
            it.remove();
            childNode.orphanize();
            return true;
        }
        return false;
    }

    public void removeChildren() {
        this.branchesDown.clear();
    }

    public void setContent(DocumentContent content) {
        this.content = content;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public Vector<HierarchicalNode> collapse(boolean collapsed) {
        Vector<HierarchicalNode> nodes = new Vector<HierarchicalNode>();
        if (this.hasChildren() && this.collapsed != collapsed) {
            nodes.add(this);
            this.collapsed = collapsed;
        }
        for (HierarchicalNode child : this.getChildren()) {
            nodes.addAll(child.collapse(collapsed));
        }
        return nodes;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    public HierarchicalNode setParent(HierarchicalNode node) {
        this.parent = node;
        return node;
    }

    public void switchBranch(HierarchicalBranch selectedBranchA, HierarchicalBranch selectedBranchB) {
        int positionA = this.branchesDown.indexOf(selectedBranchA);
        int positionB = this.branchesDown.indexOf(selectedBranchB);
        this.switchBranchesByIds(positionA, positionB);
    }

    public void switchChildren(HierarchicalNode c1, HierarchicalNode c2) {
        this.switchBranch(this.getBranchFor(c1), this.getBranchFor(c2));
    }

    @Override
    public boolean validate() {
        if (!this.checkCyclicity()) {
            return false;
        }
        Iterator<HierarchicalBranch> it = this.branchesDown.iterator();
        while (it.hasNext()) {
            HierarchicalBranch child = it.next();
            if (child.validate()) continue;
            it.remove();
        }
        boolean b = super.validate();
        if (!b) {
            System.out.println("Node " + this + " invalidated");
        }
        return b;
    }

    private static DocumentContent makeDoc() {
        return HierarchicalNode.makeDoc("");
    }

    private static DocumentContent makeDoc(String content) {
        DocumentContent ret = new DocumentContent();
        try {
            ret.remove(0, ret.getLength());
            ret.insertString(0, content, ret.getStyle("default"));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

