/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel;

import java.io.Serializable;
import java.util.Vector;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.annotations.Tweak;

public abstract class HierarchicalObject
implements Serializable {
    private static final long serialVersionUID = -2212230333530491106L;
    protected int id;
    protected HierarchicalModel model = null;
    protected Vector<Tweak> tweaks;

    protected HierarchicalObject(HierarchicalModel model) {
        this.model = model;
        this.id = model.getID();
        this.tweaks = new Vector();
    }

    protected HierarchicalObject(HierarchicalModel model, int id) {
        this.model = model;
        this.id = id;
        this.tweaks = new Vector();
        model.fixId(id);
    }

    public synchronized void addTweak(Tweak an) {
        if (an == null) {
            return;
        }
        Tweak old = this.getTweakByType(an.getClass());
        if (old != null) {
            this.tweaks.remove(old);
        }
        this.tweaks.add(an);
    }

    public void addTweaks(Vector<Tweak> tweaks) {
        for (Tweak tweak : tweaks) {
            this.addTweak(tweak);
        }
    }

    public abstract void delete();

    public int getId() {
        return this.id;
    }

    public HierarchicalModel getModel() {
        return this.model;
    }

    public synchronized Tweak getTweakByType(Class type) {
        for (Tweak an : this.tweaks) {
            if (!an.getClass().equals(type)) continue;
            return an;
        }
        return null;
    }

    public Vector<Tweak> getTweakCopies() {
        Vector<Tweak> tweaks = this.getTweaks();
        Vector<Tweak> copies = new Vector<Tweak>();
        for (Tweak tweak : tweaks) {
            copies.add(tweak.createCopy());
        }
        return copies;
    }

    public Vector<Tweak> getTweaks() {
        return this.tweaks;
    }

    public synchronized void removeTweaksByType(Class type) {
        this.tweaks.remove(this.getTweakByType(type));
    }

    public String toString() {
        return super.toString() + "#" + this.getId();
    }

    public synchronized boolean validate() {
        boolean ret = this.model.getObjectById(this.getId()) != null;
        return ret;
    }
}

