/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import nl.rug.syntree.hierarchicalmodel.HierarchicalBranch;
import nl.rug.syntree.hierarchicalmodel.HierarchicalClipboard;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Annotation;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;

public class SelectionManager
extends Observable {
    private Vector<HierarchicalObject> objects = new Vector();
    private HierarchicalClipboard clipboard;
    private HierarchicalController control;

    public SelectionManager(HierarchicalController control, HierarchicalClipboard clipboard) {
        this.control = control;
        this.clipboard = clipboard;
    }

    public void addObject(HierarchicalObject object) {
        if (this.objects.contains(object) || object == null) {
            return;
        }
        this.objects.add(object);
    }

    public void addObjects(Collection<? extends HierarchicalObject> objs) {
        for (HierarchicalObject hierarchicalObject : objs) {
            this.addObject(hierarchicalObject);
        }
    }

    public void clearClipboard() {
        this.clipboard.clear();
    }

    public boolean contains(HierarchicalObject object) {
        return this.objects.contains(object);
    }

    public boolean deselect(HierarchicalObject object) {
        return this.objects.remove(object);
    }

    public List<HierarchicalBranch> getBranches() {
        Vector<HierarchicalBranch> ret = new Vector<HierarchicalBranch>();
        for (HierarchicalObject obj : this.objects) {
            if (!(obj instanceof HierarchicalBranch)) continue;
            ret.add((HierarchicalBranch)obj);
        }
        return Collections.unmodifiableList(ret);
    }

    public HierarchicalBranch getFirstBranch() {
        for (HierarchicalObject obj : this.objects) {
            if (!(obj instanceof HierarchicalBranch)) continue;
            return (HierarchicalBranch)obj;
        }
        return null;
    }

    public HierarchicalNode getFirstNode() {
        for (HierarchicalObject obj : this.objects) {
            if (!(obj instanceof HierarchicalNode)) continue;
            return (HierarchicalNode)obj;
        }
        return null;
    }

    public HierarchicalObject getFirstObject() {
        if (this.objects.size() > 0) {
            return this.objects.firstElement();
        }
        return null;
    }

    public List<HierarchicalNode> getNodes() {
        Vector<HierarchicalNode> ret = new Vector<HierarchicalNode>();
        for (HierarchicalObject obj : this.objects) {
            if (!(obj instanceof HierarchicalNode)) continue;
            ret.add((HierarchicalNode)obj);
        }
        return Collections.unmodifiableList(ret);
    }

    public List<HierarchicalObject> getObjects() {
        return Collections.unmodifiableList(this.objects);
    }

    public boolean isSelected(HierarchicalObject obj) {
        return this.objects.contains(obj);
    }

    public boolean nothingSelected() {
        return this.objects.size() == 0;
    }

    public void selectAbove() {
        HierarchicalObject obj = this.getFirstObject();
        if (obj instanceof HierarchicalNode) {
            HierarchicalNode selectedNode = (HierarchicalNode)obj;
            HierarchicalNode parent = selectedNode.getParent();
            if (parent == null) {
                return;
            }
            this.selectOnly(parent.getBranchFor(selectedNode));
        } else if (obj instanceof HierarchicalBranch) {
            HierarchicalBranch selectedBranch = (HierarchicalBranch)obj;
            this.selectOnly(selectedBranch.getChild().getParent());
        }
    }

    public void selectAll(HierarchicalModel model) {
        this.selectNone();
        for (HierarchicalNode itrNode : model.getRootNodes()) {
            Vector<HierarchicalObject> nodes = itrNode.getDescendants(false);
            this.addObjects(nodes);
            for (HierarchicalObject node : nodes) {
                this.addObjects(((HierarchicalNode)node).getBranches());
            }
        }
    }

    public void selectBelow() {
        HierarchicalObject obj = this.getFirstObject();
        if (obj instanceof HierarchicalNode) {
            HierarchicalNode selectedNode = (HierarchicalNode)obj;
            if (selectedNode.getBranches().size() == 0) {
                return;
            }
            this.selectOnly(selectedNode.getBranches().get(0));
        } else if (obj instanceof HierarchicalBranch) {
            HierarchicalBranch selectedBranch = (HierarchicalBranch)obj;
            this.selectOnly(selectedBranch.getChild());
        }
    }

    public void selectChild() {
        HierarchicalObject obj = this.getFirstObject();
        if (obj instanceof HierarchicalNode) {
            HierarchicalNode selectedNode = (HierarchicalNode)obj;
            if (selectedNode.hasChildren()) {
                this.selectOnly(selectedNode.getBranches().get(0).getChild());
            }
        } else if (obj instanceof HierarchicalBranch) {
            HierarchicalBranch selectedBranch = (HierarchicalBranch)obj;
            this.selectOnly(selectedBranch.getChild());
        }
    }

    public void selectLeft() {
        HierarchicalObject obj = this.getFirstObject();
        if (obj instanceof HierarchicalNode) {
            HierarchicalNode selectedNode = (HierarchicalNode)obj;
            if (!selectedNode.hasParent()) {
                return;
            }
            HierarchicalNode parent = selectedNode.getParent();
            int idx = selectedNode.getSiblingIndex();
            if (idx == 0) {
                return;
            }
            this.selectOnly(parent.getChildren().get(idx - 1));
        } else if (obj instanceof HierarchicalBranch) {
            HierarchicalBranch selectedBranch = (HierarchicalBranch)obj;
            HierarchicalNode parent = selectedBranch.getChild().getParent();
            int idx = parent.getBranches().indexOf(selectedBranch);
            if (idx == 0) {
                return;
            }
            this.selectOnly(parent.getBranches().get(idx - 1));
        }
    }

    public void selectNone() {
        this.objects.clear();
    }

    public void selectOnly(HierarchicalObject obj) {
        this.selectNone();
        this.addObject(obj);
    }

    public void selectParent() {
        HierarchicalObject obj = this.getFirstObject();
        if (obj instanceof HierarchicalNode) {
            HierarchicalNode selectedNode = (HierarchicalNode)obj;
            this.selectOnly(selectedNode.getParent());
        } else if (obj instanceof HierarchicalBranch) {
            HierarchicalBranch selectedBranch = (HierarchicalBranch)obj;
            this.selectOnly(selectedBranch.getChild().getParent());
        }
    }

    public void selectRight() {
        HierarchicalObject obj = this.getFirstObject();
        if (obj instanceof HierarchicalNode) {
            HierarchicalNode selectedNode = (HierarchicalNode)obj;
            if (!selectedNode.hasParent()) {
                return;
            }
            HierarchicalNode parent = selectedNode.getParent();
            int idx = selectedNode.getSiblingIndex();
            if (idx == parent.getChildren().size() - 1) {
                return;
            }
            this.selectOnly(parent.getChildren().get(idx + 1));
        } else if (obj instanceof HierarchicalBranch) {
            HierarchicalBranch selectedBranch = (HierarchicalBranch)obj;
            HierarchicalNode parent = selectedBranch.getChild().getParent();
            int idx = parent.getBranches().indexOf(selectedBranch);
            if (idx == parent.getBranches().size() - 1) {
                return;
            }
            this.selectOnly(parent.getBranches().get(idx + 1));
        }
    }

    public void selectRoot() {
        HierarchicalObject obj = this.getFirstObject();
        if (obj instanceof HierarchicalNode) {
            HierarchicalNode selectedNode = (HierarchicalNode)obj;
            this.selectOnly(selectedNode.getRoot());
        } else if (obj instanceof HierarchicalBranch) {
            HierarchicalBranch selectedBranch = (HierarchicalBranch)obj;
            this.selectOnly(selectedBranch.getChild().getRoot());
        }
    }

    public void selectSubtree() {
        HierarchicalNode node = this.getFirstNode();
        if (node == null) {
            HierarchicalBranch branch = this.getFirstBranch();
            if (branch == null) {
                return;
            }
            node = branch.getChild();
        }
        Vector<HierarchicalObject> nodes = node.getDescendants(false);
        nodes.add(node);
        this.addObjects(nodes);
        for (HierarchicalObject itrNode : nodes) {
            this.addObjects(((HierarchicalNode)itrNode).getBranches());
        }
        this.update();
    }

    public void selectSupertree() {
        HierarchicalNode node = this.getFirstNode();
        if (node == null) {
            HierarchicalBranch branch = this.getFirstBranch();
            if (branch == null) {
                return;
            }
            node = branch.getChild();
        }
        Vector<HierarchicalNode> nodes = node.getAncestors();
        nodes.add(node);
        this.addObjects(nodes);
        for (HierarchicalNode itrNode : nodes) {
            this.addObjects(itrNode.getBranches());
        }
    }

    public void setClipboard() {
        this.clipboard.clear();
        ArrayList<HierarchicalNode> nodes = new ArrayList<HierarchicalNode>(this.getNodes());
        List<HierarchicalBranch> branches = this.getBranches();
        for (HierarchicalBranch hierarchicalBranch : branches) {
            nodes.add(hierarchicalBranch.getChild());
        }
        ArrayList<HierarchicalObject> fullSelection = new ArrayList<HierarchicalObject>();
        for (HierarchicalNode node : nodes) {
            ArrayList<HierarchicalNode> selectedAncestors = new ArrayList<HierarchicalNode>(nodes);
            selectedAncestors.retainAll(node.getAncestors());
            if (!selectedAncestors.isEmpty()) continue;
            this.clipboard.addTree(node);
            fullSelection.add(node);
            fullSelection.addAll(node.getDescendants(true));
        }
        for (HierarchicalObject object : this.getObjects()) {
            if (!(object instanceof Annotation)) continue;
            this.clipboard.addAnnotation((Annotation)object);
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        fullSelection.addAll(this.clipboard.getAnnotations());
        for (HierarchicalObject annotation : this.control.getModel().getAnnotations()) {
            ArrayList<HierarchicalObject> targetList = new ArrayList<HierarchicalObject>();
            Iterator<Position.Pnt> pointIterator = ((Position)annotation.getTweakByType(Position.class)).iterator();
            while (pointIterator.hasNext()) {
                targetList.add(pointIterator.next().target());
            }
            targetList.retainAll(fullSelection);
            if (targetList.isEmpty()) continue;
            System.out.println("Added attached annotation to clipboard");
            arrayList.add((Annotation)annotation);
        }
        this.clipboard.getAnnotations().addAll(arrayList);
    }

    public void setClipboard(HierarchicalNode cTree) {
        this.clipboard.clear();
        this.clipboard.addTree(cTree);
    }

    public HierarchicalClipboard getClipboard() {
        return this.clipboard;
    }

    public void update() {
        this.deselectMissing();
        this.control.getModel().doValidate();
        this.setChanged();
        this.notifyObservers();
    }

    private void deselectMissing() {
        for (HierarchicalObject object : new Vector<HierarchicalObject>(this.objects)) {
            if (this.control.getModel().getObjectById(object.getId()) != null) continue;
            this.deselect(object);
        }
    }

    public void setClipboard(HierarchicalClipboard clipboard) {
        this.clipboard = clipboard;
    }
}

