/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.actions;

import java.util.Observable;
import javax.swing.KeyStroke;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.actions.ModelAction;
import nl.rug.syntree.mainview.components.UIIcons;

public class AddParentLeftChildAction
extends ModelAction {
    public AddParentLeftChildAction(HierarchicalController controller) {
        super(controller, "Add a left sibling", "icons/tree_add_parent_left.png", "Add a sibling to the left of the selected node, adds a parent when the selected node is a root  (Alt + L)");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt L"));
    }

    @Override
    public void actionPerformed() {
        this.hc.addSibling(true);
    }

    @Override
    public void update(Observable o, Object arg) {
        HierarchicalNode node = this.hc.getFirstSelectedNode();
        this.setEnabled(node != null);
        if (node != null) {
            String icon = node.isRoot() ? "icons/tree_add_parent_left.png" : "icons/tree_add_sibling_left.png";
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon(icon));
        }
    }
}

