/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.actions;

import java.util.Observable;
import javax.swing.KeyStroke;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.hierarchicalmodel.HierarchicalNode;
import nl.rug.syntree.hierarchicalmodel.actions.ModelAction;
import nl.rug.syntree.mainview.components.UIIcons;

public class AddParentRightChildAction
extends ModelAction {
    public AddParentRightChildAction(HierarchicalController controller) {
        super(controller, "Add right sibling", "icons/tree_add_parent_right.png", "Add a sibling to the right of the selected node, adds a parent when the selected node is a root  (Alt + R)");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt R"));
    }

    @Override
    public void actionPerformed() {
        this.hc.addSibling(false);
    }

    @Override
    public void update(Observable o, Object arg) {
        HierarchicalNode node = this.hc.getFirstSelectedNode();
        this.setEnabled(node != null);
        if (node != null) {
            String icon = node.isRoot() ? "icons/tree_add_parent_right.png" : "icons/tree_add_sibling_right.png";
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon(icon));
        }
    }
}

