/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.actions;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import nl.rug.syntree.hierarchicalmodel.HierarchicalController;
import nl.rug.syntree.mainview.components.UIIcons;

public abstract class ModelAction
extends AbstractAction
implements Observer {
    protected HierarchicalController hc;

    public ModelAction(HierarchicalController hc, String name, String icon, String descr) {
        this.hc = hc;
        this.putValue("Name", name);
        if (icon != null) {
            this.putValue("SwingLargeIconKey", UIIcons.addImageIcon(icon));
        }
        this.putValue("ShortDescription", descr);
        this.setEnabled(true);
        this.hc.getSelectionManager().addObserver(this);
        this.update(null, null);
    }

    public ModelAction(HierarchicalController hc, String name, String icon, String descr, String keys) {
        this(hc, name, icon, descr);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(keys));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.hc.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelAction.this.actionPerformed();
            }
        });
    }

    abstract void actionPerformed();

    @Override
    public void update(Observable obj, Object arg0) {
    }
}

