/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.annotations;

import java.util.Vector;
import nl.rug.syntree.Settings;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.annotations.Annotation;
import nl.rug.syntree.hierarchicalmodel.annotations.ArrowHead;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.hierarchicalmodel.annotations.Style;

public class Line
extends Annotation {
    private static final long serialVersionUID = -1745227123929187554L;
    public static final int CURVE_NONE = 0;
    public static final int CURVE_QUADRATIC = 2;
    public static final int CURVE_CUBIC = 3;
    private int curving = 0;

    public Line(HierarchicalModel model, Position pos) {
        super(model);
        this.pos = pos;
        this.addTweak(this.pos);
    }

    public Line(HierarchicalModel model, Position.Pnt ... positions) {
        this(model, Line.createPosition(positions));
    }

    private Position.Pnt addAux(Position.Pnt prev, Position.Pnt nxt) {
        float x = (nxt.getAbsX() - prev.getAbsX()) / 2.0f;
        float y = (nxt.getAbsY() - prev.getAbsY()) / 2.0f;
        float delta = Math.max((float)(Math.sqrt(x * x + y * y) / 2.0), ((Float)Settings.get("tv-line-aux-offset", this.model)).floatValue());
        float angl = (float)(Math.PI - Math.atan2(y, x));
        x = (float)((double)x + (double)delta * Math.sin(angl));
        y = (float)((double)y + (double)delta * Math.cos(angl));
        return new Position.Pnt(prev, null, x, y, false);
    }

    private void fixAnchors() {
        if (this.pos.size() < 1) {
            return;
        }
        Position.Pnt prim = this.pos.get(0);
        for (int i = 1; i < this.pos.size() - 1; ++i) {
            Position.Pnt p = this.pos.get(i);
            if (p.primary()) {
                if (p.anchor() == null) {
                    p.anchor(prim);
                }
                prim = p;
                continue;
            }
            p.anchor(prim);
        }
    }

    private int findPrim(Position pos, int prim) {
        int ret = 0;
        for (int i = 1; i < pos.size(); ++i) {
            Position.Pnt p = pos.get(i);
            if (!p.primary()) continue;
            if (ret == prim) {
                return i;
            }
            ++ret;
        }
        return -1;
    }

    private void upgradeCurving(int nw) {
        int cntAux = 0;
        int cntPrim = 0;
        int aux = nw - 1;
        Position.Pnt prim = this.pos.get(0);
        Vector<Position.Pnt> removals = new Vector<Position.Pnt>();
        Vector<Pair<Integer, Position.Pnt>> addals = new Vector<Pair<Integer, Position.Pnt>>();
        System.out.println("Lin uC: " + this.pos.size() + " / " + aux);
        for (int i = 1; i < this.pos.size(); ++i) {
            Position.Pnt pnt = this.pos.get(i);
            if (!pnt.primary()) {
                if (cntAux >= aux) {
                    removals.add(pnt);
                    continue;
                }
                ++cntAux;
                continue;
            }
            while (cntAux < aux) {
                addals.add(new Pair<Integer, Position.Pnt>(cntPrim, this.addAux(prim, pnt)));
                ++cntAux;
            }
            ++cntPrim;
            cntAux = 0;
            prim = pnt;
        }
        for (Position.Pnt pnt : removals) {
            this.pos.remove(pnt);
        }
        for (Pair pair : addals) {
            this.pos.add(this.findPrim(this.pos, (Integer)pair.a), (Position.Pnt)pair.b);
        }
        this.fixAnchors();
    }

    @Override
    public void delete() {
    }

    public int getCurving() {
        return this.curving;
    }

    public Position getPos() {
        return this.pos;
    }

    public Line setCurving(int curving) {
        this.upgradeCurving(curving);
        this.curving = curving;
        return this;
    }

    public Line setPos(Position pos) {
        this.pos = pos;
        return this;
    }

    @Override
    public boolean validate() {
        this.upgradeCurving(this.getCurving());
        boolean ret = this.pos.size() >= 2;
        return ret;
    }

    private static Position createPosition(Position.Pnt ... positions) {
        Position ret = new Position();
        for (Position.Pnt p : positions) {
            ret.add(p);
        }
        return ret;
    }

    @Override
    public Annotation createCopy() {
        Position posCopy = this.pos.createCopy();
        Line lineCopy = new Line(this.model, posCopy);
        lineCopy.curving = this.curving;
        lineCopy.addTweak(posCopy);
        lineCopy.addTweak(this.getTweakByType(Style.class).createCopy());
        lineCopy.addTweak(this.getTweakByType(ArrowHead.class).createCopy());
        return lineCopy;
    }

    private static class Pair<A, B> {
        public A a;
        public B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }
}

