/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.annotations;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import nl.rug.syntree.hierarchicalmodel.HierarchicalObject;
import nl.rug.syntree.hierarchicalmodel.annotations.Tweak;
import nl.rug.syntree.treediagram.TreeView;
import nl.rug.syntree.treediagram.drawables.DrawableObject;

public class Position
implements Tweak,
Iterable<Pnt> {
    private static final long serialVersionUID = 7277419181952172993L;
    private Pnt centpOs = null;
    private ArrayList<Pnt> simples = new ArrayList();
    private HierarchicalObject owner;

    public Position() {
        this.owner = null;
    }

    public Position(Pnt p) {
        this.simples.add(p);
        this.owner = p.target;
    }

    public Position(Pnt ... ps) {
        Collections.addAll(this.simples, ps);
        if (ps.length > 0) {
            this.owner = ps[0].target;
        }
    }

    public Position(Pnt p, HierarchicalObject o) {
        this(p, o, 0.0f, 0.0f);
    }

    public Position(Pnt p, HierarchicalObject o, float x, float y) {
        this(new Pnt(p, o, x, y));
    }

    private float[] getInnerMinMax() {
        float[] ret = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        for (Pnt pos : this.simples) {
            Point2D.Float pnt = pos.getAbs();
            ret[0] = Math.min(ret[0], pnt.x);
            ret[1] = Math.min(ret[1], pnt.y);
            ret[2] = Math.max(ret[2], pnt.x);
            ret[3] = Math.max(ret[3], pnt.y);
        }
        return ret;
    }

    private float[] getOuterMinMax(TreeView tv) {
        float[] ret = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        for (Pnt p : this.simples) {
            Point2D.Float pnt = p.getAbs(tv);
            Rectangle2D.Float bounds = null;
            if (p.target != null) {
                DrawableObject dro = tv.getDrawable(p.target);
                Rectangle2D.Float float_ = bounds = dro == null ? null : dro.getBounds();
            }
            if (bounds == null) {
                bounds = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
            }
            ret[0] = Math.min(ret[0], pnt.x - bounds.width / 2.0f);
            ret[1] = Math.min(ret[1], pnt.y - bounds.height / 2.0f);
            ret[2] = Math.max(ret[2], pnt.x + bounds.width / 2.0f);
            ret[3] = Math.max(ret[3], pnt.y + bounds.height / 2.0f);
        }
        return ret;
    }

    public Position add(int i, Pnt p) {
        this.simples.add(i, p);
        return this;
    }

    public Position add(Pnt p) {
        this.simples.add(p);
        return this;
    }

    public Point2D.Float center() {
        float[] minMax = this.getInnerMinMax();
        return new Point2D.Float(minMax[0] + (minMax[2] - minMax[0]) / 2.0f, minMax[1] + (minMax[3] - minMax[1]) / 2.0f);
    }

    public Pnt centerPos() {
        if (this.centpOs == null) {
            this.centpOs = new CenPnt(this);
        }
        return this.centpOs;
    }

    public float centerX() {
        float max = Float.NEGATIVE_INFINITY;
        float min = Float.POSITIVE_INFINITY;
        for (Pnt p : this.simples) {
            float x = p.getAbsX();
            max = Math.max(max, x);
            min = Math.min(min, x);
        }
        return min + (max - min) / 2.0f;
    }

    public float centerY() {
        float max = Float.NEGATIVE_INFINITY;
        float min = Float.POSITIVE_INFINITY;
        for (Pnt p : this.simples) {
            float y = p.getAbsY();
            max = Math.max(max, y);
            min = Math.min(min, y);
        }
        return min + (max - min) / 2.0f;
    }

    public boolean contains(Pnt p) {
        return this.simples.contains(p);
    }

    @Override
    public Position createCopy() {
        Position ret = new Position();
        for (Pnt p : this.simples) {
            ret.add(p.createCopy());
        }
        ret.owner(this.owner);
        return ret;
    }

    public Rectangle2D.Float extent(TreeView tv) {
        float[] minMax = this.getOuterMinMax(tv);
        float width = minMax[2] - minMax[0];
        float height = minMax[3] - minMax[1];
        return new Rectangle2D.Float(minMax[0], minMax[1], width, height);
    }

    public Pnt first() {
        return this.simples.size() > 0 ? this.simples.get(0) : null;
    }

    public Pnt get(int i) {
        return this.simples.get(i);
    }

    public Rectangle2D.Float intent() {
        float[] minMax = this.getInnerMinMax();
        float width = minMax[2] - minMax[0];
        float height = minMax[3] - minMax[1];
        return new Rectangle2D.Float(minMax[0], minMax[1], width, height);
    }

    @Override
    public Iterator<Pnt> iterator() {
        return this.simples.iterator();
    }

    public HierarchicalObject owner() {
        return this.owner;
    }

    public Position owner(HierarchicalObject nw) {
        this.owner = nw;
        return this;
    }

    public boolean remove(Pnt p) {
        return this.simples.remove(p);
    }

    public int size() {
        return this.simples.size();
    }

    public static class Pnt
    implements Serializable {
        private static final long serialVersionUID = 6132467482259129029L;
        public float x;
        public float y;
        private Pnt anchor;
        private HierarchicalObject target;
        private boolean primary = true;
        private boolean complete = true;

        public Pnt(Pnt a, HierarchicalObject o) {
            this(a, o, 0.0f, 0.0f);
        }

        public Pnt(Pnt a, HierarchicalObject o, float x, float y) {
            this(a, o, x, y, true);
        }

        public Pnt(Pnt a, HierarchicalObject o, float x, float y, boolean primary) {
            this.anchor = a;
            this.target = o;
            this.x = x;
            this.y = y;
            this.primary = primary;
            if (a != null) {
                this.validateDependencies(new Vector<Pnt>());
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
        }

        public Pnt anchor() {
            return this.anchor;
        }

        public Pnt anchor(Pnt an) {
            this.anchor = an;
            boolean b = this.validateDependencies(new Vector<Pnt>());
            if (!b) {
                return null;
            }
            return this;
        }

        public Position asComplex() {
            return new Position(this);
        }

        public Pnt createCopy() {
            return new Pnt(this.anchor, this.target, this.x, this.y, this.primary);
        }

        public Point2D.Float getAbs() {
            if (this.anchor == null) {
                return new Point2D.Float(this.x, this.y);
            }
            Point2D.Float ret = this.anchor.getAbs();
            ret.x += this.x;
            ret.y += this.y;
            return ret;
        }

        public float getAbsX() {
            return this.x + (this.anchor == null ? 0.0f : this.anchor.getAbsX());
        }

        public float getAbsY() {
            return this.y + (this.anchor == null ? 0.0f : this.anchor.getAbsY());
        }

        public boolean primary() {
            return this.primary;
        }

        public Pnt primary(boolean primary) {
            this.primary = primary;
            return this;
        }

        public void setIncomplete() {
            this.complete = false;
        }

        public HierarchicalObject target() {
            return this.target;
        }

        public Pnt target(HierarchicalObject o) {
            this.target = o;
            if (!this.validateDependencies(new Vector<Pnt>())) {
                return null;
            }
            return this;
        }

        public boolean validateDependencies(Vector<Pnt> visited) {
            if (visited.contains(this)) {
                return false;
            }
            visited.add(this);
            if (this.anchor != null && !this.anchor.validateDependencies(visited)) {
                this.anchor = null;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.x + "," + this.y + "," + this.anchor() + "," + this.target + "]";
        }

        public Point2D.Float getAbs(TreeView tv) {
            if (!this.complete) {
                Position drawablePosition = tv.getDrawable(this.target).getPos();
                this.anchor(drawablePosition.centerPos());
                this.complete = true;
            }
            return this.getAbs();
        }
    }

    public class CenPnt
    extends Pnt {
        private static final long serialVersionUID = -1553355731116100864L;
        private Position parent;

        public CenPnt(Position parent) {
            super(null, parent.owner);
            this.parent = parent;
        }

        @Override
        public Point2D.Float getAbs() {
            Point2D.Float ret = this.parent.center();
            return ret;
        }

        @Override
        public float getAbsX() {
            return this.parent.centerX();
        }

        @Override
        public float getAbsY() {
            return this.parent.centerY();
        }

        @Override
        public boolean validateDependencies(Vector<Pnt> visited) {
            if (visited.contains(this)) {
                return false;
            }
            visited.add(this);
            for (Pnt p : this.parent) {
                if (p.validateDependencies(visited)) continue;
                return false;
            }
            return true;
        }
    }
}

