/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.annotations;

import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.annotations.Annotation;
import nl.rug.syntree.hierarchicalmodel.annotations.Position;
import nl.rug.syntree.hierarchicalmodel.annotations.Style;

public class Strike
extends Annotation {
    private static final long serialVersionUID = 5330632417336556206L;
    private StrikeStyles style = StrikeStyles.CircledLine;
    private boolean northSouth = false;

    public Strike(HierarchicalModel model, Position pos) {
        super(model);
        this.pos = pos;
    }

    public Strike(HierarchicalModel model, Position pos, StrikeStyles style) {
        this(model, pos);
        this.style = style;
    }

    @Override
    public void delete() {
    }

    public Strike flip() {
        this.northSouth = !this.northSouth;
        return this;
    }

    public boolean northSouth() {
        return this.northSouth;
    }

    public Strike northSouth(boolean b) {
        this.northSouth = b;
        return this;
    }

    public Position pos() {
        return this.pos;
    }

    public Strike pos(Position pos) {
        this.pos = pos;
        return this;
    }

    public StrikeStyles style() {
        return this.style;
    }

    public Strike style(StrikeStyles s) {
        this.style = s;
        return this;
    }

    @Override
    public Annotation createCopy() {
        Position posCopy = this.pos.createCopy();
        Strike newStrike = new Strike(this.model, posCopy, this.style());
        newStrike.addTweak(posCopy);
        newStrike.addTweak(this.getTweakByType(Style.class));
        newStrike.northSouth = this.northSouth;
        return newStrike;
    }

    public static enum StrikeStyles {
        Line,
        DoubleLine,
        Cross,
        CircledLine;


        public String toString() {
            switch (this) {
                case CircledLine: {
                    return "circled line";
                }
                case Cross: {
                    return "cross";
                }
                case DoubleLine: {
                    return "double line";
                }
                case Line: {
                    return "single line";
                }
            }
            return "?";
        }
    }
}

