/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters;

import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.rug.syntree.hierarchicalmodel.exporters.Exportable;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.BackgroundOptionsPanel;
import nl.rug.syntree.mainview.UIUtilities;
import nl.rug.syntree.mainview.components.UIProgressStatusDialog;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.batik.dom.svg12.SVG12DOMImplementation;
import org.apache.batik.dom.svg12.SVG12OMDocument;
import org.apache.batik.swing.svg.JSVGComponent;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.Options;
import org.freehep.util.UserProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public abstract class BatikAbstractExportFileType
extends ExportFileType
implements Exportable {
    public static final float PADDING_HORIZONTAL = 2.0f;
    public static final float PADDING_VERTICAL = 2.0f;
    private static final String OPTIONS_ROOT = BatikAbstractExportFileType.class.getName();
    public static final String EMBED_FONTS = OPTIONS_ROOT + ".EmbedFonts";
    public static final String AOI_X = "size-x";
    public static final String AOI_Y = "size-y";
    public static final String AOI_WIDTH = "size-w";
    public static final String AOI_HEIGHT = "size-h";
    public static final String BACKGROUND = OPTIONS_ROOT + "." + "Background";
    public static final String BACKGROUND_COLOR = OPTIONS_ROOT + "." + "BackgroundColor";
    protected static final UserProperties defaultProperties = new UserProperties();
    protected OutputStream outputStream = null;
    protected Component source = null;
    protected Component parent = null;
    protected Properties properties = null;
    protected String creator = null;
    protected UIProgressStatusDialog progressDialog = null;

    @Override
    public void exportToFile(OutputStream os, Component theSource, Component theParent, Properties theProperties, String theCreator) throws IOException {
        this.outputStream = os;
        this.source = theSource;
        this.parent = theParent;
        this.properties = theProperties;
        this.creator = theCreator;
        this.beginExport();
        this.export();
        this.endExport();
    }

    @Override
    public void exportToFile(OutputStream os, Component[] target, Component parent, Properties properties, String creator) throws IOException {
        throw new IOException("Exporting multiple sources to a single file is not supported.");
    }

    @Override
    public void exportToFile(File file, Component[] target, Component parent, Properties properties, String creator) throws IOException {
        this.exportToFile((OutputStream)new FileOutputStream(file), target, parent, properties, creator);
    }

    @Override
    public void beginExport() {
        this.progressDialog = new UIProgressStatusDialog(this.parent, "Exporting...", "Initializing...", UIProgressStatusDialog.getIcon("Info: "), 0, 100);
        this.progressDialog.setMillisToDecideToPopup(0);
        this.progressDialog.setMillisToPopup(0);
    }

    private static Document cloneDoc(Document src) {
        SVG12DOMImplementation impl = (SVG12DOMImplementation)SVG12DOMImplementation.getDOMImplementation();
        SVG12OMDocument newDoc = (SVG12OMDocument)impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        newDoc.setIsSVG12(true);
        newDoc.removeChild(newDoc.getDocumentElement());
        Node cloned = newDoc.importNode(src.getDocumentElement(), true);
        newDoc.appendChild(cloned);
        return newDoc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void export() throws IOException {
        if (!(this.source instanceof JSVGComponent)) throw new IOException("Source cannot be exported to the " + this.getDescription() + ".\nCannot interprete source format. Source should be a JSVGComponent instance from the Apache Batik library.\nExport cannot continue.");
        JSVGComponent sourceComponent = (JSVGComponent)this.source;
        if (sourceComponent.getSVGDocument() == null) throw new IOException("Source cannot be exported to the " + this.getDescription() + ".\nCannot interprete source format. Source is a JSVGComponent instance from the Apache Batik library, but does not contain a SVGDocument instance.\nExporting cannot continue.");
        this.progressDialog.setNote("Initialising input document...");
        TranscoderInput input = new TranscoderInput(BatikAbstractExportFileType.cloneDoc(sourceComponent.getSVGDocument()));
        if (this.progressDialog.isCanceled()) {
            return;
        }
        this.progressDialog.setProgress(this.progressDialog.getProgress() + 8);
        this.progressDialog.setNote("Initialising output file...");
        TranscoderOutput output = new TranscoderOutput(this.outputStream);
        if (this.progressDialog.isCanceled()) {
            return;
        }
        this.progressDialog.setProgress(this.progressDialog.getProgress() + 8);
        this.progressDialog.setNote("Setting selected export properties...");
        SVGAbstractTranscoder transcoder = this.getBatikTranscoder();
        HashMap hints = new HashMap();
        this.setBatikTranscoderHints(this.properties, hints);
        transcoder.setTranscodingHints(hints);
        if (this.progressDialog.isCanceled()) {
            return;
        }
        this.progressDialog.setProgress(this.progressDialog.getProgress() + 10);
        this.progressDialog.setNote("Writing output file...");
        try {
            transcoder.transcode(input, output);
            this.progressDialog.setProgress(this.progressDialog.getProgress() + 40);
            if (!this.progressDialog.isCanceled()) return;
            return;
        }
        catch (Exception te) {
            te.printStackTrace();
            this.progressDialog.showException(new IOException("Error: " + te.getMessage(), te.getCause()));
        }
    }

    @Override
    public void endExport() {
        if (this.progressDialog.hasWarnings()) {
            this.progressDialog.setNote("Exporting was completed with warnings. For details see below.");
            this.progressDialog.setProgress(100);
        } else if (this.progressDialog.isCanceled()) {
            if (this.progressDialog.hasErrors()) {
                this.progressDialog.setNote("Exporting was aborted because of errors. For details see below.");
            } else {
                this.progressDialog.setNote("Exporting was aborted manually.");
            }
        } else {
            this.progressDialog.setNote("Exporting was completed succesfully.");
            this.progressDialog.setProgress(100);
        }
        if (this.progressDialog.getCloseButton() != null) {
            this.progressDialog.getCloseButton().setEnabled(true);
        }
        if (this.progressDialog.getCancelButton() != null) {
            this.progressDialog.getCancelButton().setEnabled(false);
        }
    }

    protected abstract SVGAbstractTranscoder getBatikTranscoder();

    @Override
    public boolean hasOptionPanel() {
        return true;
    }

    @Override
    public JPanel createOptionPanel(Properties theOptions) {
        UserProperties options = new UserProperties(theOptions, this.getDefaultProperties());
        OptionPanel optionsPanel = new OptionPanel();
        optionsPanel.add((Component)new BackgroundOptionsPanel(options, OPTIONS_ROOT, false), "0 0 [5 5 5 5] wt");
        optionsPanel.add("0 * wh", new JLabel());
        return optionsPanel;
    }

    @Override
    public boolean applyChangedOptions(JPanel optionPanel, Properties options) {
        boolean isSuccesful = false;
        if (optionPanel instanceof Options) {
            isSuccesful = ((Options)((Object)optionPanel)).applyChangedOptions(options);
        } else {
            Exception cause = new Exception(this.getClass() + ": applyChangedOptions(...), optionPanel argument does not implement Options interface. It is of type " + optionPanel.getClass());
            Exception e = new Exception("Error: An application error occurred while trying to apply the changed options. Options not changed. Please contact SynTree development with this message and details below.", cause);
            UIUtilities.handleException(e, this.source, null);
            System.err.println(this.getClass() + ": applyChangedOptions(...), panel does not implement Options interface.");
        }
        return isSuccesful;
    }

    public Properties getDefaultProperties() {
        return defaultProperties;
    }

    public void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public void setBatikTranscoderHints(Properties freeHEPExportOptions, Map hints) {
        String y;
        String x;
        String height;
        Properties props = this.getDefaultProperties();
        String dimensions = freeHEPExportOptions.getProperty(BatikAbstractExportFileType.class.getName() + "." + "ImageSize");
        if (dimensions != null) {
            String[] exportDimensions = dimensions.split(", ");
            hints.put(ImageTranscoder.KEY_WIDTH, Float.valueOf(Float.parseFloat(exportDimensions[0])));
            hints.put(ImageTranscoder.KEY_HEIGHT, Float.valueOf(Float.parseFloat(exportDimensions[1])));
        } else {
            UIUtilities.handleException(new Exception("Error: No image dimensions specified!\nExport aborted."), null, null);
        }
        String width = freeHEPExportOptions.getProperty(AOI_WIDTH);
        if (width == null) {
            width = props.getProperty(AOI_WIDTH);
        }
        if ((height = freeHEPExportOptions.getProperty(AOI_HEIGHT)) == null) {
            height = props.getProperty(AOI_HEIGHT);
        }
        if ((x = freeHEPExportOptions.getProperty(AOI_X)) == null) {
            x = props.getProperty(AOI_X);
        }
        if ((y = freeHEPExportOptions.getProperty(AOI_Y)) == null) {
            y = props.getProperty(AOI_Y);
        }
        hints.put(ImageTranscoder.KEY_AOI, new Rectangle2D.Double(Double.parseDouble(x), Double.parseDouble(y), Double.parseDouble(width) + 2.0, Double.parseDouble(height) + 2.0));
        boolean showBackgroundColour = false;
        String background = freeHEPExportOptions.getProperty(BACKGROUND);
        if (background != null) {
            showBackgroundColour = Boolean.parseBoolean(background);
        } else {
            background = props.getProperty(BACKGROUND);
            if (background != null) {
                showBackgroundColour = Boolean.parseBoolean(background);
            }
        }
        if (showBackgroundColour) {
            String backgroundColour = freeHEPExportOptions.getProperty(BACKGROUND_COLOR);
            if (backgroundColour != null) {
                hints.put(ImageTranscoder.KEY_BACKGROUND_COLOR, UIUtilities.parseColour(backgroundColour));
            } else {
                hints.put(ImageTranscoder.KEY_BACKGROUND_COLOR, UIUtilities.parseColour(props.getProperty(BACKGROUND_COLOR)));
            }
        }
    }

    public void setupFontEmbedding(DefaultConfiguration c, SVGDocument document) throws Exception {
    }

    public void setExportFormatFontEmbedSpecifics(DefaultConfiguration fontConfig) {
    }

    static {
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.WHITE);
    }
}

