/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import nl.rug.syntree.treediagram.TreeView;
import org.apache.batik.dom.svg12.SVG12DOMImplementation;
import org.apache.batik.dom.svg12.SVG12OMDocument;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ImageExporter {
    private static Document cloneDoc(Document src) {
        SVG12DOMImplementation impl = (SVG12DOMImplementation)SVG12DOMImplementation.getDOMImplementation();
        SVG12OMDocument newDoc = (SVG12OMDocument)impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        newDoc.setIsSVG12(true);
        newDoc.removeChild(newDoc.getDocumentElement());
        Node cloned = newDoc.importNode(src.getDocumentElement(), true);
        newDoc.appendChild(cloned);
        return newDoc;
    }

    private static void transcode(Transcoder t, TreeView tv, File file) {
        t.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(TranscoderException ex) throws TranscoderException {
                ex.printStackTrace();
            }

            @Override
            public void fatalError(TranscoderException ex) throws TranscoderException {
                ex.printStackTrace();
            }

            @Override
            public void warning(TranscoderException ex) throws TranscoderException {
                ex.printStackTrace();
            }
        });
        try {
            TranscoderInput ti = new TranscoderInput(ImageExporter.cloneDoc(tv.doc));
            FileOutputStream fos = new FileOutputStream(file);
            TranscoderOutput to = new TranscoderOutput(fos);
            t.transcode(ti, to);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void SVGtoPNG(TreeView tv, File file) {
        try {
            PNGTranscoder pt = new PNGTranscoder();
            Rectangle aoi = new Rectangle((int)tv.getCachedX(), (int)tv.getCachedY(), (int)tv.getCachedWidth(), (int)tv.getCachedHeight());
            pt.addTranscodingHint(PNGTranscoder.KEY_AOI, aoi);
            ImageExporter.transcode(pt, tv, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void SVGtoJPEG(TreeView tv, File file) {
        JPEGTranscoder jt = new JPEGTranscoder();
        Rectangle aoi = new Rectangle((int)tv.getCachedX(), (int)tv.getCachedY(), (int)tv.getCachedWidth(), (int)tv.getCachedHeight());
        jt.addTranscodingHint(JPEGTranscoder.KEY_AOI, aoi);
        ImageExporter.transcode(jt, tv, file);
    }

    public static void SVGtoPDF(TreeView tv, File file) {
        PDFTranscoder pt = new PDFTranscoder();
        Rectangle aoi = new Rectangle((int)tv.getCachedX(), (int)tv.getCachedY(), (int)tv.getCachedWidth(), (int)tv.getCachedHeight());
        pt.addTranscodingHint(PDFTranscoder.KEY_AOI, aoi);
        ImageExporter.transcode(pt, tv, file);
    }
}

