/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters;

import java.awt.Font;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.gvt.font.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.fonts.CustomFontCollection;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontAdder;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontCacheManager;
import org.apache.fop.fonts.FontCacheManagerFactory;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontDetectorFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.render.java2d.Base14FontCollection;
import org.apache.fop.render.java2d.Java2DFontMetrics;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class InstalledFontsCache {
    protected static FontInfo installedFontsCache = null;

    public static boolean isInitialised() {
        File cache = FontCache.getDefaultCacheFile(true);
        return cache.exists() && cache.length() > 0L;
    }

    public static void init() throws FOPException, URISyntaxException {
        InternalResourceResolver resolver = ResourceResolverFactory.createDefaultInternalResourceResolver(new File(".").toURI());
        FontCacheManager fontCacheManager = FontCacheManagerFactory.createDefault();
        FontManager fontManager = new FontManager(resolver, FontDetectorFactory.createDefault(), fontCacheManager);
        ArrayList<EmbedFontInfo> fontEmbedInfo = new ArrayList<EmbedFontInfo>();
        FontAdder fontAdder = new FontAdder(fontManager, resolver, null);
        fontManager.autoDetectFonts(true, fontAdder, false, null, fontEmbedInfo);
        installedFontsCache = new FontInfo();
        FontCollection[] fontCollections = new FontCollection[]{new Base14FontCollection(new Java2DFontMetrics()), new CustomFontCollection(resolver, fontEmbedInfo, true)};
        fontManager.setup(installedFontsCache, fontCollections);
        installedFontsCache.addFontProperties("F1", "SansSerif", "normal", 400);
        installedFontsCache.addFontProperties("F2", "SansSerif", "oblique", 400);
        installedFontsCache.addFontProperties("F2", "SansSerif", "italic", 400);
        installedFontsCache.addFontProperties("F3", "SansSerif", "normal", 700);
        installedFontsCache.addFontProperties("F4", "SansSerif", "oblique", 700);
        installedFontsCache.addFontProperties("F4", "SansSerif", "italic", 700);
        fontCacheManager.save();
    }

    public static Map<String, org.apache.fop.fonts.Font> getUsedAndAvailableFonts(List<Node> stylableSVGElements, Map<String, org.apache.fop.fonts.Font> replacements) throws Exception {
        if (installedFontsCache == null) {
            InstalledFontsCache.init();
        }
        org.apache.fop.fonts.Font defaultFont = null;
        HashMap<String, org.apache.fop.fonts.Font> usedAndAvailableFonts = new HashMap<String, org.apache.fop.fonts.Font>();
        for (int i = 0; i < stylableSVGElements.size(); ++i) {
            CSSValue fontPropValue;
            SVGStylableElement currentElmnt = (SVGStylableElement)stylableSVGElements.get(i);
            CSSStyleDeclaration elmntStyle = currentElmnt.getStyle();
            if (elmntStyle == null || (fontPropValue = elmntStyle.getPropertyCSSValue("font-family")) == null) continue;
            String normalizedFontName = fontPropValue.getCssText().replaceAll("\"", "");
            fontPropValue = elmntStyle.getPropertyCSSValue("font-style");
            String fontStyle = null;
            fontStyle = fontPropValue != null ? (fontPropValue.getCssText().equals("italic") ? "italic" : (fontPropValue.getCssText().equals("oblique") ? "oblique" : "normal")) : "normal";
            fontPropValue = elmntStyle.getPropertyCSSValue("font-weight");
            int fontWeight = -1;
            fontWeight = fontPropValue != null ? (fontPropValue.getCssText().equals("bold") ? 700 : (fontPropValue.getCssText().equals("bolder") ? 800 : 400)) : 400;
            FontTriplet triplet = new FontTriplet(normalizedFontName, fontStyle, fontWeight);
            org.apache.fop.fonts.Font foundFont = installedFontsCache.getFontInstanceForAWTFont(Font.decode(InstalledFontsCache.getFontNameIncludingStyle(triplet, "-")));
            FontTriplet foundTriplet = foundFont.getFontTriplet();
            if (!foundTriplet.getName().equals(org.apache.fop.fonts.Font.DEFAULT_FONT.getName())) {
                if (!usedAndAvailableFonts.containsKey(foundFont.getFontName())) {
                    usedAndAvailableFonts.put(foundFont.getFontName(), foundFont);
                }
                if (foundTriplet.getStyle().equals(triplet.getStyle()) && foundTriplet.getWeight() == triplet.getWeight()) continue;
                replacements.put(InstalledFontsCache.getFontNameIncludingStyle(triplet, " "), foundFont);
                InstalledFontsCache.replaceFontAttributeValues(elmntStyle, foundTriplet);
                continue;
            }
            if (defaultFont == null) {
                GVTFontFace defaultFontFace = FontFamilyResolver.defaultFont.getFontFace();
                FontTriplet searchedFontTriplet = new FontTriplet(defaultFontFace.getFamilyName(), defaultFontFace.getFontStyle().equals("all") ? "normal" : defaultFontFace.getFontStyle(), FontUtil.parseCSS2FontWeight(defaultFontFace.getFontWeight().equals("all") ? "normal" : defaultFontFace.getFontWeight()));
                defaultFont = installedFontsCache.getFontInstanceForAWTFont(new Font(defaultFontFace.getFamilyName(), InstalledFontsCache.getAWTFontStyle(searchedFontTriplet), Font.decode("Serif").getSize() * 1000));
                usedAndAvailableFonts.put(defaultFont.getFontName(), defaultFont);
            }
            if (replacements != null) {
                replacements.put(normalizedFontName, defaultFont);
            }
            InstalledFontsCache.replaceFontAttributeValues(elmntStyle, defaultFont.getFontTriplet());
        }
        return usedAndAvailableFonts;
    }

    public static void replaceFontAttributeValues(CSSStyleDeclaration declaration, FontTriplet replacement) {
        declaration.setProperty("font-style", replacement.getStyle(), "");
        String weight = "normal";
        if (replacement.getWeight() == 700) {
            weight = "bold";
        } else if (replacement.getWeight() == 800) {
            weight = "bolder";
        }
        declaration.setProperty("font-weight", weight, "");
        String cssText = declaration.getCssText();
        int fontFamilyIndex = cssText.indexOf("font-family:");
        if (fontFamilyIndex > -1) {
            int ffStart = fontFamilyIndex + "font-family".length() + 1;
            int ffEnd = cssText.indexOf(";", ffStart);
            cssText = cssText.substring(0, ffStart) + "'" + replacement.getName() + "'" + cssText.substring(ffEnd, cssText.length());
            cssText = cssText.replaceAll("[\\n]", "").replaceAll(" ", "");
            declaration.setCssText(cssText);
        }
    }

    public static String getFontNameIncludingStyle(FontTriplet triplet, String delimiter) {
        String name = triplet.getName();
        if (triplet.getWeight() == 700) {
            name = name + delimiter + "Bold";
        }
        if (triplet.getStyle().equals("italic")) {
            name = name + delimiter + "Italic";
        }
        if (triplet.getStyle().equals("oblique")) {
            name = name + delimiter + "Oblique";
        }
        return name;
    }

    public static int getAWTFontStyle(FontTriplet triplet) {
        int style = 0;
        if (triplet.getWeight() == 700) {
            style |= 1;
        }
        if (triplet.getStyle().equals("italic") || triplet.getStyle().equals("oblique")) {
            style |= 2;
        }
        return style;
    }
}

