/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import nl.rug.syntree.hierarchicalmodel.HierarchicalModel;
import nl.rug.syntree.hierarchicalmodel.exporters.Base64;

public class SerialExporter {
    public static void modelToFile(HierarchicalModel model, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(SerialExporter.modelToBase64(model).getBytes());
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HierarchicalModel fileToModel(File file) {
        HierarchicalModel ret = null;
        try {
            byte[] b = Files.readAllBytes(file.toPath());
            return SerialExporter.base64ToModel(b);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ret;
        }
    }

    public static String modelToBase64(HierarchicalModel model) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(model);
            oos.close();
            return Base64.encodeToString(baos.toByteArray(), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "failure";
        }
    }

    public static HierarchicalModel base64ToModel(byte[] s) {
        HierarchicalModel ret = null;
        try {
            byte[] decced = Base64.decode(s);
            if (decced == null) {
                System.out.println("Sexp: decced == null");
            }
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decced));
            ret = (HierarchicalModel)ois.readObject();
            ois.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

