/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.freehep.graphicsio;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.util.List;
import org.apache.batik.gvt.flow.FlowTextPainter;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.TextPaintInfo;

public class TextExportFlowTextPainter
extends FlowTextPainter {
    @Override
    protected void paintTextRuns(List textRuns, Graphics2D g2d) {
        for (int i = 0; i < textRuns.size(); ++i) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)textRuns.get(i);
            AttributedCharacterIterator runACI = textRun.getACI();
            runACI.first();
            TextPaintInfo tpi = (TextPaintInfo)runACI.getAttribute(PAINT_INFO);
            if (tpi != null && tpi.composite != null) {
                g2d.setComposite(tpi.composite);
            }
            if (tpi == null) {
                return;
            }
            if (!tpi.visible) {
                return;
            }
            Paint fillPaint = tpi.fillPaint;
            Stroke stroke = tpi.strokeStroke;
            Paint strokePaint = tpi.strokePaint;
            if (fillPaint == null && (strokePaint == null || stroke == null)) {
                return;
            }
            AWTGVTFont font = (AWTGVTFont)runACI.getAttribute(GVT_FONT);
            double sf = 1.0f / (48.0f / font.getSize());
            g2d.scale(sf, sf);
            g2d.setPaint(fillPaint);
            Point2D stringPos = textRun.getLayout().getGlyphVector().getGlyphPosition(0);
            g2d.drawString(runACI, (float)(stringPos.getX() / sf), (float)(stringPos.getY() / sf));
            g2d.scale(1.0 / sf, 1.0 / sf);
        }
    }
}

