/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.freehep.graphicsio.emf;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.rug.syntree.hierarchicalmodel.exporters.BatikAbstractExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.Exportable;
import nl.rug.syntree.hierarchicalmodel.exporters.freehep.graphicsio.emf.BatikEMFGraphics2D;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.BackgroundOptionsPanel;
import nl.rug.syntree.mainview.components.UIProgressStatusDialog;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.emf.EMFExportFileType;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class BatikEMFExportFileType
extends EMFExportFileType
implements Exportable {
    public static final String FILE_TYPE_DESCRIPTION = "SynTree - Windows Enhanced Metafile (EMF)";
    public static final String GRAPHICS_SCALE_FACTOR = "GraphicsScaleFactor";
    protected OutputStream outputStream = null;
    protected Component source = null;
    protected Component parent = null;
    protected Properties properties = null;
    protected String creator = null;
    protected UIProgressStatusDialog progressDialog = null;

    @Override
    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new BatikEMFGraphics2D(os, target);
    }

    @Override
    public VectorGraphics getGraphics(OutputStream os, Dimension dimension) throws IOException {
        double origWidth = (float)dimension.width + 2.0f;
        String exportDimensions = this.properties.getProperty(AbstractVectorGraphicsIO.class.getName() + "." + "ImageSize");
        double exportWidth = origWidth;
        if (exportDimensions != null) {
            String[] newDimensions = exportDimensions.split(", ");
            exportWidth = Double.parseDouble(newDimensions[0]);
        }
        double scaleX = 1.0;
        if (exportWidth != origWidth) {
            scaleX = exportWidth / origWidth;
        }
        if (scaleX != 1.0) {
            this.properties.setProperty(GRAPHICS_SCALE_FACTOR, String.valueOf(scaleX));
            dimension = new Dimension((int)(exportWidth + 2.0), (int)((double)dimension.height * scaleX + 2.0));
        }
        return new BatikEMFGraphics2D(os, dimension);
    }

    @Override
    public String getDescription() {
        return FILE_TYPE_DESCRIPTION;
    }

    @Override
    public void exportToFile(OutputStream os, Component theSource, Component theParent, Properties theProperties, String theCreator) throws IOException {
        this.outputStream = os;
        this.source = theSource;
        this.parent = theParent;
        this.properties = theProperties;
        this.creator = theCreator;
        this.beginExport();
        this.export();
        this.endExport();
    }

    @Override
    public void beginExport() {
        this.progressDialog = new UIProgressStatusDialog(this.parent, "Exporting...", "Initializing...", UIProgressStatusDialog.getIcon("Info: "), 0, 100);
        this.progressDialog.setMillisToDecideToPopup(0);
        this.progressDialog.setMillisToPopup(500);
    }

    @Override
    public void export() throws IOException {
        this.progressDialog.setNote("Writing EMF file...");
        super.exportToFile(this.outputStream, this.source, this.parent, this.properties, this.creator);
        this.progressDialog.setProgress(75);
        this.progressDialog.setNote("Writing EMF file... complete.");
    }

    @Override
    public void endExport() {
        if (this.progressDialog.hasWarnings()) {
            this.progressDialog.setNote("Exporting was completed with warnings. For details see below.");
            this.progressDialog.setProgress(100);
        } else if (this.progressDialog.isCanceled()) {
            if (this.progressDialog.hasErrors()) {
                this.progressDialog.setNote("Exporting was aborted because of errors. For details see below.");
            } else {
                this.progressDialog.setNote("Exporting was aborted manually.");
            }
        } else {
            this.progressDialog.setNote("Exporting was completed succesfully.");
            this.progressDialog.setProgress(100);
        }
        if (this.progressDialog.getCloseButton() != null) {
            this.progressDialog.getCloseButton().setEnabled(true);
        }
        if (this.progressDialog.getCancelButton() != null) {
            this.progressDialog.getCancelButton().setEnabled(false);
        }
    }

    @Override
    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, EMFGraphics2D.getDefaultProperties());
        String rootKey = EMFGraphics2D.class.getName();
        String abstractRootKey = AbstractVectorGraphicsIO.class.getName();
        OptionPanel optionsPanel = new OptionPanel();
        options.setProperty(abstractRootKey + "." + "ImageSize", options.getProperty(BatikAbstractExportFileType.class.getName() + "." + "ImageSize"));
        optionsPanel.add((Component)new JLabel("Background"), "0 0 [5 7 0 0] w");
        BackgroundOptionsPanel backgroundPanel = new BackgroundOptionsPanel(options, rootKey, true, null);
        backgroundPanel.setOpaque(false);
        optionsPanel.add((Component)backgroundPanel, "0 1 [0 5 15 0] l");
        if (abstractRootKey != null) {
            OptionCheckBox shapeCheckBox = new OptionCheckBox(options, abstractRootKey + "." + "TEXT_AS_SHAPES", "Convert characters to shapes");
            shapeCheckBox.setToolTipText("<html>Converts all text to geometric shapes (looses selectability, medium file size). Default: unchecked.</html>");
            shapeCheckBox.setOpaque(false);
            optionsPanel.add((Component)shapeCheckBox, "0 2 [0 5 0 0] l");
        }
        return optionsPanel;
    }
}

