/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.graphicsio.emf.EMFGraphics2D;

public class BatikEMFGraphics2D
extends EMFGraphics2D {
    public BatikEMFGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public BatikEMFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public BatikEMFGraphics2D(OutputStream os, Dimension size) {
        super(os, size);
        this.setDeviceIndependent(true);
    }

    public BatikEMFGraphics2D(OutputStream os, Component component) {
        super(os, component);
        this.setDeviceIndependent(true);
    }

    @Override
    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        if (xform == null) {
            xform = new AffineTransform();
        }
        super.writeImage(image, xform, bkg);
    }

    @Override
    public void writeString(String string, double x, double y) throws IOException {
        Font oldFont = this.getFont();
        Hashtable<AttributedCharacterIterator.Attribute, Object> attributes = FontUtilities.getAttributes(oldFont);
        AffineTransform curTrans = this.getTransform();
        float fontSize = (float)((double)oldFont.getSize2D() / curTrans.getScaleX() - curTrans.getScaleX() / 10.0);
        String scaleFactor = this.getProperty("GraphicsScaleFactor");
        if (scaleFactor != null) {
            fontSize = (float)((double)fontSize * Double.parseDouble(scaleFactor));
        }
        attributes.put(TextAttribute.SIZE, Float.valueOf(fontSize));
        Font scaledFont = new Font(attributes);
        this.setFont(scaledFont);
        super.writeString(string, x, y);
        this.setFont(oldFont);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (this.isProperty(TEXT_AS_SHAPES)) {
            TextLayout tl = new TextLayout(iterator, this.getFontRenderContext());
            tl.draw(this, x, y);
        } else {
            Font font = this.getFont();
            Map<AttributedCharacterIterator.Attribute, Object> attributes = FontUtilities.getAttributes(font);
            StringBuffer sb = new StringBuffer();
            char c = iterator.first();
            while (c != '\uffff') {
                Object unEqualAttrib;
                HashMap<AttributedCharacterIterator.Attribute, Object> theAttribs = new HashMap<AttributedCharacterIterator.Attribute, Object>(attributes);
                theAttribs.keySet().removeAll(iterator.getAttributes().keySet());
                boolean areEqual = attributes.equals(iterator.getAttributes());
                boolean isUnEqualAttribIgnorable = false;
                if (!areEqual && theAttribs.size() == 1 && (unEqualAttrib = theAttribs.keySet().toArray()[0]) instanceof AttributedCharacterIterator.Attribute) {
                    AttributedCharacterIterator.Attribute attrib = (AttributedCharacterIterator.Attribute)unEqualAttrib;
                    isUnEqualAttribIgnorable = attrib.equals(GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS);
                }
                if (areEqual || !areEqual && isUnEqualAttribIgnorable) {
                    sb.append(c);
                } else {
                    if (sb.length() > 0) {
                        this.drawString(sb.toString(), x, y);
                        TextLayout tl = new TextLayout(sb.toString(), attributes, this.getFontRenderContext());
                        x += Math.max(tl.getAdvance(), (float)tl.getBounds().getWidth());
                    }
                    sb = new StringBuffer();
                    sb.append(c);
                    attributes = iterator.getAttributes();
                    HashMap<AttributedCharacterIterator.Attribute, Object> newAttribs = new HashMap<AttributedCharacterIterator.Attribute, Object>(attributes);
                    AWTGVTFont gvtFont = (AWTGVTFont)newAttribs.get(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT);
                    if (gvtFont != null) {
                        newAttribs.put(TextAttribute.FAMILY, gvtFont.getFamilyName());
                        newAttribs.put(TextAttribute.SIZE, Float.valueOf(gvtFont.getSize()));
                    }
                    Font newFont = new Font(newAttribs);
                    this.setFont(newFont);
                }
                c = iterator.next();
            }
            if (sb.length() > 0) {
                this.drawString(sb.toString(), x, y);
            }
            this.setFont(font);
        }
    }
}

