/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.rastergraphics;

import java.awt.Component;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.text.NumberFormatter;
import nl.rug.syntree.hierarchicalmodel.exporters.BatikAbstractExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.OptionJSlider;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.OptionJSpinner;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.SliderPanel;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class BatikJPEGExportFileType
extends BatikAbstractExportFileType {
    public static final String FILE_TYPE_DESCRIPTION = "SynTree - Joint Photographic Experts Group (JPG)";
    private static final String OPTIONS_ROOT = BatikJPEGExportFileType.class.getName();
    public static final String JPEG_QUALITY = OPTIONS_ROOT + ".JPEGQuality";
    protected static final UserProperties defaultProperties = new UserProperties();

    @Override
    public String getDescription() {
        return FILE_TYPE_DESCRIPTION;
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"jpg"};
    }

    @Override
    public String[] getMIMETypes() {
        return new String[]{"image/jpeg"};
    }

    @Override
    protected SVGAbstractTranscoder getBatikTranscoder() {
        return new JPEGTranscoder();
    }

    @Override
    public JPanel createOptionPanel(Properties theOptions) {
        UserProperties options = new UserProperties(theOptions, this.getDefaultProperties());
        OptionPanel optionsPanel = new OptionPanel();
        optionsPanel.add((Component)new JLabel("JPG quality"), "0 2 1 1 [0 7 0 0] w");
        SliderPanel sliderPanel = new SliderPanel(options, JPEG_QUALITY, null);
        sliderPanel.setOpaque(false);
        OptionJSlider slider = sliderPanel.getSlider();
        slider.setMajorTickSpacing(25);
        slider.setMinorTickSpacing(5);
        slider.setPaintTicks(true);
        slider.setLabelTable(slider.createStandardLabels(25));
        slider.setPaintLabels(true);
        String toolTipText = "Higher quality gives better image, lower quality gives smaller file size.";
        slider.setToolTipText(toolTipText);
        slider.setOpaque(false);
        OptionJSpinner spinner = sliderPanel.getSpinner();
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner);
        ((NumberFormatter)editor.getTextField().getFormatter()).setAllowsInvalid(false);
        spinner.setEditor(editor);
        spinner.setToolTipText(toolTipText);
        spinner.setOpaque(false);
        optionsPanel.add((Component)sliderPanel, "0 3 1 1 [0 7 5 5] l");
        return optionsPanel;
    }

    @Override
    public void setBatikTranscoderHints(Properties freeHEPExportOptions, Map hints) {
        super.setBatikTranscoderHints(freeHEPExportOptions, hints);
        Properties props = this.getDefaultProperties();
        float qualityFactor = -1.0f;
        String quality = freeHEPExportOptions.getProperty(JPEG_QUALITY);
        qualityFactor = quality != null ? Float.parseFloat(quality) * 0.01f : Float.parseFloat(props.getProperty(JPEG_QUALITY));
        if (qualityFactor == 0.0f) {
            qualityFactor = 0.1f;
        }
        hints.put(JPEGTranscoder.KEY_QUALITY, Float.valueOf(qualityFactor));
    }

    @Override
    public Properties getDefaultProperties() {
        UserProperties props = new UserProperties(defaultProperties, super.getDefaultProperties());
        return props;
    }

    @Override
    public void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    static {
        defaultProperties.setProperty(BACKGROUND, true);
        defaultProperties.setProperty(JPEG_QUALITY, 0.8f);
    }
}

