/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.rastergraphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import nl.rug.syntree.hierarchicalmodel.exporters.BatikAbstractExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.BackgroundOptionsPanel;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.OptionJSpinner;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class BatikPNGExportFileType
extends BatikAbstractExportFileType {
    public static final String FILE_TYPE_DESCRIPTION = "SynTree - Portable Networks Group (PNG)";
    public static final Map<Integer, String> IMAGE_BIT_DEPTHS = new HashMap<Integer, String>();
    private static final String OPTIONS_ROOT;
    public static final String PNG_TRANSPARENT_BACKGROUND;
    public static final String PNG_COLOUR_BIT_DEPTH;
    public static final String APPLY_PNG_GAMMA_CORRECTION;
    public static final String PNG_GAMMA_CORRECTION;
    protected static final UserProperties defaultProperties;

    @Override
    public String getDescription() {
        return FILE_TYPE_DESCRIPTION;
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"png"};
    }

    @Override
    public String[] getMIMETypes() {
        return new String[]{"image/png"};
    }

    @Override
    protected SVGAbstractTranscoder getBatikTranscoder() {
        return new PNGTranscoder();
    }

    @Override
    public JPanel createOptionPanel(Properties theOptions) {
        UserProperties options = new UserProperties(theOptions, this.getDefaultProperties());
        OptionPanel optionsPanel = new OptionPanel();
        final BackgroundOptionsPanel backgrOptions = new BackgroundOptionsPanel(options, BatikAbstractExportFileType.class.getName(), true, null);
        backgrOptions.setOpaque(false);
        Object[] bitDepthKeys = new Integer[IMAGE_BIT_DEPTHS.size()];
        IMAGE_BIT_DEPTHS.keySet().toArray(bitDepthKeys);
        Arrays.sort(bitDepthKeys);
        String[] bitDepthValues = new String[IMAGE_BIT_DEPTHS.size()];
        for (int i = 0; i < bitDepthKeys.length; ++i) {
            bitDepthValues[i] = IMAGE_BIT_DEPTHS.get(bitDepthKeys[i]);
        }
        OptionComboBox bitDepthSelector = new OptionComboBox(options, PNG_COLOUR_BIT_DEPTH, bitDepthValues);
        bitDepthSelector.setToolTipText("<html>Select the number of colours here.<br>Default: " + IMAGE_BIT_DEPTHS.get(bitDepthKeys[bitDepthKeys.length - 1]) + "</html>");
        bitDepthSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OptionComboBox comboBox = (OptionComboBox)e.getSource();
                if (comboBox.getSelectedItem().equals(IMAGE_BIT_DEPTHS.get(new Integer(24)))) {
                    backgrOptions.getTransparentRadio().setEnabled(true);
                    backgrOptions.getTransparentRadio().setSelected(true);
                    backgrOptions.getBackgroundRadio().setEnabled(false);
                } else {
                    backgrOptions.getTransparentRadio().setEnabled(false);
                    backgrOptions.getTransparentRadio().setSelected(false);
                    backgrOptions.getBackgroundRadio().setEnabled(true);
                }
            }
        });
        String selectedBitDepth = options.getProperty(PNG_COLOUR_BIT_DEPTH);
        if (selectedBitDepth != null && !selectedBitDepth.equals(IMAGE_BIT_DEPTHS.get(new Integer(24)))) {
            backgrOptions.getTransparentRadio().setEnabled(false);
            backgrOptions.getBackgroundRadio().setEnabled(true);
        }
        optionsPanel.add((Component)bitDepthSelector, "0 2 2 1 [0 5 15 5] w");
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(Double.parseDouble(options.getProperty(PNG_GAMMA_CORRECTION)), -25.0, 25.0, 0.01);
        OptionJSpinner spinner = new OptionJSpinner(PNG_GAMMA_CORRECTION, spinnerModel);
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
        editor.getTextField().setColumns(4);
        editor.getTextField().setHorizontalAlignment(0);
        OptionJSpinner gammaCorrection = new OptionJSpinner(PNG_GAMMA_CORRECTION, spinnerModel);
        gammaCorrection.setToolTipText("<html>Amount of gamma correction: values below 1.0 make the image appear darker, above 1 brighter.</html>");
        OptionCheckBox applyGammaCorrection = new OptionCheckBox(theOptions, APPLY_PNG_GAMMA_CORRECTION, "Apply gamma correction:");
        applyGammaCorrection.enables(gammaCorrection);
        applyGammaCorrection.setToolTipText("Enable / disable the application of gamma correction.");
        applyGammaCorrection.setOpaque(false);
        optionsPanel.add((Component)applyGammaCorrection, "0 3 1 1 [0 5 5 0] l");
        optionsPanel.add((Component)gammaCorrection, "1 3 1 1 [0 0 5 5] l");
        return optionsPanel;
    }

    @Override
    public void setBatikTranscoderHints(Properties freeHEPExportOptions, Map hints) {
        String bitDepthDescr;
        boolean shouldBeTransparent;
        super.setBatikTranscoderHints(freeHEPExportOptions, hints);
        Properties props = this.getDefaultProperties();
        String transparency = freeHEPExportOptions.getProperty(PNG_TRANSPARENT_BACKGROUND);
        if (transparency == null) {
            transparency = props.getProperty(PNG_TRANSPARENT_BACKGROUND);
        }
        if (!(shouldBeTransparent = Boolean.parseBoolean(transparency))) {
            String backgrColour = freeHEPExportOptions.getProperty(BACKGROUND_COLOR);
            if (backgrColour == null) {
                backgrColour = props.getProperty(BACKGROUND_COLOR);
            }
            String[] splitCode = backgrColour.split(", ");
            Color color = new Color(Integer.parseInt(splitCode[0]), Integer.parseInt(splitCode[1]), Integer.parseInt(splitCode[2]), Integer.parseInt(splitCode[3]));
            hints.put(ImageTranscoder.KEY_BACKGROUND_COLOR, color);
        } else {
            hints.remove(ImageTranscoder.KEY_BACKGROUND_COLOR);
        }
        boolean applyGamma = false;
        String applyGammaDescr = freeHEPExportOptions.getProperty(APPLY_PNG_GAMMA_CORRECTION);
        applyGamma = applyGammaDescr != null ? Boolean.parseBoolean(applyGammaDescr) : Boolean.parseBoolean(props.getProperty(APPLY_PNG_GAMMA_CORRECTION));
        if (applyGamma) {
            String gammaCorrectionFactor = freeHEPExportOptions.getProperty(PNG_GAMMA_CORRECTION);
            if (gammaCorrectionFactor == null) {
                gammaCorrectionFactor = props.getProperty(PNG_GAMMA_CORRECTION);
            }
            hints.put(PNGTranscoder.KEY_GAMMA, Float.valueOf(gammaCorrectionFactor));
        }
        if ((bitDepthDescr = freeHEPExportOptions.getProperty(PNG_COLOUR_BIT_DEPTH)) == null) {
            bitDepthDescr = props.getProperty(PNG_COLOUR_BIT_DEPTH);
        }
        Integer theBitDepth = null;
        for (Integer bitDepth : IMAGE_BIT_DEPTHS.keySet()) {
            if (!bitDepthDescr.equals(IMAGE_BIT_DEPTHS.get(bitDepth))) continue;
            theBitDepth = bitDepth;
            break;
        }
        hints.put(PNGTranscoder.KEY_INDEXED, theBitDepth);
    }

    @Override
    public Properties getDefaultProperties() {
        UserProperties props = new UserProperties(defaultProperties, super.getDefaultProperties());
        return props;
    }

    @Override
    public void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    static {
        IMAGE_BIT_DEPTHS.put(new Integer(1), "Monochrome (2 colours, 1 bit)");
        IMAGE_BIT_DEPTHS.put(new Integer(2), "Minimal colours (4 colours, 2 bits)");
        IMAGE_BIT_DEPTHS.put(new Integer(4), "Basic colours (16 colours, 4 bits)");
        IMAGE_BIT_DEPTHS.put(new Integer(8), "Full colours (256 colours, 8 bits)");
        IMAGE_BIT_DEPTHS.put(new Integer(24), "True colours (16 million colours, 24 bits)");
        OPTIONS_ROOT = BatikPNGExportFileType.class.getName();
        PNG_TRANSPARENT_BACKGROUND = BatikAbstractExportFileType.class.getName() + "." + "Transparent";
        PNG_COLOUR_BIT_DEPTH = OPTIONS_ROOT + ".PNGColourBitDepth";
        APPLY_PNG_GAMMA_CORRECTION = OPTIONS_ROOT + ".ApplyPNGGammaCorrection";
        PNG_GAMMA_CORRECTION = OPTIONS_ROOT + ".PNGGammaCorrection";
        defaultProperties = new UserProperties();
        defaultProperties.setProperty(PNG_TRANSPARENT_BACKGROUND, false);
        defaultProperties.setProperty(PNG_COLOUR_BIT_DEPTH, "True colours (16 million colours, 24 bits)");
        defaultProperties.setProperty(APPLY_PNG_GAMMA_CORRECTION, false);
        defaultProperties.setProperty(PNG_GAMMA_CORRECTION, 1.0f);
    }
}

