/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.rastergraphics;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.rug.syntree.hierarchicalmodel.exporters.BatikAbstractExportFileType;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.BackgroundOptionsPanel;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class BatikTIFFExportFileType
extends BatikAbstractExportFileType {
    public static final String FILE_TYPE_DESCRIPTION = "SynTree - Tagged Image File Format (TIFF)";
    public static final Map<String, String> COMPRESSION_OPTIONS = new HashMap<String, String>();
    private static final String OPTIONS_ROOT;
    public static final String TIFF_TRANSPARENT_BACKGROUND;
    public static final String TIFF_COMPRESSION_METHOD;
    protected static final UserProperties defaultProperties;

    @Override
    public String getDescription() {
        return FILE_TYPE_DESCRIPTION;
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"tiff"};
    }

    @Override
    public String[] getMIMETypes() {
        return new String[]{"image/tiff"};
    }

    @Override
    protected SVGAbstractTranscoder getBatikTranscoder() {
        return new TIFFTranscoder();
    }

    @Override
    public JPanel createOptionPanel(Properties theOptions) {
        UserProperties options = new UserProperties(theOptions, this.getDefaultProperties());
        OptionPanel optionsPanel = new OptionPanel();
        BackgroundOptionsPanel backgrOptions = new BackgroundOptionsPanel(options, BatikAbstractExportFileType.class.getName(), true, null);
        backgrOptions.setOpaque(false);
        optionsPanel.add((Component)new JLabel("Background"), "0 0 [5 7 0 0] w");
        optionsPanel.add((Component)backgrOptions, "0 1 [5 5 15 0] l");
        String[] compressOptions = new String[COMPRESSION_OPTIONS.size()];
        COMPRESSION_OPTIONS.keySet().toArray(compressOptions);
        OptionComboBox compressionSelector = new OptionComboBox(options, TIFF_COMPRESSION_METHOD, compressOptions);
        optionsPanel.add((Component)new JLabel("Compression algorithm"), "0 2 [0 7 5 0] w");
        optionsPanel.add((Component)compressionSelector, "0 3 [0 7 5 5] l");
        optionsPanel.add("0 * wh", new JLabel());
        return optionsPanel;
    }

    @Override
    public void setBatikTranscoderHints(Properties freeHEPExportOptions, Map hints) {
        boolean shouldBeTransparent;
        super.setBatikTranscoderHints(freeHEPExportOptions, hints);
        Properties props = this.getDefaultProperties();
        String transparency = freeHEPExportOptions.getProperty(TIFF_TRANSPARENT_BACKGROUND);
        if (transparency == null) {
            transparency = props.getProperty(TIFF_TRANSPARENT_BACKGROUND);
        }
        if (!(shouldBeTransparent = Boolean.parseBoolean(transparency))) {
            String backgrColour = freeHEPExportOptions.getProperty(BACKGROUND_COLOR);
            if (backgrColour == null) {
                backgrColour = props.getProperty(BACKGROUND_COLOR);
            }
            String[] splitCode = backgrColour.split(", ");
            Color color = new Color(Integer.parseInt(splitCode[0]), Integer.parseInt(splitCode[1]), Integer.parseInt(splitCode[2]), Integer.parseInt(splitCode[3]));
            hints.put(ImageTranscoder.KEY_BACKGROUND_COLOR, color);
        } else {
            hints.remove(ImageTranscoder.KEY_BACKGROUND_COLOR);
        }
        String compressOption = freeHEPExportOptions.getProperty(TIFF_COMPRESSION_METHOD);
        if (compressOption == null) {
            compressOption = defaultProperties.getProperty(TIFF_COMPRESSION_METHOD);
        }
        hints.put(TIFFTranscoder.KEY_COMPRESSION_METHOD, COMPRESSION_OPTIONS.get(compressOption));
    }

    @Override
    public Properties getDefaultProperties() {
        UserProperties props = new UserProperties(defaultProperties, super.getDefaultProperties());
        return props;
    }

    @Override
    public void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    static {
        COMPRESSION_OPTIONS.put("No compression", "none");
        COMPRESSION_OPTIONS.put("Packbits", "packbits");
        COMPRESSION_OPTIONS.put("Deflate", "deflate");
        OPTIONS_ROOT = BatikTIFFExportFileType.class.getName();
        TIFF_TRANSPARENT_BACKGROUND = BatikAbstractExportFileType.class.getName() + "." + "Transparent";
        TIFF_COMPRESSION_METHOD = OPTIONS_ROOT + ".TIFFCompressionMethod";
        defaultProperties = new UserProperties();
        defaultProperties.setProperty(TIFF_TRANSPARENT_BACKGROUND, true);
        defaultProperties.setProperty(TIFF_COMPRESSION_METHOD, "No compression");
    }
}

