/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.OptionJRadioButton;
import org.freehep.graphicsio.exportchooser.OptionButton;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.swing.layout.TableLayout;
import org.freehep.util.UserProperties;

public class BackgroundOptionsPanel
extends OptionPanel {
    protected Color initialBackground = null;
    protected Color imageBackground = null;
    protected JColorChooser colourChooser = null;
    protected OptionButton colourButton = null;
    protected JPanel colourPreview = null;
    protected String key = null;
    protected OptionJRadioButton backgroundRadio = null;
    protected OptionJRadioButton transparentRadio = null;

    public BackgroundOptionsPanel(Properties options, String rootKey, boolean hasTransparency) {
        this(options, rootKey, hasTransparency, "Background options");
    }

    public BackgroundOptionsPanel(Properties options, String rootKey, boolean hasTransparency, String title) {
        super(title);
        this.key = rootKey + "." + "BackgroundColor";
        UserProperties user = new UserProperties(options);
        this.initialBackground = user.getPropertyColor(this.key);
        if (this.initialBackground == null) {
            this.initialBackground = Color.WHITE;
        }
        this.imageBackground = this.initialBackground;
        ButtonGroup radioGroup = new ButtonGroup();
        String backgrKey = rootKey + "." + "Background";
        this.backgroundRadio = new OptionJRadioButton(backgrKey, "Opaque", (boolean)new Boolean(options.getProperty(backgrKey, "false")));
        this.backgroundRadio.setOpaque(false);
        radioGroup.add(this.backgroundRadio);
        this.colourChooser = new JColorChooser(this.initialBackground);
        JDialog dialog = JColorChooser.createDialog(this, "Choose Background Color", true, this.colourChooser, new ChangeColorListener(), null);
        this.colourButton = new OptionButton(options, rootKey, "Select Colour", dialog);
        this.colourButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BackgroundOptionsPanel.this.backgroundRadio.setSelected(true);
            }
        });
        this.colourPreview = new JPanel(null);
        this.colourPreview.setOpaque(true);
        this.colourPreview.setPreferredSize(new Dimension(28, 28));
        this.colourPreview.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel colourSelector = new JPanel(){

            @Override
            public void setEnabled(boolean isEnabled) {
                super.setEnabled(isEnabled);
                Component[] children = this.getComponents();
                for (int i = 0; i < children.length; ++i) {
                    children[i].setEnabled(isEnabled);
                }
            }
        };
        colourSelector.setLayout(new TableLayout());
        colourSelector.setBorder(BorderFactory.createEmptyBorder());
        colourSelector.setOpaque(false);
        colourSelector.add((Component)this.colourButton, "0 * [0 0 0 3] l");
        colourSelector.add((Component)this.colourPreview, "1 * [0 0 0 0] l");
        String transpKey = rootKey + "." + "Transparent";
        this.transparentRadio = new OptionJRadioButton(transpKey, "Transparent", (boolean)new Boolean(options.getProperty(transpKey, "false")));
        this.transparentRadio.setOpaque(false);
        radioGroup.add(this.transparentRadio);
        this.add((Component)this.transparentRadio, "0 0 [0 0 0 2] l");
        if (!hasTransparency) {
            this.transparentRadio.setEnabled(false);
        }
        this.add((Component)this.backgroundRadio, "0 1 [0 0 0 0] l");
        this.add((Component)colourSelector, "1 1 [0 0 0 0] l");
        new ChangeColorListener().actionPerformed(null);
    }

    @Override
    public boolean applyChangedOptions(Properties options) {
        boolean changed = super.applyChangedOptions(options);
        if (!this.imageBackground.equals(this.initialBackground)) {
            UserProperties.setProperty(options, this.key, this.imageBackground);
            changed = true;
        }
        return changed;
    }

    public Color getInitialBackground() {
        return this.initialBackground;
    }

    public Color getImageBackground() {
        return this.imageBackground;
    }

    public void setImageBackground(Color background) {
        this.imageBackground = background;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String theKey) {
        this.key = theKey;
    }

    public OptionJRadioButton getBackgroundRadio() {
        return this.backgroundRadio;
    }

    public OptionJRadioButton getTransparentRadio() {
        return this.transparentRadio;
    }

    protected class ChangeColorListener
    implements ActionListener {
        protected ChangeColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            BackgroundOptionsPanel.this.imageBackground = BackgroundOptionsPanel.this.colourChooser.getColor();
            BackgroundOptionsPanel.this.colourPreview.setBackground(BackgroundOptionsPanel.this.imageBackground);
        }
    }
}

