/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.OptionScrollPane;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.graphicsio.exportchooser.OptionPanel;

public class ExportPresetOptionsPanel
extends OptionPanel {
    protected String rootKey = null;
    protected JComboBox exportPreset = null;
    protected OptionPanel viewport = null;
    protected JComboBox type = null;
    protected static Vector list = null;
    protected Properties props = null;
    protected OptionPanel imageSettings = null;
    protected OptionScrollPane scrollPane = null;
    private boolean selectionMemory = false;

    public ExportPresetOptionsPanel(Properties options, String rootKey) {
        this(options, rootKey, "");
    }

    public ExportPresetOptionsPanel(Properties options, String rootKey, String title) {
        super(title);
        this.props = options;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.initComponent();
    }

    protected void initComponent() {
        this.exportPreset = new JComboBox<String>(new String[]{Presets.PDF_LATEX.getName(), Presets.EPS_LATEX.getName(), Presets.IMAGE.getName(), Presets.CUSTOM_SETTING.getName()});
        this.exportPreset.setOpaque(false);
        OptionPanel presetPanel = new OptionPanel(null);
        presetPanel.add((Component)new JLabel("Recommended settings for:"), "0 * [12 0 2 0] l");
        presetPanel.add((Component)this.exportPreset, "0 1 1 1 [0 0 10 0] w");
        this.add((Component)presetPanel, "0 0 1 1 [0 0 0 0] w");
        this.viewport = new OptionPanel(null);
        this.viewport.setOpaque(false);
        this.viewport.add((Component)new JLabel("Advanced settings"), "0 0 1 1 [0 5 10 0] l");
        list = new Vector();
        this.type = new JComboBox(list);
        this.type.setMaximumRowCount(16);
        ListCellRenderer renderer = this.type.getRenderer();
        this.type.setRenderer(new SaveAsRenderer(renderer));
        this.type.setOpaque(false);
        OptionPanel typePanel = new OptionPanel("Image type");
        typePanel.setOpaque(false);
        typePanel.add("0 0 1 1 [2 2 2 2] w", this.type);
        this.viewport.add((Component)typePanel, "0 1 1 1 [0 5 0 10] w");
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        this.viewport.add((Component)filler, "0 3 1 1 [0 0 0 0] {0.0, 1.0} wh");
        this.scrollPane = new OptionScrollPane(this.viewport);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setOpaque(false);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                Component source = ce.getComponent();
                if (!source.isMinimumSizeSet()) {
                    source.setMinimumSize(source.getPreferredSize());
                }
            }
        });
        this.add((Component)this.scrollPane, "0 1 1 1 [5 5 5 0] wh");
    }

    public void showExportPresetOptionsPanel() {
        this.exportPreset.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Presets preset;
                ExportFileType exportAs;
                if (e.getStateChange() == 1 && (exportAs = Presets.getExportFileType((preset = Presets.getPresetByName((String)e.getItem())).getDescription())) != null) {
                    ItemListener[] listeners;
                    int index = -1;
                    for (int i = 0; i < ExportPresetOptionsPanel.this.type.getItemCount() && index == -1; ++i) {
                        ExportFileType fileType;
                        if (!(ExportPresetOptionsPanel.this.type.getItemAt(i) instanceof ExportFileType) || !(fileType = (ExportFileType)ExportPresetOptionsPanel.this.type.getItemAt(i)).getDescription().equals(exportAs.getDescription())) continue;
                        index = i;
                    }
                    for (ItemListener listener : listeners = ExportPresetOptionsPanel.this.type.getItemListeners()) {
                        ExportPresetOptionsPanel.this.type.removeItemListener(listener);
                    }
                    ExportPresetOptionsPanel.this.type.setSelectedIndex(index);
                    for (ItemListener listener : listeners) {
                        ExportPresetOptionsPanel.this.type.addItemListener(listener);
                    }
                    ExportPresetOptionsPanel.this.setSettingsOfExportType(exportAs);
                }
            }
        });
        this.type.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ItemListener[] listeners;
                    Presets[] values = Presets.values();
                    int index = -1;
                    for (int i = 0; i < values.length && index == -1; ++i) {
                        if (!values[i].getName().equals(Presets.CUSTOM_SETTING.getName())) continue;
                        index = i;
                    }
                    for (ItemListener listener : listeners = ExportPresetOptionsPanel.this.exportPreset.getItemListeners()) {
                        ExportPresetOptionsPanel.this.exportPreset.removeItemListener(listener);
                    }
                    ExportPresetOptionsPanel.this.exportPreset.setSelectedIndex(index);
                    for (ItemListener listener : listeners) {
                        ExportPresetOptionsPanel.this.exportPreset.addItemListener(listener);
                    }
                    ExportPresetOptionsPanel.this.setSettingsOfExportType(e.getItem());
                }
            }
        });
        if (!this.selectionMemory) {
            this.exportPreset.setSelectedItem(Presets.IMAGE.getName());
            this.selectionMemory = true;
        }
    }

    public void setSettingsOfExportType(Object selectedExportType) {
        if (this.imageSettings != null) {
            this.viewport.remove(this.imageSettings);
        }
        if (selectedExportType instanceof ExportFileType) {
            ExportFileType selectedType = (ExportFileType)this.getSelectedExportFileType();
            if (selectedType.hasOptionPanel()) {
                this.imageSettings = (OptionPanel)selectedType.createOptionPanel(this.props);
                this.imageSettings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Image settings"));
                this.imageSettings.setOpaque(false);
            } else {
                this.imageSettings = new OptionPanel();
                this.imageSettings.setOpaque(false);
                this.imageSettings.add(new JLabel("No settings for selected image type"));
            }
        } else if (selectedExportType instanceof JLabel) {
            this.imageSettings = new OptionPanel();
            this.imageSettings.setOpaque(false);
            this.imageSettings.add(new JLabel("Please select an image format for this category"));
        } else {
            this.imageSettings = new OptionPanel();
            JTextArea error = new JTextArea("Error: Selected image type not recognised. Cannot display corresponding settings.\n Underlying object type is '" + selectedExportType.getClass().getName() + "' but should be of '" + ExportFileType.class.getName());
            error.setLineWrap(true);
            error.setWrapStyleWord(true);
            error.setForeground(Color.red);
            this.imageSettings.add(error);
        }
        this.viewport.add((Component)this.imageSettings, "0 2 1 1 [10 5 0 10] w");
        this.viewport.revalidate();
    }

    public Object getSelectedExportFileType() {
        return this.type.getSelectedItem();
    }

    public void setSelectedExportFileType(ExportFileType newType) {
        this.type.setSelectedItem(newType);
    }

    public Vector getExportFileTypeList() {
        return list;
    }

    private static class SaveAsRenderer
    implements ListCellRenderer {
        protected ListCellRenderer defaultRenderer = null;

        public SaveAsRenderer(ListCellRenderer renderer) {
            this.defaultRenderer = renderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel component = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof ExportFileType) {
                component.setText(((ExportFileType)value).getFileFilter().getDescription());
            } else if (value instanceof JLabel) {
                return (Component)value;
            }
            return component;
        }
    }

    public static enum Presets {
        EPS_LATEX("(EPS)Latex", "SynTree - Encapsulated PostScript (EPS)"),
        PDF_LATEX("PDFLatex", "SynTree - Portable Document Format (PDF)"),
        IMAGE("Image", "SynTree - Portable Networks Group (PNG)"),
        CUSTOM_SETTING("Custom setting", null);

        protected String name = null;
        protected String description = null;

        private Presets(String theName, String theDescription) {
            this.name = theName;
            this.description = theDescription;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public static Presets getPresetByName(String theName) {
            Presets preset = null;
            if (theName.equals(EPS_LATEX.getName())) {
                preset = EPS_LATEX;
            } else if (theName.equals(PDF_LATEX.getName())) {
                preset = PDF_LATEX;
            } else if (theName.equals(IMAGE.getName())) {
                preset = IMAGE;
            } else if (theName.equals(CUSTOM_SETTING.getName())) {
                preset = CUSTOM_SETTING;
            }
            return preset;
        }

        public static ExportFileType getExportFileType(String description) {
            ExportFileType fileType = null;
            boolean hasFound = false;
            for (int i = 0; i < list.size() && !hasFound; ++i) {
                ExportFileType saveAs;
                Object obj = list.elementAt(i);
                if (!(obj instanceof ExportFileType) || !(saveAs = (ExportFileType)obj).getDescription().equals(description)) continue;
                fileType = saveAs;
                hasFound = true;
            }
            return fileType;
        }
    }
}

