/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.OptionJSpinner;
import nl.rug.syntree.mainview.components.UIIcons;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class ImageSizeUnitsPanel
extends OptionPanel {
    protected String key;
    protected Dimension initialDimension;
    protected OptionJSpinner imageWidthPixels = null;
    protected OptionJSpinner imageHeightPixels = null;
    protected JSpinner imageWidthPercentage = null;
    protected JSpinner imageHeightPercentage = null;
    protected JSpinner imageWidthCentimeters = null;
    protected JSpinner imageHeightCentimeters = null;
    protected JToggleButton lockButton = null;
    protected boolean isAspectRatioLocked = false;
    protected Properties properties = null;

    public ImageSizeUnitsPanel(Properties user, String rootKey, boolean isLocked, int dotsPerInch) {
        super("Image Size");
        this.properties = user;
        this.key = rootKey + "." + "ImageSize";
        this.isAspectRatioLocked = isLocked;
        UserProperties options = new UserProperties(user);
        this.initialDimension = options.getPropertyDimension(this.key);
        this.add((Component)new JLabel("Width:"), "0 0 1 1 [0 7 0 0] {0.0, 0.0} l");
        this.imageWidthPixels = new OptionJSpinner(this.key + ".Width", new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.imageWidthPixels);
        JFormattedTextField textField = editor.getTextField();
        textField.setColumns(4);
        ((NumberFormatter)textField.getFormatter()).setAllowsInvalid(false);
        this.imageWidthPixels.addChangeListener(new ImageSizeFieldChangeListener(2.54, dotsPerInch));
        this.imageWidthPixels.setEditor(editor);
        this.imageWidthPixels.setToolTipText("Increases / decreases width in pixels per 1px");
        this.add((Component)this.imageWidthPixels, "1 0 1 1 [0 0 0 0] {0.0, 0.0} w");
        this.add((Component)new JLabel("px"), "2 0 1 1 [0 0 0 10] {0.0, 0.0} w");
        this.imageWidthPercentage = new JSpinner(new SpinnerNumberModel(100, 0, Integer.MAX_VALUE, 1));
        editor = new JSpinner.NumberEditor(this.imageWidthPercentage);
        textField = editor.getTextField();
        textField.setColumns(4);
        this.imageWidthPercentage.addChangeListener(new ImageSizeFieldChangeListener(2.54, dotsPerInch));
        NumberFormatter formatter = (NumberFormatter)textField.getFormatter();
        formatter.setAllowsInvalid(false);
        this.imageWidthPercentage.setEditor(editor);
        this.imageWidthPercentage.setToolTipText("Increases / decreases width in percentage per 1%");
        this.add((Component)this.imageWidthPercentage, "3 0 1 1 [0 0 0 0] {0.0, 0.0} w");
        this.add((Component)new JLabel("%"), "4 0 1 1 [0 0 0 10] {0.0, 0.0} w");
        this.imageWidthCentimeters = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 2.147483647E9, 0.01));
        editor = new JSpinner.NumberEditor(this.imageWidthCentimeters);
        this.imageWidthCentimeters.addChangeListener(new ImageSizeFieldChangeListener(2.54, dotsPerInch));
        textField = editor.getTextField();
        textField.setColumns(4);
        formatter = (NumberFormatter)textField.getFormatter();
        formatter.setAllowsInvalid(false);
        NumberFormat twoDecimals = (NumberFormat)formatter.getFormat();
        twoDecimals.setMaximumFractionDigits(2);
        twoDecimals.setMinimumFractionDigits(2);
        formatter.setFormat(twoDecimals);
        this.imageWidthCentimeters.setEditor(editor);
        this.imageWidthCentimeters.setToolTipText("Increases / decreases width in centimeters per 0.01cm");
        this.add((Component)this.imageWidthCentimeters, "5 0 1 1 [0 0 0 0] {0.0, 0.0} w");
        this.add((Component)new JLabel("cm"), "6 0 1 1 [0 0 0 5] {0.0, 0.0} w");
        this.add((Component)new JLabel("Height:"), "0 1 1 1 [0 7 0 0] {0.0, 0.0} l");
        this.imageHeightPixels = new OptionJSpinner(this.key + ".Height", new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        editor = new JSpinner.NumberEditor(this.imageHeightPixels);
        textField = editor.getTextField();
        textField.setColumns(4);
        ((NumberFormatter)textField.getFormatter()).setAllowsInvalid(false);
        this.imageHeightPixels.addChangeListener(new ImageSizeFieldChangeListener(2.54, dotsPerInch));
        this.imageHeightPixels.setEditor(editor);
        this.imageHeightPixels.setToolTipText("Increases / decreases height in pixels per 1px");
        this.add((Component)this.imageHeightPixels, "1 1 1 1 [0 0 0 0] {0.0, 0.0} w");
        this.add((Component)new JLabel("px"), "2 1 1 1 [0 0 0 10] {0.0, 0.0} w");
        this.imageHeightPercentage = new JSpinner(new SpinnerNumberModel(100, 0, Integer.MAX_VALUE, 1));
        editor = new JSpinner.NumberEditor(this.imageHeightPercentage);
        this.imageHeightPercentage.addChangeListener(new ImageSizeFieldChangeListener(2.54, dotsPerInch));
        textField = editor.getTextField();
        textField.setColumns(4);
        formatter = (NumberFormatter)textField.getFormatter();
        formatter.setAllowsInvalid(false);
        this.imageHeightPercentage.setEditor(editor);
        this.imageHeightPercentage.setToolTipText("Increases / decreases height in percentage per 1%");
        this.add((Component)this.imageHeightPercentage, "3 1 1 1 [0 0 0 0] {0.0, 0.0} w");
        this.add((Component)new JLabel("%"), "4 1 1 1 [0 0 0 10] {0.0, 0.0} w");
        this.imageHeightCentimeters = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 2.147483647E9, 0.01));
        editor = new JSpinner.NumberEditor(this.imageHeightCentimeters);
        this.imageHeightCentimeters.addChangeListener(new ImageSizeFieldChangeListener(2.54, dotsPerInch));
        textField = editor.getTextField();
        textField.setColumns(4);
        formatter = (NumberFormatter)textField.getFormatter();
        formatter.setAllowsInvalid(false);
        twoDecimals = (NumberFormat)formatter.getFormat();
        twoDecimals.setMaximumFractionDigits(2);
        twoDecimals.setMinimumFractionDigits(2);
        formatter.setFormat(twoDecimals);
        this.imageHeightCentimeters.setEditor(editor);
        this.imageHeightCentimeters.setToolTipText("Increases / decreases height in centimeters per 0.01cm");
        this.add((Component)this.imageHeightCentimeters, "5 1 1 1 [0 0 0 0] {0.0, 0.0} w");
        this.add((Component)new JLabel("cm"), "6 1 1 1 [0 0 0 5] {0.0, 0.0} w");
        this.lockButton = new JToggleButton(this.isAspectRatioLocked ? UIIcons.addImageIcon("icons/chain-closed.png") : UIIcons.addImageIcon("icons/chain-open.png"), this.isAspectRatioLocked);
        this.lockButton.setToolTipText("Lock / unlock width - height ratio of image (i.e. aspect ratio)");
        this.lockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JToggleButton) {
                    JToggleButton source = (JToggleButton)e.getSource();
                    if (source.isSelected()) {
                        source.setIcon(UIIcons.addImageIcon("icons/chain-closed.png"));
                        ImageSizeUnitsPanel.this.isAspectRatioLocked = true;
                    } else {
                        source.setIcon(UIIcons.addImageIcon("icons/chain-open.png"));
                        ImageSizeUnitsPanel.this.isAspectRatioLocked = false;
                    }
                }
            }
        });
        this.add((Component)this.lockButton, "7 0 1 2 [0 0 0 0] h");
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        this.add((Component)filler, "8 0 2 1 [0 0 0 0] {1.0, 0.0} w");
        this.imageWidthPixels.setValue(this.initialDimension.width);
    }

    public boolean isAspectRatioLocked() {
        return this.isAspectRatioLocked;
    }

    public void setLockButtonEnabled(boolean isEnabled) {
        this.lockButton.setEnabled(isEnabled);
    }

    public void setLockButtonToolTipText(String tooltipText) {
        this.lockButton.setToolTipText(tooltipText);
    }

    public void addSizeChangeListener(ChangeListener listener) {
        this.imageWidthPixels.addChangeListener(listener);
        this.imageWidthPercentage.addChangeListener(listener);
        this.imageWidthCentimeters.addChangeListener(listener);
        this.imageHeightPixels.addChangeListener(listener);
        this.imageHeightPercentage.addChangeListener(listener);
        this.imageHeightCentimeters.addChangeListener(listener);
    }

    public void removeSizeChangeListener(ChangeListener listener) {
        this.imageWidthPixels.removeChangeListener(listener);
        this.imageWidthPercentage.removeChangeListener(listener);
        this.imageWidthCentimeters.removeChangeListener(listener);
        this.imageHeightPixels.removeChangeListener(listener);
        this.imageHeightPercentage.removeChangeListener(listener);
        this.imageHeightCentimeters.removeChangeListener(listener);
    }

    @Override
    public void setSize(int width, int height) {
        this.imageWidthPixels.setValue(new Integer(width));
        this.imageHeightPixels.setValue(new Integer(height));
    }

    @Override
    public boolean applyChangedOptions(Properties options) {
        Dimension size = new Dimension(((Number)this.imageWidthPixels.getValue()).intValue(), ((Number)this.imageHeightPixels.getValue()).intValue());
        return false;
    }

    public class ImageSizeFieldChangeListener
    implements ChangeListener {
        protected double inchToCMFactor = 2.54;
        protected int dpi = 96;

        public ImageSizeFieldChangeListener(double inchToCM, int theDPI) {
            this.inchToCMFactor = inchToCM;
            this.dpi = theDPI;
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            ArrayList<ChangeListener> pixelWidth = this.removeChangeListenersOfType(ImageSizeUnitsPanel.this.imageWidthPixels, ImageSizeFieldChangeListener.class);
            ArrayList<ChangeListener> pixelHeight = this.removeChangeListenersOfType(ImageSizeUnitsPanel.this.imageHeightPixels, ImageSizeFieldChangeListener.class);
            ArrayList<ChangeListener> percentageWidth = this.removeChangeListenersOfType(ImageSizeUnitsPanel.this.imageWidthPercentage, ImageSizeFieldChangeListener.class);
            ArrayList<ChangeListener> percentageHeight = this.removeChangeListenersOfType(ImageSizeUnitsPanel.this.imageHeightPercentage, ImageSizeFieldChangeListener.class);
            ArrayList<ChangeListener> centimetersWidth = this.removeChangeListenersOfType(ImageSizeUnitsPanel.this.imageWidthCentimeters, ImageSizeFieldChangeListener.class);
            ArrayList<ChangeListener> centimetersHeight = this.removeChangeListenersOfType(ImageSizeUnitsPanel.this.imageHeightCentimeters, ImageSizeFieldChangeListener.class);
            double aspectRatio = ImageSizeUnitsPanel.this.initialDimension.getWidth() / ImageSizeUnitsPanel.this.initialDimension.getHeight();
            boolean wasWidthChanged = false;
            if (ce.getSource() == ImageSizeUnitsPanel.this.imageWidthPixels) {
                int pixelsWidth = (Integer)ImageSizeUnitsPanel.this.imageWidthPixels.getValue();
                ImageSizeUnitsPanel.this.imageWidthPercentage.setValue(new Integer((int)Math.round(this.convertPixelsToPercentage(pixelsWidth, ImageSizeUnitsPanel.this.initialDimension.width))));
                ImageSizeUnitsPanel.this.imageWidthCentimeters.setValue(new Double(this.convertPixelsToCentimetres(pixelsWidth)));
                wasWidthChanged = true;
            } else if (ce.getSource() == ImageSizeUnitsPanel.this.imageWidthPercentage) {
                int percentWidth = (Integer)ImageSizeUnitsPanel.this.imageWidthPercentage.getValue();
                int pixels = (int)Math.round(this.convertPercentageToPixels(percentWidth, ImageSizeUnitsPanel.this.initialDimension.width));
                ImageSizeUnitsPanel.this.imageWidthPixels.setValue(new Integer(pixels));
                ImageSizeUnitsPanel.this.imageWidthCentimeters.setValue(new Double(this.convertPercentageToCentimetres(percentWidth, ImageSizeUnitsPanel.this.initialDimension.width)));
                wasWidthChanged = true;
            } else if (ce.getSource() == ImageSizeUnitsPanel.this.imageWidthCentimeters) {
                double centimeterWidth = (Double)ImageSizeUnitsPanel.this.imageWidthCentimeters.getValue();
                int pixels = (int)Math.round(this.convertCentimetersToPixels(centimeterWidth));
                ImageSizeUnitsPanel.this.imageWidthPixels.setValue(new Integer(pixels));
                ImageSizeUnitsPanel.this.imageWidthPercentage.setValue(new Integer((int)Math.round(this.convertCentimetersToPercentage(centimeterWidth, ImageSizeUnitsPanel.this.initialDimension.width))));
                wasWidthChanged = true;
            } else if (ce.getSource() == ImageSizeUnitsPanel.this.imageHeightPixels) {
                int pixelsHeight = (Integer)ImageSizeUnitsPanel.this.imageHeightPixels.getValue();
                ImageSizeUnitsPanel.this.imageHeightPercentage.setValue(new Integer((int)Math.round(this.convertPixelsToPercentage(pixelsHeight, ImageSizeUnitsPanel.this.initialDimension.height))));
                ImageSizeUnitsPanel.this.imageHeightCentimeters.setValue(new Double(this.convertPixelsToCentimetres(pixelsHeight)));
                wasWidthChanged = false;
            } else if (ce.getSource() == ImageSizeUnitsPanel.this.imageHeightPercentage) {
                int percentHeight = (Integer)ImageSizeUnitsPanel.this.imageHeightPercentage.getValue();
                int pixels = (int)Math.round(this.convertPercentageToPixels(percentHeight, ImageSizeUnitsPanel.this.initialDimension.height));
                ImageSizeUnitsPanel.this.imageHeightPixels.setValue(new Integer(pixels));
                ImageSizeUnitsPanel.this.imageHeightCentimeters.setValue(new Double(this.convertPercentageToCentimetres(percentHeight, ImageSizeUnitsPanel.this.initialDimension.height)));
                wasWidthChanged = false;
            } else if (ce.getSource() == ImageSizeUnitsPanel.this.imageHeightCentimeters) {
                double centimeterHeight = (Double)ImageSizeUnitsPanel.this.imageHeightCentimeters.getValue();
                int pixels = (int)Math.round(this.convertCentimetersToPixels(centimeterHeight));
                ImageSizeUnitsPanel.this.imageHeightPixels.setValue(new Integer(pixels));
                ImageSizeUnitsPanel.this.imageHeightPercentage.setValue(new Integer((int)Math.round(this.convertCentimetersToPercentage(centimeterHeight, ImageSizeUnitsPanel.this.initialDimension.height))));
                wasWidthChanged = false;
            }
            if (ImageSizeUnitsPanel.this.isAspectRatioLocked) {
                if (wasWidthChanged) {
                    int pixels = (Integer)ImageSizeUnitsPanel.this.imageWidthPixels.getValue();
                    ImageSizeUnitsPanel.this.imageHeightPixels.setValue(new Integer((int)Math.round((double)pixels / aspectRatio)));
                    ImageSizeUnitsPanel.this.imageHeightPercentage.setValue(new Integer((int)Math.round(this.convertPixelsToPercentage((int)Math.round((double)pixels / aspectRatio), ImageSizeUnitsPanel.this.initialDimension.height))));
                    ImageSizeUnitsPanel.this.imageHeightCentimeters.setValue(new Double((Double)ImageSizeUnitsPanel.this.imageWidthCentimeters.getValue() / aspectRatio));
                } else {
                    int pixels = (Integer)ImageSizeUnitsPanel.this.imageHeightPixels.getValue();
                    ImageSizeUnitsPanel.this.imageWidthPixels.setValue(new Integer((int)Math.round((double)pixels * aspectRatio)));
                    ImageSizeUnitsPanel.this.imageWidthPercentage.setValue(new Integer((int)Math.round(this.convertPixelsToPercentage((int)Math.round((double)pixels * aspectRatio), ImageSizeUnitsPanel.this.initialDimension.width))));
                    ImageSizeUnitsPanel.this.imageWidthCentimeters.setValue(new Double((Double)ImageSizeUnitsPanel.this.imageHeightCentimeters.getValue() * aspectRatio));
                }
            }
            this.addChangeListeners(ImageSizeUnitsPanel.this.imageWidthPixels, pixelWidth);
            this.addChangeListeners(ImageSizeUnitsPanel.this.imageHeightPixels, pixelHeight);
            this.addChangeListeners(ImageSizeUnitsPanel.this.imageWidthPercentage, percentageWidth);
            this.addChangeListeners(ImageSizeUnitsPanel.this.imageHeightPercentage, percentageHeight);
            this.addChangeListeners(ImageSizeUnitsPanel.this.imageWidthCentimeters, centimetersWidth);
            this.addChangeListeners(ImageSizeUnitsPanel.this.imageHeightCentimeters, centimetersHeight);
            ImageSizeUnitsPanel.this.properties.setProperty(ImageSizeUnitsPanel.this.key, (Integer)ImageSizeUnitsPanel.this.imageWidthPixels.getValue() + ", " + (Integer)ImageSizeUnitsPanel.this.imageHeightPixels.getValue());
        }

        public <T> ArrayList<ChangeListener> removeChangeListenersOfType(JSpinner spinner, Class<T> type) {
            ChangeListener[] spinnerListeners = spinner.getChangeListeners();
            ArrayList<ChangeListener> removedListeners = new ArrayList<ChangeListener>();
            for (ChangeListener listener : spinnerListeners) {
                if (!type.isInstance(listener)) continue;
                spinner.removeChangeListener(listener);
                removedListeners.add(listener);
            }
            return removedListeners;
        }

        public void addChangeListeners(JSpinner spinner, ArrayList<ChangeListener> listeners) {
            for (ChangeListener listener : listeners) {
                spinner.addChangeListener(listener);
            }
        }

        public double convertPixelsToPercentage(int pixels, int hundredPercentPixels) {
            return (double)pixels / (double)hundredPercentPixels * 100.0;
        }

        public double convertPixelsToCentimetres(double pixels) {
            return pixels / (double)this.dpi * this.inchToCMFactor;
        }

        public double convertPercentageToPixels(double percentage, int hundredPercentPixels) {
            return (double)hundredPercentPixels * (percentage / 100.0);
        }

        public double convertPercentageToCentimetres(double percentage, int hundredPercentPixels) {
            return this.convertPixelsToCentimetres(this.convertPercentageToPixels(percentage, hundredPercentPixels));
        }

        public double convertCentimetersToPixels(double centimetres) {
            return centimetres / this.inchToCMFactor * (double)this.dpi;
        }

        public double convertCentimetersToPercentage(double centimetres, int hundredPercentPixels) {
            return this.convertCentimetersToPixels(centimetres) / (double)hundredPercentPixels * 100.0;
        }
    }
}

