/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.ui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.WrapLayout;
import nl.rug.syntree.mainview.UIUtilities;
import nl.rug.syntree.mainview.components.UIBatikPreviewComponent;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class PreviewOptionsPanel
extends OptionPanel {
    protected String paperSizeKey = null;
    protected String initialPaperSize = null;
    protected String selectedPaperSize = null;
    protected String paperOrientationKey = null;
    protected String initialPaperOrientation = null;
    protected String selectedPaperOrientation = null;
    protected UIBatikPreviewComponent previewComponent = null;
    protected JScrollPane previewViewport = null;

    public PreviewOptionsPanel(Properties options, String theRootKey, String title, Component component, UIBatikPreviewComponent thePreviewComponent, JScrollPane previewContainer) {
        super(title);
        this.paperSizeKey = theRootKey + "." + "PaperSize";
        this.paperOrientationKey = theRootKey + "." + "PaperOrientation";
        this.previewComponent = thePreviewComponent;
        this.previewViewport = previewContainer;
        UserProperties user = new UserProperties(options);
        String paperSize = user.getProperty(this.paperSizeKey);
        this.initialPaperSize = paperSize == null ? UIBatikPreviewComponent.PaperSizes.A4.getName() : paperSize;
        this.selectedPaperSize = this.initialPaperSize;
        String paperOrientation = user.getProperty(this.paperOrientationKey);
        this.initialPaperOrientation = paperOrientation == null ? UIBatikPreviewComponent.PaperOrientations.PORTRAIT.getName() : paperOrientation;
        this.selectedPaperOrientation = this.initialPaperOrientation;
        this.initComponent(options, component);
    }

    protected void initComponent(final Properties options, final Component component) {
        this.setLayout(new WrapLayout(0, 3, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.add(new JLabel("Preview"));
        UIBatikPreviewComponent.PaperOrientations[] paperOrientations = UIBatikPreviewComponent.PaperOrientations.values();
        String[] values = new String[paperOrientations.length];
        for (int i = 0; i < paperOrientations.length; ++i) {
            values[i] = paperOrientations[i].getName();
        }
        OptionComboBox orientationSelector = new OptionComboBox(options, this.paperOrientationKey, values);
        options.setProperty(this.paperOrientationKey, UIBatikPreviewComponent.PaperOrientations.PORTRAIT.getName());
        orientationSelector.setSelectedItem(UIBatikPreviewComponent.PaperOrientations.PORTRAIT.getName());
        orientationSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                String newSelectedItem = (String)ie.getItem();
                if (!newSelectedItem.equals(PreviewOptionsPanel.this.selectedPaperOrientation)) {
                    PreviewOptionsPanel.this.selectedPaperOrientation = newSelectedItem;
                    options.setProperty(PreviewOptionsPanel.this.paperOrientationKey, newSelectedItem);
                    try {
                        if (PreviewOptionsPanel.this.previewComponent != null) {
                            PreviewOptionsPanel.this.previewComponent.generatePreview(component, options, false);
                        }
                        if (PreviewOptionsPanel.this.previewViewport != null) {
                            PreviewOptionsPanel.this.previewViewport.revalidate();
                        }
                        if (PreviewOptionsPanel.this.previewComponent != null) {
                            PreviewOptionsPanel.this.previewComponent.repaint();
                        }
                    }
                    catch (Exception e) {
                        UIUtilities.handleException(e, SwingUtilities.getWindowAncestor(PreviewOptionsPanel.this), null);
                    }
                }
            }
        });
        UIBatikPreviewComponent.PaperSizes[] paperSizes = UIBatikPreviewComponent.PaperSizes.values();
        values = new String[paperSizes.length + 1];
        for (int i = 0; i < paperSizes.length; ++i) {
            values[i + 1] = paperSizes[i].getName();
        }
        values[0] = "Screen (1:1)";
        OptionComboBox sizeSelector = new OptionComboBox(options, this.paperSizeKey, values);
        options.setProperty(this.paperSizeKey, UIBatikPreviewComponent.PaperSizes.A4.name());
        sizeSelector.setSelectedItem(UIBatikPreviewComponent.PaperSizes.A4.name());
        sizeSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                String newSelectedItem;
                if (ie.getStateChange() == 1 && !(newSelectedItem = (String)ie.getItem()).equals(PreviewOptionsPanel.this.selectedPaperSize)) {
                    PreviewOptionsPanel.this.selectedPaperSize = newSelectedItem;
                    options.setProperty(PreviewOptionsPanel.this.paperSizeKey, newSelectedItem);
                    if (PreviewOptionsPanel.this.selectedPaperSize.equals("Screen (1:1)")) {
                        if (PreviewOptionsPanel.this.previewViewport != null) {
                            PreviewOptionsPanel.this.previewViewport.setHorizontalScrollBarPolicy(30);
                            PreviewOptionsPanel.this.previewViewport.getVerticalScrollBar().setUnitIncrement(10);
                            PreviewOptionsPanel.this.previewViewport.setVerticalScrollBarPolicy(20);
                            PreviewOptionsPanel.this.previewViewport.getHorizontalScrollBar().setUnitIncrement(10);
                        }
                    } else if (PreviewOptionsPanel.this.previewViewport != null) {
                        PreviewOptionsPanel.this.previewViewport.setHorizontalScrollBarPolicy(31);
                        PreviewOptionsPanel.this.previewViewport.setVerticalScrollBarPolicy(21);
                    }
                    try {
                        if (PreviewOptionsPanel.this.previewComponent != null) {
                            PreviewOptionsPanel.this.previewComponent.generatePreview(component, options, false);
                        }
                        if (PreviewOptionsPanel.this.previewViewport != null) {
                            PreviewOptionsPanel.this.previewViewport.revalidate();
                        }
                        if (PreviewOptionsPanel.this.previewComponent != null) {
                            PreviewOptionsPanel.this.previewComponent.repaint();
                        }
                    }
                    catch (Exception e) {
                        UIUtilities.handleException(e, SwingUtilities.getWindowAncestor(PreviewOptionsPanel.this), null);
                    }
                }
            }
        });
        this.add(sizeSelector);
        this.add(orientationSelector);
    }

    @Override
    public boolean applyChangedOptions(Properties options) {
        boolean changed = super.applyChangedOptions(options);
        if (!this.selectedPaperSize.equals(this.initialPaperSize)) {
            options.setProperty(this.paperSizeKey, this.selectedPaperSize);
            changed = true;
        }
        if (!this.selectedPaperOrientation.equals(this.initialPaperOrientation)) {
            options.setProperty(this.paperOrientationKey, this.selectedPaperOrientation);
            changed = true;
        }
        return changed;
    }
}

