/*
 * Decompiled with CFR 0.152.
 */
package nl.rug.syntree.hierarchicalmodel.exporters.ui;

import java.awt.Component;
import java.util.Properties;
import javax.swing.BoundedRangeModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.OptionJSlider;
import nl.rug.syntree.hierarchicalmodel.exporters.ui.OptionJSpinner;
import org.freehep.graphicsio.exportchooser.OptionPanel;

public class SliderPanel
extends OptionPanel {
    protected OptionJSlider slider = null;
    protected OptionJSpinner spinner = null;

    public SliderPanel(Properties options, String optionKey, String title) {
        super(title);
        float quality = Float.parseFloat(options.getProperty(optionKey)) * 100.0f;
        this.slider = new OptionJSlider(optionKey, 0, 100, Math.round(quality));
        this.spinner = new OptionJSpinner(optionKey, new SpinnerNumberModel(Math.round(quality), 0, 100, 1));
        this.slider.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BoundedRangeModel spinnerModel = (BoundedRangeModel)e.getSource();
                SliderPanel.this.spinner.getModel().setValue(spinnerModel.getValue());
            }
        });
        this.spinner.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerNumberModel sliderModel = (SpinnerNumberModel)e.getSource();
                SliderPanel.this.slider.setValue((Integer)sliderModel.getValue());
            }
        });
        this.add((Component)this.slider, "0 * [0 0 0 10] w");
        this.add((Component)this.spinner, "1 * [0 0 0 0] w");
    }

    public OptionJSlider getSlider() {
        return this.slider;
    }

    public OptionJSpinner getSpinner() {
        return this.spinner;
    }
}

